/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class CreatePackage {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="name")
    private JsonNullable<String> name;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="description")
    private JsonNullable<String> description;

    @JsonCreator
    public CreatePackage(@JsonProperty(value="name") JsonNullable<String> name, @JsonProperty(value="description") JsonNullable<String> description) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(description, "description");
        this.name = name;
        this.description = description;
    }

    public CreatePackage() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> name() {
        return this.name;
    }

    @JsonIgnore
    public JsonNullable<String> description() {
        return this.description;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CreatePackage withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of((Object)name);
        return this;
    }

    public CreatePackage withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public CreatePackage withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    public CreatePackage withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePackage other = (CreatePackage)o;
        return Utils.enhancedDeepEquals(this.name, other.name) && Utils.enhancedDeepEquals(this.description, other.description);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.name, this.description);
    }

    public String toString() {
        return Utils.toString(CreatePackage.class, "name", this.name, "description", this.description);
    }

    public static final class Builder {
        private JsonNullable<String> name = JsonNullable.undefined();
        private JsonNullable<String> description = JsonNullable.undefined();

        private Builder() {
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of((Object)name);
            return this;
        }

        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of((Object)description);
            return this;
        }

        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }

        public CreatePackage build() {
            return new CreatePackage(this.name, this.description);
        }
    }
}

