/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;

public class CustomFieldOption {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="value")
    private String value;

    @JsonCreator
    public CustomFieldOption(@JsonProperty(value="id") String id, @JsonProperty(value="value") String value) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(value, "value");
        this.id = id;
        this.value = value;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String value() {
        return this.value;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CustomFieldOption withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public CustomFieldOption withValue(String value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFieldOption other = (CustomFieldOption)o;
        return Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.value, other.value);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.id, this.value);
    }

    public String toString() {
        return Utils.toString(CustomFieldOption.class, "id", this.id, "value", this.value);
    }

    public static final class Builder {
        private String id;
        private String value;

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder value(String value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public CustomFieldOption build() {
            return new CustomFieldOption(this.id, this.value);
        }
    }
}

