/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.QuestionSourceValue;
import com.stackone.stackone_client_java.models.components.QuestionValue;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class QuestionType {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends QuestionValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends QuestionSourceValue> sourceValue;

    @JsonCreator
    public QuestionType(@JsonProperty(value="value") JsonNullable<? extends QuestionValue> value, @JsonProperty(value="source_value") JsonNullable<? extends QuestionSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public QuestionType() {
        this((JsonNullable<? extends QuestionValue>)JsonNullable.undefined(), (JsonNullable<? extends QuestionSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<QuestionValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<QuestionSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public QuestionType withValue(QuestionValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public QuestionType withValue(JsonNullable<? extends QuestionValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public QuestionType withSourceValue(QuestionSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public QuestionType withSourceValue(JsonNullable<? extends QuestionSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuestionType other = (QuestionType)o;
        return Utils.enhancedDeepEquals(this.value, other.value) && Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(QuestionType.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends QuestionValue> value = JsonNullable.undefined();
        private JsonNullable<? extends QuestionSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(QuestionValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends QuestionValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(QuestionSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends QuestionSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public QuestionType build() {
            return new QuestionType(this.value, this.sourceValue);
        }
    }
}

