/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.TaskStatusSourceValue;
import com.stackone.stackone_client_java.models.components.TaskStatusValue;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class TaskStatus {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends TaskStatusValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends TaskStatusSourceValue> sourceValue;

    @JsonCreator
    public TaskStatus(@JsonProperty(value="value") JsonNullable<? extends TaskStatusValue> value, @JsonProperty(value="source_value") JsonNullable<? extends TaskStatusSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public TaskStatus() {
        this((JsonNullable<? extends TaskStatusValue>)JsonNullable.undefined(), (JsonNullable<? extends TaskStatusSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<TaskStatusValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<TaskStatusSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public TaskStatus withValue(TaskStatusValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public TaskStatus withValue(JsonNullable<? extends TaskStatusValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public TaskStatus withSourceValue(TaskStatusSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public TaskStatus withSourceValue(JsonNullable<? extends TaskStatusSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskStatus other = (TaskStatus)o;
        return Utils.enhancedDeepEquals(this.value, other.value) && Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(TaskStatus.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends TaskStatusValue> value = JsonNullable.undefined();
        private JsonNullable<? extends TaskStatusSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(TaskStatusValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends TaskStatusValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(TaskStatusSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends TaskStatusSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public TaskStatus build() {
            return new TaskStatus(this.value, this.sourceValue);
        }
    }
}

