/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.InterviewStagesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsListInterviewStagesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends InterviewStagesPaginated> interviewStagesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsListInterviewStagesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends InterviewStagesPaginated> interviewStagesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(interviewStagesPaginated, "interviewStagesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.interviewStagesPaginated = interviewStagesPaginated;
        this.headers = headers;
    }

    public AtsListInterviewStagesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<InterviewStagesPaginated> interviewStagesPaginated() {
        return this.interviewStagesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsListInterviewStagesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListInterviewStagesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListInterviewStagesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListInterviewStagesResponse withInterviewStagesPaginated(InterviewStagesPaginated interviewStagesPaginated) {
        Utils.checkNotNull(interviewStagesPaginated, "interviewStagesPaginated");
        this.interviewStagesPaginated = Optional.ofNullable(interviewStagesPaginated);
        return this;
    }

    public AtsListInterviewStagesResponse withInterviewStagesPaginated(Optional<? extends InterviewStagesPaginated> interviewStagesPaginated) {
        Utils.checkNotNull(interviewStagesPaginated, "interviewStagesPaginated");
        this.interviewStagesPaginated = interviewStagesPaginated;
        return this;
    }

    public AtsListInterviewStagesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListInterviewStagesResponse other = (AtsListInterviewStagesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.interviewStagesPaginated, other.interviewStagesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.interviewStagesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListInterviewStagesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "interviewStagesPaginated", this.interviewStagesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends InterviewStagesPaginated> interviewStagesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder interviewStagesPaginated(InterviewStagesPaginated interviewStagesPaginated) {
            Utils.checkNotNull(interviewStagesPaginated, "interviewStagesPaginated");
            this.interviewStagesPaginated = Optional.ofNullable(interviewStagesPaginated);
            return this;
        }

        public Builder interviewStagesPaginated(Optional<? extends InterviewStagesPaginated> interviewStagesPaginated) {
            Utils.checkNotNull(interviewStagesPaginated, "interviewStagesPaginated");
            this.interviewStagesPaginated = interviewStagesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsListInterviewStagesResponse build() {
            return new AtsListInterviewStagesResponse(this.contentType, this.statusCode, this.rawResponse, this.interviewStagesPaginated, this.headers);
        }
    }
}

