/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ContentBlockResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MarketingGetContentBlockResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ContentBlockResult> contentBlockResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public MarketingGetContentBlockResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ContentBlockResult> contentBlockResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(contentBlockResult, "contentBlockResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.contentBlockResult = contentBlockResult;
        this.headers = headers;
    }

    public MarketingGetContentBlockResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ContentBlockResult> contentBlockResult() {
        return this.contentBlockResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public MarketingGetContentBlockResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MarketingGetContentBlockResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MarketingGetContentBlockResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MarketingGetContentBlockResponse withContentBlockResult(ContentBlockResult contentBlockResult) {
        Utils.checkNotNull(contentBlockResult, "contentBlockResult");
        this.contentBlockResult = Optional.ofNullable(contentBlockResult);
        return this;
    }

    public MarketingGetContentBlockResponse withContentBlockResult(Optional<? extends ContentBlockResult> contentBlockResult) {
        Utils.checkNotNull(contentBlockResult, "contentBlockResult");
        this.contentBlockResult = contentBlockResult;
        return this;
    }

    public MarketingGetContentBlockResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingGetContentBlockResponse other = (MarketingGetContentBlockResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.contentBlockResult, other.contentBlockResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.contentBlockResult, this.headers);
    }

    public String toString() {
        return Utils.toString(MarketingGetContentBlockResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "contentBlockResult", this.contentBlockResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ContentBlockResult> contentBlockResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder contentBlockResult(ContentBlockResult contentBlockResult) {
            Utils.checkNotNull(contentBlockResult, "contentBlockResult");
            this.contentBlockResult = Optional.ofNullable(contentBlockResult);
            return this;
        }

        public Builder contentBlockResult(Optional<? extends ContentBlockResult> contentBlockResult) {
            Utils.checkNotNull(contentBlockResult, "contentBlockResult");
            this.contentBlockResult = contentBlockResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MarketingGetContentBlockResponse build() {
            return new MarketingGetContentBlockResponse(this.contentType, this.statusCode, this.rawResponse, this.contentBlockResult, this.headers);
        }
    }
}

