/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.utils.pagination;
import com.jayway.jsonpath.ReadContext;

import static com.stackone.stackone_client_java.utils.Utils.castLong;

// Internal API only

/**
 * Handles pagination based on the number of results in each response.
 * This tracker is suitable for APIs that return a count of items in each response
 * and use that to determine if there are more pages.
 *
 * @param <ProgressParamT> The numeric type to use for offset values (e.g., Integer, Long)
 */
public class OffsetTracker<ProgressParamT extends Number> implements ProgressTrackerStrategy<ProgressParamT> {
    private final String resultSizeExpression;
    private final long minItems;
    private final Class<ProgressParamT> offsetType;

    private long currentValue;

    /**
     * Creates a new OffsetTracker with a specified initial offset.
     *
     * @param resultSizeExpression The JsonPath expression to extract result count
     * @param offsetType           The class of the numeric type to use (e.g., Integer.class, Long.class)
     * @param initialOffset        Initial offset value to start pagination from
     * @param minItems             Minimum number of items required to continue pagination
     */
    public OffsetTracker(
            String resultSizeExpression,
            Class<ProgressParamT> offsetType,
            long initialOffset,
            long minItems) {
        this.resultSizeExpression = resultSizeExpression;
        this.minItems = minItems;
        this.offsetType = offsetType;
        this.currentValue = initialOffset;
    }

    @Override
    public boolean advance(ReadContext respJson) {
        Long numItems = respJson.read(resultSizeExpression, Long.class);
        if (numItems == null) {
            numItems = 0L;
        }

        if (numItems < minItems) {
            return false;
        }

        currentValue += numItems;
        return true;
    }

    @Override
    public ProgressParamT getPosition() {
        return castLong(currentValue, offsetType);
    }
}