/*
 * Decompiled with CFR 0.152.
 */
package com.stateforge.statebuilder.java;

import com.stateforge.statebuilder.CoderBase;
import com.stateforge.statebuilder.StateBuilderException;
import com.stateforge.statebuilder.model.Parameter;
import com.stateforge.statebuilder.model.State;
import com.stateforge.statebuilder.model.StateKind;
import com.stateforge.statebuilder.model.StateMachineModel;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JStatement;

public abstract class CoderBaseJava
extends CoderBase {
    private JCodeModel code;
    private JPackage m_package;

    public CoderBaseJava(StateMachineModel model, JCodeModel code) {
        super(model);
        this.code = code;
        this.m_package = code._package(this.getModel().getStateMachine().getSettings().getNamespace());
    }

    protected JCodeModel getCode() {
        return this.code;
    }

    protected JPackage getPackage() {
        return this.m_package;
    }

    protected void addParameter(JMethod method, Parameter parameter) throws StateBuilderException {
        try {
            int mod = 0;
            if (parameter.isConst()) {
                mod = 8;
            }
            method.param(mod, this.getCode().parseType(parameter.getType()), parameter.getName());
        }
        catch (ClassNotFoundException e) {
            throw new StateBuilderException((Throwable)e);
        }
    }

    protected String getAbstractContextClassName(State state) throws StateBuilderException {
        return "Abstract" + this.getContextClassName(state);
    }

    protected String getParallelLocalVariableName(State state) {
        return "parallel" + state.getName();
    }

    protected String getParallelFieldName(State state) {
        return "_parallel" + state.getName();
    }

    protected String getParallelClassName(State state) {
        return this.getModel().getStateMachine().getSettings().getName() + state.getName() + "Parallel";
    }

    protected void writeProcessTransition(State state, State stateNext, JBlock block, String suffix) throws StateBuilderException {
        JExpression contextExpression = this.getContextParentExpression(state, stateNext);
        JInvocation paramInvokation = this.getCode().directClass("com.stateforge.statemachine.algorithm.StateOperation").staticInvoke("processTransition" + suffix).arg(contextExpression);
        if (stateNext == null) {
            paramInvokation = paramInvokation.arg(JExpr._null());
        } else if (stateNext.getKind() == StateKind.HISTORY) {
            paramInvokation = paramInvokation.arg((JExpression)JExpr.ref((String)this.getModel().getContextInstance()).invoke("getStateHistory"));
        } else {
            State stateLeaf = this.getModel().getStateLeaf(stateNext);
            String stateNextClassName = this.getStateClassName(stateLeaf);
            paramInvokation = paramInvokation.arg((JExpression)JExpr.ref((String)stateNextClassName).invoke("getInstance"));
        }
        block.add((JStatement)paramInvokation);
    }

    protected void writeContextOnEnd(State state, State stateNext, JBlock block) throws StateBuilderException {
        if (stateNext != null && stateNext.getKind() == StateKind.FINAL) {
            block.add((JStatement)this.getContextParentExpression(state, stateNext).invoke("onEnd"));
        }
    }

    public JExpression getContextParentExpression(State state, State stateNext) throws StateBuilderException {
        JFieldRef invokation = JExpr.ref((String)this.getModel().getContextInstance());
        int contextDepth = this.getModel().contextDepth(state, stateNext);
        for (int i = 1; i <= contextDepth; ++i) {
            invokation = invokation.invoke("getContextParent");
        }
        return invokation;
    }
}

