/*
 * Decompiled with CFR 0.152.
 */
package com.stateforge.statebuilder.java;

import com.stateforge.statebuilder.StateBuilderException;
import com.stateforge.statebuilder.java.CoderBaseJava;
import com.stateforge.statebuilder.model.Event;
import com.stateforge.statebuilder.model.ObjectType;
import com.stateforge.statebuilder.model.Parameter;
import com.stateforge.statebuilder.model.State;
import com.stateforge.statebuilder.model.StateMachineModel;
import com.stateforge.statebuilder.model.Timer;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CoderContext
extends CoderBaseJava {
    public CoderContext(StateMachineModel model, JCodeModel code) {
        super(model, code);
    }

    public void code() throws StateBuilderException {
        this.write(this.getModel().getStateMachine().getState());
    }

    private void write(State state) throws StateBuilderException {
        if (state.isTop()) {
            try {
                String contextClassName = this.getModel().getStateMachine().getSettings().getNamespace() + "." + this.getContextClassName(state);
                JDefinedClass contextClass = this.getCode()._class(contextClassName);
                String contextParentClassName = this.getContextParentClassName(state);
                String stateTopClassName = this.getStateClassName(this.getModel().getStateTop(state));
                JClass parentClass = this.getCode().directClass("com.stateforge.statemachine.context.AbstractContext");
                JClass parentContextTypeVar = this.getCode().directClass(contextParentClassName);
                JClass topStateTypeVar = this.getCode().directClass(stateTopClassName);
                contextClass._extends(parentClass.narrow(new JClass[]{topStateTypeVar, parentContextTypeVar}));
                JMethod constructor = this.writeContructor(state, contextClass);
                this.writeEnterInitialState(state, contextClass);
                this.writeLeaveCurrentState(state, contextClass);
                this.writeEvents(state, contextClass);
                this.writeTimers(state, contextClass, constructor);
                this.writeParallel(state, contextClass, constructor);
            }
            catch (Exception e) {
                throw new StateBuilderException((Throwable)e);
            }
        }
        if (state.getParallel() != null) {
            for (State stateOrthogonal : state.getParallel().getState()) {
                this.write(stateOrthogonal);
            }
        }
        for (State stateChild : state.getState()) {
            this.write(stateChild);
        }
    }

    private void writeTimers(State state, JDefinedClass contextClass, JMethod constructor) {
        if (!state.isRoot()) {
            return;
        }
        for (Timer timer : this.getModel().getTimersAll()) {
            this.writeTimer(contextClass, timer, constructor);
        }
    }

    private void writeTimer(JDefinedClass contextClass, Timer timer, JMethod contructor) {
        JClass scheduledFutureClass = this.getCode().ref(ScheduledFuture.class);
        JFieldVar timerScheduledFuture = contextClass.field(4, (JType)scheduledFutureClass, "my" + timer.getName() + "ScheduledFuture");
        this.writeTimerStart(contextClass, timer, (JVar)timerScheduledFuture);
        this.writeTimerStop(contextClass, timer, (JVar)timerScheduledFuture);
    }

    private void writeTimerStart(JDefinedClass contextClass, Timer timer, JVar timerField) {
        JMethod timerStartMethod = contextClass.method(1, Void.TYPE, "timerStart" + timer.getName());
        timerStartMethod.javadoc().add((Object)("Start the timer " + timer.getName()));
        timerStartMethod.param((JType)this.getCode().directClass("long"), "duration");
        JBlock block = timerStartMethod.body();
        block.add((JStatement)JExpr.invoke((String)"getObserver").invoke("onTimerStart").arg((JExpression)JExpr._this().invoke("getName")).arg(JExpr.lit((String)timer.getName())).arg((JExpression)JExpr.ref((String)"duration")));
        block.decl(8, (JType)contextClass, "me", JExpr._this());
        JDefinedClass anon = this.getCode().anonymousClass(Runnable.class);
        JMethod runMethod = anon.method(1, Void.TYPE, "run");
        JBlock runBlock = runMethod.body();
        JTryBlock tryBlock = runBlock._try();
        tryBlock.body().invoke((JExpression)JExpr.invoke((String)"getStateCurrent"), timer.getId()).arg((JExpression)JExpr.ref((String)"me"));
        this.addCatchBlockPrintException(tryBlock);
        JInvocation invokation = JExpr.invoke((String)"getExecutorService").invoke("schedule").arg((JExpression)JExpr._new((JClass)anon)).arg((JExpression)JExpr.ref((String)"duration")).arg((JExpression)this.getCode().ref(TimeUnit.class).staticRef("MILLISECONDS"));
        block.assign((JAssignmentTarget)timerField, (JExpression)invokation);
    }

    private void writeTimerStop(JDefinedClass contextClass, Timer timer, JVar timerField) {
        JMethod timerStopMethod = contextClass.method(1, Void.TYPE, "timerStop" + timer.getName());
        timerStopMethod.javadoc().add((Object)("Stop the timer " + timer.getName()));
        JBlock block = timerStopMethod.body();
        block.add((JStatement)JExpr.invoke((String)"getObserver").invoke("onTimerStop").arg((JExpression)JExpr._this().invoke("getName")).arg(JExpr.lit((String)timer.getName())));
        block._if(timerField.ne(JExpr._null()))._then().add((JStatement)timerField.invoke("cancel").arg(JExpr.FALSE));
    }

    private JMethod writeContructor(State state, JDefinedClass contextClass) throws StateBuilderException {
        JMethod constructor = contextClass.constructor(1);
        String contextParentClassName = this.getContextParentClassName(state);
        constructor.javadoc().add((Object)"Context constructor");
        String contextClassName = this.getContextClassName(state);
        JBlock block = constructor.body();
        JInvocation superInvokation = block.invoke("super");
        for (ObjectType obj : this.getModel().getStateMachine().getSettings().getObject()) {
            String objFullClassName = !obj.getInclude().isEmpty() ? obj.getInclude() + "." + obj.getClazz() : obj.getClazz();
            JVar objParam = constructor.param((JType)this.getCode().directClass(objFullClassName), obj.getInstance());
            JFieldVar objField = contextClass.field(4, (JType)this.getCode().directClass(objFullClassName), "_" + obj.getInstance());
            constructor.body().assign((JAssignmentTarget)objField, (JExpression)objParam);
            JMethod getter = contextClass.method(1, (JType)this.getCode().directClass(objFullClassName), "get" + obj.getClazz());
            getter.body()._return((JExpression)objField);
        }
        if (!state.isRoot()) {
            superInvokation.arg((JExpression)constructor.param((JType)this.getCode().directClass(contextParentClassName), "contextParent"));
        }
        block.invoke("setName").arg(contextClassName);
        block.invoke("setInitialState").arg((JExpression)JExpr.ref((String)this.getStateClassName(this.getModel().getStateLeaf(state))).invoke("getInstance"));
        return constructor;
    }

    private void writeParallel(State state, JDefinedClass abstractContext, JMethod constructor) {
        for (State stateParallel : state.getParallelList()) {
            JClass parallelClass = this.getCode().directClass(this.getParallelClassName(stateParallel));
            JFieldVar parallelField = abstractContext.field(4, (JType)parallelClass, this.getParallelFieldName(stateParallel));
            JInvocation parallelCreateInvokation = JExpr._new((JClass)parallelClass);
            parallelCreateInvokation = parallelCreateInvokation.arg(JExpr._this());
            for (ObjectType obj : this.getModel().getStateMachine().getSettings().getObject()) {
                parallelCreateInvokation = parallelCreateInvokation.arg((JExpression)JExpr.ref((String)obj.getInstance()));
            }
            constructor.body().assign((JAssignmentTarget)parallelField, (JExpression)parallelCreateInvokation);
            JMethod getter = abstractContext.method(1, (JType)parallelClass, "get" + this.getParallelClassName(stateParallel));
            getter.body()._return((JExpression)parallelField);
        }
    }

    private void writeEvents(State state, JDefinedClass contextClass) throws ClassNotFoundException {
        for (Event event : this.getModel().getEventsAll()) {
            this.writeEventAsync(state, event, contextClass);
            this.writeEventSync(state, event, contextClass);
        }
    }

    private void writeEventSync(State state, Event event, JDefinedClass contextClass) throws ClassNotFoundException {
        if (this.getModel().getStateMachine().getSettings().isAsynchronous() && state.isRoot()) {
            return;
        }
        int mod = 1;
        String eventMethodName = event.getId();
        JMethod eventMethod = contextClass.method(mod, Void.TYPE, eventMethodName);
        eventMethod.javadoc().add((Object)("Event " + event.getId()));
        JBlock block = eventMethod.body();
        JInvocation superInvokation = block.invoke((JExpression)JExpr.invoke((String)"getStateCurrent"), event.getId()).arg(JExpr._this());
        for (Parameter parameter : event.getParameter()) {
            eventMethod.param(this.getCode().parseType(parameter.getType()), parameter.getName());
            superInvokation = superInvokation.arg((JExpression)JExpr.ref((String)parameter.getName()));
        }
    }

    private void writeEventAsync(State state, Event event, JDefinedClass contextClass) throws ClassNotFoundException {
        if (!this.getModel().getStateMachine().getSettings().isAsynchronous() || !state.isRoot()) {
            return;
        }
        if (event instanceof Timer) {
            return;
        }
        JMethod eventMethod = contextClass.method(1, Void.TYPE, event.getId());
        eventMethod.javadoc().add((Object)("Asynchronous event " + event.getId()));
        JBlock block = eventMethod.body();
        block.decl(8, (JType)contextClass, "me", JExpr._this());
        JDefinedClass anon = this.getCode().anonymousClass(Runnable.class);
        JMethod runMethod = anon.method(1, Void.TYPE, "run");
        JBlock runBlock = runMethod.body();
        JTryBlock tryBlock = runBlock._try();
        JInvocation syncInvokation = JExpr.invoke((String)"getStateCurrent").invoke(event.getId()).arg((JExpression)JExpr.ref((String)"me"));
        for (Parameter parameter : event.getParameter()) {
            eventMethod.param(8, this.getCode().parseType(parameter.getType()), parameter.getName());
            syncInvokation = syncInvokation.arg((JExpression)JExpr.ref((String)parameter.getName()));
        }
        tryBlock.body().add((JStatement)syncInvokation);
        this.addCatchBlockPrintException(tryBlock);
        JInvocation invokation = JExpr.invoke((String)"getExecutorService").invoke("execute").arg((JExpression)JExpr._new((JClass)anon));
        block.add((JStatement)invokation);
    }

    private void addCatchBlockPrintException(JTryBlock tryBlock) {
        JCatchBlock catchBlock = tryBlock._catch(this.getCode().ref(Exception.class));
        JVar exceptionParam = catchBlock.param("exception");
        JBlock catchBody = catchBlock.body();
        catchBody.add((JStatement)JExpr.invoke((String)"onEnd").arg((JExpression)exceptionParam));
    }

    private void writeEnterInitialState(State state, JDefinedClass contextClass) throws StateBuilderException {
        JMethod enterInitialStateMethod = contextClass.method(1, Void.TYPE, "enterInitialState");
        enterInitialStateMethod.javadoc().add((Object)"Enter the initial state");
        JBlock block = enterInitialStateMethod.body();
        JInvocation invokation = block.staticInvoke(this.getCode().directClass("com.stateforge.statemachine.algorithm.StateOperation"), "walkTreeEntry");
        invokation = invokation.arg(JExpr._this());
        invokation = invokation.arg((JExpression)JExpr.ref((String)this.getStateClassName(this.getModel().getStateTop(state))).invoke("getInstance"));
        invokation = invokation.arg((JExpression)JExpr.ref((String)this.getStateClassName(this.getModel().getStateLeaf(state))).invoke("getInstance"));
    }

    private void writeLeaveCurrentState(State state, JDefinedClass contextClass) throws StateBuilderException {
        JMethod leaveCurrentStateMethod = contextClass.method(1, Void.TYPE, "leaveCurrentState");
        leaveCurrentStateMethod.javadoc().add((Object)"Leave the current state");
        JBlock block = leaveCurrentStateMethod.body();
        JInvocation invokation = block.staticInvoke(this.getCode().directClass("com.stateforge.statemachine.algorithm.StateOperation"), "walkTreeExit");
        invokation = invokation.arg(JExpr._this());
        invokation = invokation.arg((JExpression)JExpr._this().invoke("getStateCurrent"));
        invokation = invokation.arg((JExpression)JExpr.ref((String)this.getStateClassName(this.getModel().getStateTop(state))).invoke("getInstance"));
    }
}

