/*
 * Decompiled with CFR 0.152.
 */
package com.stateforge.statebuilder.java;

import com.stateforge.statebuilder.StateBuilderException;
import com.stateforge.statebuilder.java.CoderBaseJava;
import com.stateforge.statebuilder.model.Actions;
import com.stateforge.statebuilder.model.Event;
import com.stateforge.statebuilder.model.ObjectType;
import com.stateforge.statebuilder.model.Parameter;
import com.stateforge.statebuilder.model.State;
import com.stateforge.statebuilder.model.StateKind;
import com.stateforge.statebuilder.model.StateMachineModel;
import com.stateforge.statebuilder.model.TimerStartAction;
import com.stateforge.statebuilder.model.TimerStopAction;
import com.stateforge.statebuilder.model.Transition;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.List;

public class CoderState
extends CoderBaseJava {
    public CoderState(StateMachineModel model, JCodeModel code) {
        super(model, code);
    }

    public void code() throws StateBuilderException {
        this.write(this.getModel().getStateMachine().getState());
    }

    private void write(State state) throws StateBuilderException {
        try {
            JDefinedClass stateClass = this.getCode()._class(this.getModel().getStateMachine().getSettings().getNamespace() + "." + this.getStateClassName(state));
            if (state.getParent() != null) {
                stateClass._extends(this.getCode().directClass(this.getStateClassName(state.getParent())));
            } else {
                JClass parentClass = this.getCode().directClass("com.stateforge.statemachine.state.AbstractState");
                JClass contextClass = this.getCode().directClass(this.getContextClassName(state));
                JClass topStateClass = this.getCode().directClass(this.getStateClassName(this.getModel().getStateTop(state)));
                stateClass._extends(parentClass.narrow(new JClass[]{contextClass, topStateClass}));
            }
            this.writeContructor(state, stateClass);
            this.writeInstance(state, stateClass);
            this.writeOnEntryExit(state, stateClass, state.getOnEntry(), "onEntry");
            this.writeOnEntryExit(state, stateClass, state.getOnExit(), "onExit");
            this.writeEvents(state, stateClass);
        }
        catch (Exception e) {
            throw new StateBuilderException((Throwable)e);
        }
        if (state.getParallel() != null) {
            for (State stateOrthogonal : state.getParallel().getState()) {
                this.write(stateOrthogonal);
            }
        }
        for (State stateChild : state.getState()) {
            this.write(stateChild);
        }
    }

    private void writeContructor(State state, JDefinedClass stateClass) throws StateBuilderException {
        JMethod constructor = stateClass.constructor(2);
        constructor.javadoc().add((Object)"Protected Constructor");
        constructor.body().directStatement("setName(\"" + state.getName() + "\");");
        if (state.getParent() != null) {
            constructor.body().directStatement("setStateParent(" + this.getStateClassName(state.getParent()) + ".getInstance());");
        }
    }

    private void writeOnEntryExit(State state, JDefinedClass stateClass, Actions action, String onEntryExitName) throws StateBuilderException {
        String contextInstance = this.getModel().getContextInstance();
        JMethod method = stateClass.method(1, Void.TYPE, onEntryExitName);
        method.annotate(this.getCode().directClass("Override"));
        method.javadoc().add((Object)onEntryExitName);
        JVar contextVar = method.param((JType)this.getCode().directClass(this.getContextClassName(state)), contextInstance);
        JBlock block = method.body();
        if (onEntryExitName.compareTo("onExit") == 0) {
            this.writeOnExitHistory(state, block);
            this.writeOnExitParallel(state, block, contextVar);
        }
        method.body().add((JStatement)contextVar.invoke("getObserver").invoke(onEntryExitName).arg((JExpression)contextVar.invoke("getName")).arg((JExpression)JExpr._this().invoke("getName")));
        if (action != null) {
            this.writeActuatorParameterDeclaration(block);
            this.writeActions(state, action.getAction(), action.getActionGroup(), block);
        }
        if (onEntryExitName.compareTo("onEntry") == 0) {
            this.writeOnEntryParallel(state, block, contextVar);
        }
    }

    protected void processTransitionStatements(State state, Transition transition, JBlock block, JVar contextVar) throws StateBuilderException {
        State stateNext = this.getModel().getState(transition.getNextState());
        block.invoke((JExpression)contextVar, "setTransitionName").arg(this.getModel().getTransitionName(transition));
        this.writeProcessTransition(state, stateNext, block, "Begin");
        this.writeActionsFromTransition(state, transition, block);
        this.writeProcessTransition(state, stateNext, block, "End");
        this.writeContextOnEnd(state, stateNext, block);
        block._return();
    }

    private void writeActions(State state, String actionAttribute, List<Object> actionList, JBlock block) throws StateBuilderException {
        if (!actionAttribute.isEmpty()) {
            block.directStatement(actionAttribute + ";");
        }
        this.writeActionGroup(state, actionList, block);
    }

    private void writeActionGroup(State state, List<Object> actionList, JBlock block) throws StateBuilderException {
        if (actionList == null) {
            return;
        }
        for (Object action : actionList) {
            if (action instanceof String) {
                String actionstring = (String)action;
                if (actionstring.isEmpty()) continue;
                block.directStatement(action + ";");
                continue;
            }
            if (action instanceof TimerStartAction) {
                this.writeTimerStart(state, (TimerStartAction)action, block);
                continue;
            }
            if (!(action instanceof TimerStopAction)) continue;
            this.writeTimerStop(state, (TimerStopAction)action, block);
        }
    }

    private void writeActionsFromTransition(State state, Transition transition, JBlock block) throws StateBuilderException {
        this.writeActions(state, transition.getAction(), transition.getActionGroup(), block);
    }

    private void writeOnExitHistory(State state, JBlock block) {
        if (state.isHasHistory()) {
            block.directStatement(this.getModel().getContextInstance() + ".saveState();");
        }
    }

    private void writeOnEntryParallel(State state, JBlock block, JVar contextVar) throws StateBuilderException {
        if (state.getParallel() == null) {
            return;
        }
        String parallelClassName = this.getParallelClassName(state);
        String parallelLocalVariableName = this.getParallelLocalVariableName(state);
        JClass parallelClass = this.getCode().ref(parallelClassName);
        JVar parallelVar = block.decl((JType)parallelClass, parallelLocalVariableName);
        parallelVar.init((JExpression)contextVar.invoke("get" + parallelClassName));
        block.add((JStatement)contextVar.invoke("setContextParallel").arg((JExpression)parallelVar));
        block.add((JStatement)parallelVar.invoke("setActiveContext").arg((JExpression)JExpr.ref((String)String.valueOf(state.getParallel().getState().size()))));
        for (State stateOrthogonal : state.getParallel().getState()) {
            block.add((JStatement)parallelVar.invoke("get" + this.getContextClassName(stateOrthogonal)).invoke("enterInitialState"));
        }
    }

    private void writeOnExitParallel(State state, JBlock block, JVar contextVar) throws StateBuilderException {
        if (state.getParallel() == null) {
            return;
        }
        String parallelClassName = this.getParallelClassName(state);
        String parallelLocalVariableName = this.getParallelLocalVariableName(state);
        JClass parallelClass = this.getCode().ref(parallelClassName);
        JVar parallelVar = block.decl((JType)parallelClass, parallelLocalVariableName);
        parallelVar.init((JExpression)contextVar.invoke("get" + parallelClassName));
        block.add((JStatement)contextVar.invoke("setContextParallel").arg(JExpr._null()));
        for (State stateOrthogonal : state.getParallel().getState()) {
            block.add((JStatement)parallelVar.invoke("get" + this.getContextClassName(stateOrthogonal)).invoke("leaveCurrentState"));
        }
    }

    private void writeTimerStart(State state, TimerStartAction timerStart, JBlock block) throws StateBuilderException {
        block.add((JStatement)this.getContextParentExpression(state, this.getModel().getStateMachine().getState()).invoke("timerStart" + timerStart.getTimer()).arg(JExpr.direct((String)timerStart.getDuration())));
    }

    private void writeTimerStop(State state, TimerStopAction timerStop, JBlock block) throws StateBuilderException {
        block.add((JStatement)this.getContextParentExpression(state, this.getModel().getStateMachine().getState()).invoke("timerStop" + timerStop.getTimer()));
    }

    private void writeActuatorParameterDeclaration(JBlock block) {
        for (ObjectType obj : this.getModel().getStateMachine().getSettings().getObject()) {
            String objFullClassName = !obj.getInclude().isEmpty() ? obj.getInclude() + "." + obj.getClazz() : obj.getClazz();
            block.directStatement(objFullClassName + " " + obj.getInstance() + " = " + this.getModel().getContextInstance() + ".get" + obj.getClazz() + "();");
        }
    }

    private void writeInstance(State state, JDefinedClass stateClass) throws StateBuilderException {
        JFieldVar instanceField = stateClass.field(28, (JType)stateClass, "instance", (JExpression)JExpr._new((JClass)stateClass));
        JMethod getInstanceMethod = stateClass.method(17, (JType)this.getCode().directClass(this.getStateClassName(this.getModel().getStateTop(state))), "getInstance");
        getInstanceMethod.javadoc().add((Object)"Get the State Instance");
        getInstanceMethod.body()._return((JExpression)instanceField);
    }

    private void writeEvents(State state, JDefinedClass stateClass) throws ClassNotFoundException, StateBuilderException {
        for (Event event : this.getModel().getEventsForState(state)) {
            this.writeEvent(state, stateClass, event);
        }
    }

    private void writeEvent(State state, JDefinedClass stateClass, Event event) throws ClassNotFoundException, StateBuilderException {
        JMethod eventMethod = stateClass.method(1, Void.TYPE, event.getId());
        JVar contextVar = eventMethod.param(this.getCode().parseType(this.getContextClassName(state)), "context");
        eventMethod.javadoc().add((Object)("Event id: " + event.getId()));
        for (Parameter parameter : event.getParameter()) {
            this.addParameter(eventMethod, parameter);
        }
        JBlock block = eventMethod.body();
        this.writeEventParallel(state, event, block, contextVar);
        this.writeEventLeaf(state, event, block, contextVar);
    }

    private void writeEventLeaf(State state, Event event, JBlock block, JVar contextVar) throws ClassNotFoundException, StateBuilderException {
        List transitions = this.getModel().getTransitionList(state, event);
        if (transitions.size() != 0) {
            this.writeActuatorParameterDeclaration(block);
            for (Transition transition : transitions) {
                this.writeTransition(state, transition, block, contextVar);
            }
        }
    }

    private void writeTransition(State state, Transition transition, JBlock block, JVar contextVar) throws StateBuilderException {
        State stateNext = this.getModel().getState(transition.getNextState());
        if (stateNext == null) {
            block.directStatement("// Internal transition triggered by " + this.getModel().getTransitionName(transition));
        } else if (stateNext.equals(state)) {
            block.directStatement("// Self transition triggered by " + this.getModel().getTransitionName(transition));
        } else {
            block.directStatement("// Transition from " + state.getName() + " to " + stateNext.getName() + " triggered by " + this.getModel().getTransitionName(transition));
            if (stateNext.getParallel() == state.getParallel()) {
                block.directStatement("// The next state is within the context " + this.getContextClassName(state));
                if (stateNext.getKind() == StateKind.HISTORY) {
                    block.directStatement("// The next state is historical ");
                }
            } else {
                block.directStatement("// The next state belonging to context " + this.getContextClassName(stateNext) + " is outside the current context " + this.getContextClassName(state));
            }
        }
        String condition = this.getModel().getCondition(transition);
        if (!condition.isEmpty()) {
            JConditional conditional = block._if(JExpr.direct((String)condition));
            this.processTransitionStatements(stateNext, transition, conditional._then(), contextVar);
        } else {
            this.processTransitionStatements(stateNext, transition, block, contextVar);
        }
    }

    private void writeEventParallel(State state, Event event, JBlock block, JVar contextVar) throws ClassNotFoundException, StateBuilderException {
        if (state.getParallel() == null) {
            return;
        }
        String parallelClassName = this.getParallelClassName(state);
        String parallelLocalVariableName = this.getParallelLocalVariableName(state);
        JClass parallelClass = this.getCode().ref(parallelClassName);
        JVar parallelVar = block.decl((JType)parallelClass, parallelLocalVariableName);
        parallelVar.init((JExpression)contextVar.invoke("get" + parallelClassName));
        for (State stateOrthogonal : state.getParallel().getState()) {
            JInvocation eventInvokation = parallelVar.invoke("get" + this.getContextClassName(stateOrthogonal)).invoke(event.getId());
            for (Parameter parameter : event.getParameter()) {
                eventInvokation.arg((JExpression)JExpr.ref((String)parameter.getName()));
            }
            block.add((JStatement)eventInvokation);
        }
    }
}

