/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateScanMalwareSettingRequest extends AbstractModel{

    /**
    * 扫描模式 0 全盘扫描, 1 快速扫描
    */
    @SerializedName("ScanPattern")
    @Expose
    private Long ScanPattern;

    /**
    * 服务器分类：1:专业版服务器；2:自选服务器
    */
    @SerializedName("HostType")
    @Expose
    private Long HostType;

    /**
    * 自选服务器时生效，主机quuid的string数组
    */
    @SerializedName("QuuidList")
    @Expose
    private String [] QuuidList;

    /**
    * 超时时间单位 秒
    */
    @SerializedName("TimeoutPeriod")
    @Expose
    private Long TimeoutPeriod;

    /**
     * Get 扫描模式 0 全盘扫描, 1 快速扫描 
     * @return ScanPattern 扫描模式 0 全盘扫描, 1 快速扫描
     */
    public Long getScanPattern() {
        return this.ScanPattern;
    }

    /**
     * Set 扫描模式 0 全盘扫描, 1 快速扫描
     * @param ScanPattern 扫描模式 0 全盘扫描, 1 快速扫描
     */
    public void setScanPattern(Long ScanPattern) {
        this.ScanPattern = ScanPattern;
    }

    /**
     * Get 服务器分类：1:专业版服务器；2:自选服务器 
     * @return HostType 服务器分类：1:专业版服务器；2:自选服务器
     */
    public Long getHostType() {
        return this.HostType;
    }

    /**
     * Set 服务器分类：1:专业版服务器；2:自选服务器
     * @param HostType 服务器分类：1:专业版服务器；2:自选服务器
     */
    public void setHostType(Long HostType) {
        this.HostType = HostType;
    }

    /**
     * Get 自选服务器时生效，主机quuid的string数组 
     * @return QuuidList 自选服务器时生效，主机quuid的string数组
     */
    public String [] getQuuidList() {
        return this.QuuidList;
    }

    /**
     * Set 自选服务器时生效，主机quuid的string数组
     * @param QuuidList 自选服务器时生效，主机quuid的string数组
     */
    public void setQuuidList(String [] QuuidList) {
        this.QuuidList = QuuidList;
    }

    /**
     * Get 超时时间单位 秒 
     * @return TimeoutPeriod 超时时间单位 秒
     */
    public Long getTimeoutPeriod() {
        return this.TimeoutPeriod;
    }

    /**
     * Set 超时时间单位 秒
     * @param TimeoutPeriod 超时时间单位 秒
     */
    public void setTimeoutPeriod(Long TimeoutPeriod) {
        this.TimeoutPeriod = TimeoutPeriod;
    }

    public CreateScanMalwareSettingRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateScanMalwareSettingRequest(CreateScanMalwareSettingRequest source) {
        if (source.ScanPattern != null) {
            this.ScanPattern = new Long(source.ScanPattern);
        }
        if (source.HostType != null) {
            this.HostType = new Long(source.HostType);
        }
        if (source.QuuidList != null) {
            this.QuuidList = new String[source.QuuidList.length];
            for (int i = 0; i < source.QuuidList.length; i++) {
                this.QuuidList[i] = new String(source.QuuidList[i]);
            }
        }
        if (source.TimeoutPeriod != null) {
            this.TimeoutPeriod = new Long(source.TimeoutPeriod);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ScanPattern", this.ScanPattern);
        this.setParamSimple(map, prefix + "HostType", this.HostType);
        this.setParamArraySimple(map, prefix + "QuuidList.", this.QuuidList);
        this.setParamSimple(map, prefix + "TimeoutPeriod", this.TimeoutPeriod);

    }
}

