/*
 * Decompiled with CFR 0.152.
 */
package com.tokenwatcher;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.tokenwatcher.Event;
import com.tokenwatcher.TokenWatcherConfig;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSender {
    private static final Logger logger = LoggerFactory.getLogger(EventSender.class);
    private static final String USER_AGENT = "tokenwatcher-java/0.1.0";
    private final TokenWatcherConfig config;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;

    public EventSender(TokenWatcherConfig config) {
        this.config = config;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(config.getTimeout())).build();
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new JavaTimeModule());
    }

    public boolean sendBatch(List<Event> events) {
        if (!this.config.isEnabled()) {
            logger.debug("Monitoring disabled, skipping batch send");
            return true;
        }
        if (events == null || events.isEmpty()) {
            logger.debug("No events to send");
            return true;
        }
        logger.debug("Sending batch of {} events", (Object)events.size());
        for (int attempt = 1; attempt <= this.config.getMaxRetries(); ++attempt) {
            try {
                String jsonBody = this.objectMapper.writeValueAsString(events);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.config.getEventsEndpoint())).header("X-Monitor-Key", this.config.getApiKey()).header("Content-Type", "application/json").header("User-Agent", USER_AGENT).timeout(Duration.ofMillis(this.config.getTimeout())).POST(HttpRequest.BodyPublishers.ofString(jsonBody)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 202) {
                    logger.debug("Batch sent successfully: {}", (Object)response.body());
                    return true;
                }
                if (response.statusCode() == 400) {
                    logger.warn("Batch rejected (validation error): {}", (Object)response.body());
                    return false;
                }
                if (response.statusCode() == 401) {
                    logger.error("Authentication failed - check your API key");
                    return false;
                }
                logger.warn("Unexpected status code {}: {}", (Object)response.statusCode(), (Object)response.body());
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().contains("timed out")) {
                    logger.warn("Request timeout (attempt {}/{})", (Object)attempt, (Object)this.config.getMaxRetries());
                } else {
                    logger.warn("Connection error (attempt {}/{}): {}", new Object[]{attempt, this.config.getMaxRetries(), e.getMessage()});
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Request interrupted: {}", (Object)e.getMessage());
                return false;
            }
            catch (Exception e) {
                logger.error("Unexpected error sending batch: {}", (Object)e.getMessage(), (Object)e);
                return false;
            }
            if (attempt >= this.config.getMaxRetries()) continue;
            int backoffTime = (int)Math.pow(2.0, attempt - 1);
            logger.debug("Retrying in {}s...", (Object)backoffTime);
            try {
                Thread.sleep((long)backoffTime * 1000L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        logger.warn("Failed to send batch after {} attempts", (Object)this.config.getMaxRetries());
        return false;
    }

    public void close() {
    }
}

