/*
 * Decompiled with CFR 0.152.
 */
package com.tokenwatcher;

import com.tokenwatcher.BaseMonitoredClient;
import com.tokenwatcher.Event;
import com.tokenwatcher.TokenWatcherConfig;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoredAnthropic
extends BaseMonitoredClient {
    private static final Logger logger = LoggerFactory.getLogger(MonitoredAnthropic.class);
    private static final String PROVIDER = "anthropic";
    private final Object wrappedClient;

    private MonitoredAnthropic(Object client, TokenWatcherConfig config, Map<String, Object> metadata) {
        super(config, metadata);
        this.wrappedClient = client;
    }

    public static <T> T wrap(T client, TokenWatcherConfig config) {
        return MonitoredAnthropic.wrap(client, config, null);
    }

    public static <T> T wrap(T client, TokenWatcherConfig config, Map<String, Object> metadata) {
        MonitoredAnthropic monitor = new MonitoredAnthropic(client, config, metadata);
        return (T)Proxy.newProxyInstance(client.getClass().getClassLoader(), client.getClass().getInterfaces(), (InvocationHandler)new MonitoringInvocationHandler(monitor, client, PROVIDER));
    }

    private static class MonitoringInvocationHandler
    implements InvocationHandler {
        private final MonitoredAnthropic monitor;
        private final Object target;
        private final String provider;

        MonitoringInvocationHandler(MonitoredAnthropic monitor, Object target, String provider) {
            this.monitor = monitor;
            this.target = target;
            this.provider = provider;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!this.shouldMonitor(method)) {
                return method.invoke(this.target, args);
            }
            long startTime = System.currentTimeMillis();
            String model = this.extractModel(args);
            String context = this.monitor.getContext();
            try {
                Object result = method.invoke(this.target, args);
                long latencyMs = System.currentTimeMillis() - startTime;
                Integer inputTokens = this.extractInputTokens(result);
                Integer outputTokens = this.extractOutputTokens(result);
                Event event = this.monitor.createSuccessEvent(this.provider, model != null ? model : "unknown", inputTokens, outputTokens, latencyMs, context);
                this.monitor.buffer.addEvent(event);
                return result;
            }
            catch (Exception e) {
                long latencyMs = System.currentTimeMillis() - startTime;
                Event event = this.monitor.createErrorEvent(this.provider, model != null ? model : "unknown", latencyMs, e.getCause() != null ? e.getCause() : e, context);
                this.monitor.buffer.addEvent(event);
                throw e.getCause() != null ? e.getCause() : e;
            }
        }

        private boolean shouldMonitor(Method method) {
            String name = method.getName();
            return name.contains("create") || name.contains("message") || name.contains("complete") || name.contains("stream");
        }

        private String extractModel(Object[] args) {
            if (args == null || args.length == 0) {
                return null;
            }
            for (Object arg : args) {
                Object model;
                if (arg == null) continue;
                try {
                    Method getModel = arg.getClass().getMethod("getModel", new Class[0]);
                    model = getModel.invoke(arg, new Object[0]);
                    if (model == null) continue;
                    return model.toString();
                }
                catch (Exception ignored) {
                    try {
                        model = arg.getClass().getMethod("model", new Class[0]);
                        Object modelObj = ((Method)model).invoke(arg, new Object[0]);
                        if (modelObj == null) continue;
                        return modelObj.toString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        private Integer extractInputTokens(Object result) {
            return this.extractTokenCount(result, "getInputTokens", "inputTokens");
        }

        private Integer extractOutputTokens(Object result) {
            return this.extractTokenCount(result, "getOutputTokens", "outputTokens");
        }

        private Integer extractTokenCount(Object result, String ... methodNames) {
            if (result == null) {
                return null;
            }
            try {
                Object tokens;
                Method getTokens2;
                Method getUsage = result.getClass().getMethod("getUsage", new Class[0]);
                Object usage = getUsage.invoke(result, new Object[0]);
                if (usage != null) {
                    for (String methodName : methodNames) {
                        try {
                            getTokens2 = usage.getClass().getMethod(methodName, new Class[0]);
                            tokens = getTokens2.invoke(usage, new Object[0]);
                            if (tokens instanceof Number) {
                                return ((Number)tokens).intValue();
                            }
                        }
                        catch (Exception getTokens2) {
                            // empty catch block
                        }
                    }
                }
                for (String methodName : methodNames) {
                    try {
                        getTokens2 = result.getClass().getMethod(methodName, new Class[0]);
                        tokens = getTokens2.invoke(result, new Object[0]);
                        if (!(tokens instanceof Number)) continue;
                        return ((Number)tokens).intValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

