/*
 * Decompiled with CFR 0.152.
 */
package com.tokenwatcher;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenWatcherConfig {
    private static final Logger logger = LoggerFactory.getLogger(TokenWatcherConfig.class);
    private static final String DEFAULT_BASE_URL = "https://api.token-watcher.com";
    private static final int DEFAULT_BUFFER_SIZE = 100;
    private static final int DEFAULT_FLUSH_INTERVAL = 10;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int DEFAULT_MAX_RETRIES = 3;
    private final String apiKey;
    private final String baseUrl;
    private final String context;
    private final String userIdentifier;
    private final int bufferSize;
    private final int flushInterval;
    private final boolean enabled;
    private final int timeout;
    private final int maxRetries;

    private TokenWatcherConfig(Builder builder) {
        this.apiKey = builder.apiKey;
        this.baseUrl = builder.baseUrl != null ? builder.baseUrl.replaceAll("/$", "") : DEFAULT_BASE_URL;
        this.context = builder.context != null ? builder.context : System.getenv("TOKENWATCHER_CONTEXT");
        this.userIdentifier = builder.userIdentifier;
        this.bufferSize = builder.bufferSize;
        this.flushInterval = builder.flushInterval;
        this.enabled = builder.enabled;
        this.timeout = builder.timeout;
        this.maxRetries = builder.maxRetries;
        if (this.apiKey != null && !this.apiKey.startsWith("ym_")) {
            logger.warn("TokenWatcher API key should start with 'ym_'. Monitoring may not work correctly.");
        }
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getContext() {
        return this.context;
    }

    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public String getEventsEndpoint() {
        return this.baseUrl + "/api/v1/events/batch";
    }

    public String toString() {
        return "TokenWatcherConfig{apiKey='********', baseUrl='" + this.baseUrl + "', context='" + this.context + "', enabled=" + this.enabled + "}";
    }

    public static Builder builder(String apiKey) {
        return new Builder(apiKey);
    }

    public static class Builder {
        private final String apiKey;
        private String baseUrl;
        private String context;
        private String userIdentifier;
        private int bufferSize = 100;
        private int flushInterval = 10;
        private boolean enabled = true;
        private int timeout = 5000;
        private int maxRetries = 3;

        private Builder(String apiKey) {
            this.apiKey = apiKey;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder context(String context) {
            this.context = context;
            return this;
        }

        public Builder userIdentifier(String userIdentifier) {
            this.userIdentifier = userIdentifier;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder flushInterval(int flushInterval) {
            this.flushInterval = flushInterval;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public TokenWatcherConfig build() {
            return new TokenWatcherConfig(this);
        }
    }
}

