/*
 * Decompiled with CFR 0.152.
 */
package com.twingly.search;

import com.twingly.search.Query;
import com.twingly.search.domain.Language;
import com.twingly.search.exception.QueryException;
import java.util.Date;

public class QueryBuilder {
    private Query query = new Query();

    private QueryBuilder() {
    }

    public static QueryBuilder create(String searchPattern) {
        return new QueryBuilder().searchPattern(searchPattern);
    }

    public QueryBuilder searchPattern(String searchPattern) {
        if (this.isEmpty(searchPattern)) {
            throw new QueryException("Missing pattern");
        }
        this.query.setSearchPattern(searchPattern);
        return this;
    }

    public QueryBuilder startTime(Date startTime) {
        if (startTime != null) {
            if (this.query.getEndTime() != null) {
                if (startTime.before(this.query.getEndTime())) {
                    this.query.setStartTime(startTime);
                }
            } else {
                this.query.setStartTime(startTime);
            }
        }
        return this;
    }

    public QueryBuilder endTime(Date endTime) {
        if (endTime != null) {
            if (this.query.getStartTime() != null) {
                if (endTime.after(this.query.getStartTime())) {
                    this.query.setEndTime(endTime);
                }
            } else {
                this.query.setEndTime(endTime);
            }
        }
        return this;
    }

    public QueryBuilder documentLanguage(Language language) {
        if (language != null) {
            this.query.setDocumentLanguage(language.getIsoCode());
        }
        return this;
    }

    public QueryBuilder documentLanguage(String documentLanguage) {
        if (this.isNotEmpty(documentLanguage)) {
            this.query.setDocumentLanguage(documentLanguage);
        }
        return this;
    }

    public QueryBuilder createNewQuery() {
        this.query = new Query();
        return this;
    }

    public Query build() {
        return this.query;
    }

    private boolean isNotEmpty(String value) {
        return !this.isEmpty(value);
    }

    private boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }
}

