/*
 * Decompiled with CFR 0.152.
 */
package com.twingly.search.client;

import com.twingly.search.Constants;
import com.twingly.search.Query;
import com.twingly.search.client.Client;
import com.twingly.search.domain.BlogStream;
import com.twingly.search.domain.OperationResult;
import com.twingly.search.domain.OperationResultType;
import com.twingly.search.domain.Post;
import com.twingly.search.domain.Result;
import com.twingly.search.exception.TwinglySearchException;
import com.twingly.search.exception.TwinglySearchServerAPIKeyDoesNotExistException;
import com.twingly.search.exception.TwinglySearchServerAPIKeyUnauthorizedException;
import com.twingly.search.exception.TwinglySearchServerException;
import com.twingly.search.exception.TwinglySearchServerServiceUnavailableException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class UrlConnectionClient
implements Client {
    private static final String USER_AGENT_PROPERTY = "User-Agent";
    private static final String DEFAULT_USER_AGENT = "Twingly Search Java Client/" + Constants.VERSION;
    private static final String BASE_URL = "https://api.twingly.com";
    private static final String SEARCH_PATH = "/analytics/Analytics.ashx";
    private static final char AND = '&';
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final String apiKey;
    private String userAgent = DEFAULT_USER_AGENT;
    private JAXBContext jaxbContext;

    public UrlConnectionClient(String apiKey) {
        this.apiKey = apiKey;
    }

    public UrlConnectionClient() {
        this.apiKey = System.getProperty("TWINGLY_SEARCH_KEY");
        if (this.apiKey == null) {
            throw new TwinglySearchException("Api key missing, could not find TWINGLY_SEARCH_KEY property");
        }
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public Result makeRequest(Query query) {
        String queryString = this.buildQueryString(query);
        return this.makeRequest(queryString);
    }

    private String buildQueryString(Query query) {
        StringBuilder sb = new StringBuilder();
        sb.append(BASE_URL);
        sb.append(SEARCH_PATH);
        sb.append("?key=").append(this.apiKey);
        sb.append('&').append("xmloutputversion=2");
        sb.append('&').append("searchpattern=").append(this.urlEncode(query.getSearchPattern()));
        if (query.getStartTime() != null) {
            sb.append('&').append("ts=").append(this.urlEncode(this.simpleDateFormat.format(query.getStartTime())));
        }
        if (query.getEndTime() != null) {
            sb.append('&').append("tsTo=").append(this.urlEncode(this.simpleDateFormat.format(query.getEndTime())));
        }
        if (query.getDocumentLanguage() != null) {
            sb.append('&').append("documentlang=").append(query.getDocumentLanguage());
        }
        return sb.toString();
    }

    private String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TwinglySearchException("It's quite impossible, but there's no UTF-8 encoding in your JVM", e);
        }
    }

    JAXBContext getJAXBContext() {
        if (this.jaxbContext == null) {
            try {
                this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Result.class, Post.class, OperationResult.class, BlogStream.class});
            }
            catch (JAXBException e) {
                throw new TwinglySearchException("Cannot initialize JAXBContext for Result", e);
            }
        }
        return this.jaxbContext;
    }

    Result unmarshalXmlForResult(Reader reader) {
        try {
            Unmarshaller jaxbUnmarshaller = this.getJAXBContext().createUnmarshaller();
            Object result = jaxbUnmarshaller.unmarshal(reader);
            if (result instanceof Result) {
                return this.filterResultsWithEmptyContentTypes((Result)result);
            }
            if (result instanceof BlogStream) {
                this.handleException((BlogStream)result);
            }
            throw new TwinglySearchException("Unprocessed exception");
        }
        catch (JAXBException e) {
            throw new TwinglySearchException("Unable to process request", e);
        }
    }

    private Result filterResultsWithEmptyContentTypes(Result result) {
        Iterator<Post> iterator = result.getPosts().iterator();
        while (iterator.hasNext()) {
            Post post = iterator.next();
            if (post.getContentType() != null) continue;
            iterator.remove();
        }
        return result;
    }

    private void handleException(BlogStream blogStream) {
        if (blogStream.getOperationResult() != null && blogStream.getOperationResult().getResultType() == OperationResultType.FAILURE) {
            String message = blogStream.getOperationResult().getMessage();
            if ("The API key does not exist.".equalsIgnoreCase(message)) {
                throw new TwinglySearchServerAPIKeyDoesNotExistException(blogStream);
            }
            if ("The API key does not grant access to the Search API.".equalsIgnoreCase(message)) {
                throw new TwinglySearchServerAPIKeyUnauthorizedException(blogStream);
            }
            if ("Authentication service unavailable.".equalsIgnoreCase(message)) {
                throw new TwinglySearchServerServiceUnavailableException(blogStream);
            }
            throw new TwinglySearchServerException(blogStream);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Result makeRequest(String query) {
        try {
            URL url = this.getUrl(query);
            URLConnection connection = url.openConnection();
            connection.setRequestProperty(USER_AGENT_PROPERTY, this.getUserAgent());
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                Result result = this.unmarshalXmlForResult(br);
                return result;
            }
        }
        catch (IOException e) {
            throw new TwinglySearchException("IO exception", e);
        }
    }

    URL getUrl(String query) {
        try {
            return new URL(query);
        }
        catch (MalformedURLException e) {
            throw new TwinglySearchException("Malformed query", e);
        }
    }
}

