/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.loginsightapi;

import com.vmware.loginsightapi.QueryBuilder;
import com.vmware.loginsightapi.core.GroupBy;
import com.vmware.loginsightapi.core.GroupByDynamicBinWidth;
import com.vmware.loginsightapi.core.GroupByFixedBinWidth;
import com.vmware.loginsightapi.core.OrderBy;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AggregateQueryBuilder
extends QueryBuilder {
    public static final String API_URL_AGGREGATED_EVENTS_PATH = "/api/v1/aggregated-events/";
    public static final int DEFAULT_BIN_WIDTH = 5000;
    public static final AggregationFunction DEFAULT_AGGREGATION_FUNCTION = AggregationFunction.COUNT;
    private int binWidth = 5000;
    private AggregationFunction aggregationFunction = DEFAULT_AGGREGATION_FUNCTION;
    private String aggregationField;
    private List<GroupBy> groupBy = new ArrayList<GroupBy>();
    private List<OrderBy> orderBys = new ArrayList<OrderBy>();

    public AggregateQueryBuilder binWidth(int binWidth) {
        this.binWidth = binWidth;
        return this;
    }

    public AggregateQueryBuilder aggregator(AggregationFunction aggregateFunc, String aggregationField) {
        this.aggregationFunction = aggregateFunc;
        if ((aggregateFunc == AggregationFunction.COUNT || aggregateFunc == AggregationFunction.SAMPLE) && aggregationField != null) {
            this.aggregationField = null;
        }
        this.aggregationField = aggregationField;
        return this;
    }

    public AggregateQueryBuilder count() {
        this.aggregationFunction = AggregationFunction.COUNT;
        this.aggregationField = null;
        return this;
    }

    public AggregateQueryBuilder sample() {
        this.aggregationFunction = AggregationFunction.SAMPLE;
        this.aggregationField = null;
        return this;
    }

    public AggregateQueryBuilder ucount(String aggregationField) {
        this.aggregationFunction = AggregationFunction.UCOUNT;
        this.aggregationField = aggregationField;
        return this;
    }

    public AggregateQueryBuilder average(String aggregationField) {
        this.aggregationFunction = AggregationFunction.AVG;
        this.aggregationField = aggregationField;
        return this;
    }

    public AggregateQueryBuilder min(String aggregationField) {
        this.aggregationFunction = AggregationFunction.MIN;
        this.aggregationField = aggregationField;
        return this;
    }

    public AggregateQueryBuilder max(String aggregationField) {
        this.aggregationFunction = AggregationFunction.MAX;
        this.aggregationField = aggregationField;
        return this;
    }

    public AggregateQueryBuilder sum(String aggregationField) {
        this.aggregationFunction = AggregationFunction.SUM;
        this.aggregationField = aggregationField;
        return this;
    }

    public AggregateQueryBuilder stdev(String aggregationField) {
        this.aggregationFunction = AggregationFunction.STDEV;
        this.aggregationField = aggregationField;
        return this;
    }

    public AggregateQueryBuilder variance(String aggregationField) {
        this.aggregationFunction = AggregationFunction.VARIANCE;
        this.aggregationField = aggregationField;
        return this;
    }

    public AggregateQueryBuilder groupByFixedBinWidth(String groupByField, int binWidth) {
        this.groupBy.add(new GroupByFixedBinWidth(groupByField, binWidth));
        return this;
    }

    public AggregateQueryBuilder groupByDynamicBins(String groupByField, String bins) {
        this.groupBy.add(new GroupByDynamicBinWidth(groupByField, bins));
        return this;
    }

    public AggregateQueryBuilder setGroupBy(List<GroupBy> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public AggregateQueryBuilder orderBy(String orderByFunction, String orderByField, OrderBy.Direction orderByDirection) {
        this.orderBys.add(new OrderBy(orderByFunction, orderByField, orderByDirection));
        return this;
    }

    public AggregateQueryBuilder setOrderBy(List<OrderBy> orderBy) {
        this.orderBys = orderBy;
        return this;
    }

    @Override
    protected String buildUrlParameters() {
        ArrayList<String> urlParams = new ArrayList<String>();
        if (this.limit != 100 || this.includeDefaults) {
            urlParams.add("limit=" + this.limit);
        }
        if (this.timeout != 30000 || this.includeDefaults) {
            urlParams.add("timeout=" + this.timeout);
        }
        if (this.binWidth != 5000 || this.includeDefaults) {
            urlParams.add("bin-width=" + this.binWidth);
        }
        if (this.aggregationFunction != DEFAULT_AGGREGATION_FUNCTION || this.includeDefaults) {
            if (this.aggregationFunction == AggregationFunction.COUNT || this.aggregationFunction == AggregationFunction.SAMPLE) {
                urlParams.add("aggregation-function=" + (Object)((Object)this.aggregationFunction));
            } else {
                urlParams.add("aggregation-function=" + (Object)((Object)this.aggregationFunction) + "&aggregation-field=" + this.aggregationField);
            }
        }
        List contentPackParams = this.contentPackFields.stream().map(contentPack -> "content-pack-fields=" + contentPack).collect(Collectors.toList());
        List groupByParams = this.groupBy.stream().map(groupBy -> {
            String paramString = "";
            if (groupBy instanceof GroupByFixedBinWidth) {
                paramString = paramString + "group-by-field=" + groupBy.getGroupByField() + "&bin-width=" + groupBy.getBinWidth();
            } else if (groupBy instanceof GroupByDynamicBinWidth) {
                paramString = paramString + "group-by-field=" + groupBy.getGroupByField() + "&bins=" + groupBy.getBins();
            }
            return paramString;
        }).collect(Collectors.toList());
        List orderByParams = this.orderBys.stream().map(orderBy -> {
            String paramString = "order-by-function=" + orderBy.getOrderByFunction();
            if (null != orderBy.getOrderByField()) {
                paramString = paramString + "&order-by-field=" + orderBy.getOrderByField();
            }
            if (null != orderBy.getOrderByDirection()) {
                paramString = paramString + "&order-by-direction=" + (Object)((Object)orderBy.getOrderByDirection());
            }
            return paramString;
        }).collect(Collectors.toList());
        urlParams.addAll(orderByParams);
        urlParams.addAll(contentPackParams);
        urlParams.addAll(groupByParams);
        return urlParams.parallelStream().collect(Collectors.joining("&"));
    }

    @Override
    public String toUrlString() {
        String path = this.buildPathSegment();
        String params = this.buildUrlParameters();
        String url = API_URL_AGGREGATED_EVENTS_PATH;
        if (!path.isEmpty()) {
            url = url + path;
        }
        if (!params.isEmpty()) {
            url = url + "?" + params;
        }
        return url;
    }

    public static enum AggregationFunction {
        COUNT,
        UCOUNT,
        AVG,
        MIN,
        MAX,
        SUM,
        STDEV,
        VARIANCE,
        SAMPLE;

    }
}

