/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.loginsightapi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.ClasspathLocationStrategy;
import org.apache.commons.configuration2.io.CombinedLocationStrategy;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileSystemLocationStrategy;
import org.apache.commons.configuration2.io.ProvidedURLLocationStrategy;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    public static final String FILENAME = "config.properties";
    public static final String KEY_LI_HOST = "loginsight.host";
    public static final String KEY_LI_PORT = "loginsight.port";
    public static final String KEY_LI_INGESTION_PORT = "loginsight.ingestion.port";
    public static final String KEY_LI_USER = "loginsight.user";
    public static final String KEY_LI_PASSWORD = "loginsight.password";
    public static final String KEY_CONNECTION_SCHEME = "loginsight.connection.scheme";
    public static final String KEY_AGENT_ID = "loginsight.ingestion.agentId";
    public static final String DEFAULT_SCHEME = "https";
    public static final int DEFAULT_PORT = 443;
    public static final int DEFAULT_INGESTION_PORT = 9543;
    String host;
    String user;
    String password;
    String port;
    String ingestionPort;
    String agentId;
    String scheme;
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);

    public Configuration() {
        this.port = Integer.toString(443);
        this.ingestionPort = Integer.toString(9543);
        this.scheme = DEFAULT_SCHEME;
        this.agentId = UUID.randomUUID().toString();
    }

    public Configuration(String host, String user, String password) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.port = Integer.toString(443);
        this.ingestionPort = Integer.toString(9543);
        this.scheme = DEFAULT_SCHEME;
        this.agentId = UUID.randomUUID().toString();
    }

    public static Configuration buildConfig(Map<String, String> configData) {
        Configuration liConfig = new Configuration();
        liConfig.port = Integer.toString(443);
        liConfig.ingestionPort = Integer.toString(9543);
        liConfig.scheme = DEFAULT_SCHEME;
        if (configData.containsKey(KEY_LI_HOST) && null != configData.get(KEY_LI_HOST) && StringUtils.isNotEmpty((CharSequence)configData.get(KEY_LI_HOST))) {
            liConfig.host = configData.get(KEY_LI_HOST);
        }
        if (configData.containsKey(KEY_LI_PORT) && null != configData.get(KEY_LI_PORT) && StringUtils.isNotEmpty((CharSequence)configData.get(KEY_LI_PORT))) {
            logger.info("setting port as well");
            liConfig.setPort(configData.get(KEY_LI_PORT));
        }
        if (configData.containsKey(KEY_LI_INGESTION_PORT) && null != configData.get(KEY_LI_INGESTION_PORT) && StringUtils.isNotEmpty((CharSequence)configData.get(KEY_LI_INGESTION_PORT))) {
            liConfig.setIngestionPort(configData.get(KEY_LI_INGESTION_PORT));
        }
        if (configData.containsKey(KEY_LI_USER) && null != configData.get(KEY_LI_USER) && StringUtils.isNotEmpty((CharSequence)configData.get(KEY_LI_USER))) {
            liConfig.user = configData.get(KEY_LI_USER);
        }
        if (configData.containsKey(KEY_LI_PASSWORD) && null != configData.get(KEY_LI_PASSWORD) && StringUtils.isNotEmpty((CharSequence)configData.get(KEY_LI_PASSWORD))) {
            liConfig.password = configData.get(KEY_LI_PASSWORD);
        }
        if (configData.containsKey(KEY_CONNECTION_SCHEME) && null != configData.get(KEY_CONNECTION_SCHEME) && StringUtils.isNotEmpty((CharSequence)configData.get(KEY_CONNECTION_SCHEME))) {
            liConfig.setScheme(configData.get(KEY_CONNECTION_SCHEME));
        }
        if (configData.containsKey(KEY_AGENT_ID) && null != configData.get(KEY_AGENT_ID) && StringUtils.isNotEmpty((CharSequence)configData.get(KEY_AGENT_ID))) {
            liConfig.setAgentId(configData.get(KEY_AGENT_ID));
        }
        return liConfig;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        if (null != scheme && !StringUtils.isEmpty((CharSequence)scheme)) {
            if (!DEFAULT_SCHEME.equals(DEFAULT_SCHEME)) {
                throw new NotImplementedException("only https scheme is available");
            }
        } else {
            throw new IllegalArgumentException("Invalid http scheme. Should be https");
        }
        this.scheme = scheme;
    }

    public String getIngestionPort() {
        return this.ingestionPort;
    }

    public void setIngestionPort(String ingestionPort) {
        if (null == ingestionPort || StringUtils.isEmpty((CharSequence)ingestionPort)) {
            throw new IllegalArgumentException("Invalid Ingestion port ");
        }
        this.ingestionPort = ingestionPort;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        if (null == agentId || StringUtils.isEmpty((CharSequence)agentId)) {
            throw new IllegalArgumentException("Invalid Agent ID");
        }
        UUID uuid = UUID.fromString(agentId);
        this.agentId = uuid.toString();
    }

    public void setHost(String host) {
        if (null == host || StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("Invalid host name ");
        }
        this.host = host;
    }

    public void setUser(String user) {
        if (null == user || StringUtils.isEmpty((CharSequence)user)) {
            throw new IllegalArgumentException("Invalid user name ");
        }
        this.user = user;
    }

    public void setPassword(String password) {
        if (null == password || StringUtils.isEmpty((CharSequence)password)) {
            throw new IllegalArgumentException("Invalid password ");
        }
        this.password = password;
    }

    public void setPort(String port) {
        if (null == port || StringUtils.isEmpty((CharSequence)port)) {
            throw new IllegalArgumentException("Invalid port ");
        }
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Configuration loadFromEnv() {
        if (null != System.getenv("LOGINSIGHT_HOST") && StringUtils.isNotEmpty((CharSequence)System.getenv("LOGINSIGHT_HOST"))) {
            this.host = System.getenv("LOGINSIGHT_HOST");
        }
        if (null != System.getenv("LOGINSIGHT_USERNAME") && StringUtils.isNotEmpty((CharSequence)System.getenv("LOGINSIGHT_USERNAME"))) {
            this.user = System.getenv("LOGINSIGHT_USERNAME");
        }
        if (null != System.getenv("LOGINSIGHT_PASSWORD") && StringUtils.isNotEmpty((CharSequence)System.getenv("LOGINSIGHT_PASSWORD"))) {
            this.password = System.getenv("LOGINSIGHT_PASSWORD");
        }
        return this;
    }

    public static Configuration buildFromConfig(String configFileName) {
        try {
            List<FileLocationStrategy> subs = Arrays.asList(new ProvidedURLLocationStrategy(), new FileSystemLocationStrategy(), new ClasspathLocationStrategy());
            CombinedLocationStrategy strategy = new CombinedLocationStrategy(subs);
            FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)new Parameters().fileBased().setLocationStrategy((FileLocationStrategy)strategy)).setFileName(configFileName)});
            PropertiesConfiguration propConfig = (PropertiesConfiguration)builder.getConfiguration();
            HashMap<String, String> propMap = new HashMap<String, String>();
            Iterator keys = propConfig.getKeys();
            keys.forEachRemaining(key -> {
                logger.info(key + ":" + propConfig.getString(key));
                propMap.put((String)key, propConfig.getString(key));
            });
            Configuration config = Configuration.buildConfig(propMap);
            config.loadFromEnv();
            return config;
        }
        catch (ConfigurationException e1) {
            throw new RuntimeException("Unable to load config", e1);
        }
    }
}

