/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.loginsightapi.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.vmware.loginsightapi.core.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Message {
    private String text;
    private Long timestamp;
    private List<Field> fields;

    public Message() {
        this.fields = new ArrayList<Field>();
    }

    public Message(String text) {
        this.text = text;
        this.fields = new ArrayList<Field>();
    }

    public Message(String text, Long timestamp) {
        this.text = text;
        this.timestamp = timestamp;
        this.fields = new ArrayList<Field>();
    }

    public Message(String text, Long timestamp, List<Field> fields) {
        this.text = text;
        this.timestamp = timestamp;
        this.fields = fields;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timeStamp) {
        this.timestamp = timeStamp;
    }

    public void setTimestamp() {
        this.timestamp = DateTime.now().getMillis();
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public void addField(String name, String content) {
        this.fields.add(new Field(name, content));
    }

    public void addField(String name, String startPosition, String length) {
        this.fields.add(new Field(name, startPosition, length));
    }

    public void addField(String name, String content, String startPosition, String length) {
        this.fields.add(new Field(name, content, startPosition, length));
    }

    public boolean checkIsEmpty() {
        return null == this.text || StringUtils.isEmpty((CharSequence)this.text) || this.fields.size() == 0;
    }
}

