/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.formats;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.BaseFormat;
import com.vmware.vipclient.i18n.exceptions.VIPJavaClientException;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateFormat
extends BaseFormat {
    private Logger logger = LoggerFactory.getLogger(DateFormat.class);

    public String getLocalizedDateFormat(String longDate, String pattern) {
        if (null == longDate || longDate.length() == 0) {
            throw new VIPJavaClientException("longDate can't be empty");
        }
        if (null == pattern || pattern.length() == 0) {
            throw new VIPJavaClientException("pattern can't be empty");
        }
        if (VIPCfg.getInstance().getVipService().getHttpRequester().isConnected()) {
            return this.getFormatFromRemote(longDate, pattern);
        }
        return "";
    }

    private String getFormatFromRemote(String longDate, String pattern) {
        String format = "";
        StringBuffer dateAPIUrl = new StringBuffer(VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL());
        dateAPIUrl.append("/i18n/api/v1/date/localizedDate?locale=");
        dateAPIUrl.append(this.locale);
        dateAPIUrl.append("&longDate=");
        dateAPIUrl.append(longDate);
        dateAPIUrl.append("&pattern=");
        dateAPIUrl.append(pattern);
        String retJsonStr = VIPCfg.getInstance().getVipService().getHttpRequester().request(dateAPIUrl.toString(), "GET", null);
        if (null == retJsonStr || retJsonStr.length() == 0) {
            return format;
        }
        try {
            JSONObject dataJson;
            JSONObject retJson = (JSONObject)JSONValue.parseWithException((String)retJsonStr);
            if (retJson != null && (dataJson = (JSONObject)retJson.get((Object)"data")) != null) {
                format = dataJson.get((Object)"formattedDate") == null ? "" : dataJson.get((Object)"formattedDate").toString();
            }
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage());
        }
        return format;
    }
}

