/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.server;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.messages.api.opt.BaseOpt;
import com.vmware.vipclient.i18n.messages.api.opt.Opt;
import com.vmware.vipclient.i18n.messages.api.url.V2URL;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import java.util.HashMap;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentBasedOpt
extends BaseOpt
implements Opt {
    private Logger logger = LoggerFactory.getLogger((String)ComponentBasedOpt.class.getName());
    private MessagesDTO dto = null;

    public ComponentBasedOpt(MessagesDTO dto) {
        this.dto = dto;
    }

    public JSONObject getComponentMessages() {
        String responseStr;
        String url = V2URL.getComponentTranslationURL(this.dto, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL());
        if ("latest".equals(this.dto.getLocale())) {
            url = url.replace("pseudo=false", "pseudo=true");
        }
        if (null == (responseStr = VIPCfg.getInstance().getVipService().getHttpRequester().request(url, "GET", null)) || responseStr.equals("")) {
            return null;
        }
        if ("latest".equals(this.dto.getLocale())) {
            responseStr = responseStr.replace("#@", "");
        }
        Object dataObj = this.getMessagesFromResponse(responseStr, "messages");
        JSONObject msgObject = null;
        if (dataObj != null && !"".equalsIgnoreCase(dataObj.toString())) {
            msgObject = (JSONObject)dataObj;
        }
        return msgObject;
    }

    public String getString() {
        String k;
        JSONObject jo = this.getComponentMessages();
        Object v = jo.get((Object)(k = this.dto.getKey()));
        return v == null ? "" : (String)v;
    }

    public String postString() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", this.dto.getSource());
        String responseStr = VIPCfg.getInstance().getVipService().getHttpRequester().request(V2URL.getKeyTranslationURL(this.dto, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL()), "POST", params);
        Object o = this.getMessagesFromResponse(responseStr, "translation");
        if (o != null) {
            return (String)o;
        }
        Object m = this.getStatusFromResponse(responseStr, "message");
        if (m != null) {
            this.logger.warn((String)m);
        }
        return "";
    }

    public String postSourceSet(String sourceSet) {
        String status = "";
        if (sourceSet == null || "".equalsIgnoreCase(sourceSet)) {
            return status;
        }
        String responseStr = VIPCfg.getInstance().getVipService().getHttpRequester().request(V2URL.getPostKeys(this.dto, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL()), "POST", sourceSet);
        Object o = this.getStatusFromResponse(responseStr, "code");
        if (o != null) {
            status = o.toString();
        }
        return status;
    }

    public String getTranslationStatus() {
        String status = "";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("checkTranslationStatus", "true");
        String responseStr = VIPCfg.getInstance().getVipService().getHttpRequester().request(V2URL.getComponentTranslationURL(this.dto, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL()), "GET", params);
        if (null == responseStr || responseStr.equals("")) {
            return status;
        }
        Object o = this.getStatusFromResponse(responseStr, "code");
        if (o != null) {
            status = o.toString();
        }
        return status;
    }
}

