/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.messages.api.opt.server.ComponentBasedOpt;
import com.vmware.vipclient.i18n.messages.api.opt.server.StringBasedOpt;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.messages.service.CacheService;
import com.vmware.vipclient.i18n.messages.service.ComponentService;
import com.vmware.vipclient.i18n.util.JSONUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringService {
    private MessagesDTO dto = null;
    Logger logger = LoggerFactory.getLogger(StringService.class);

    public StringService(MessagesDTO dto) {
        this.dto = dto;
    }

    public String getString() {
        String key = this.dto.getKey();
        CacheService cacheservice = new CacheService(this.dto);
        Map<String, String> map = cacheservice.getCacheOfComponent();
        if (map == null && !cacheservice.isContainComponent()) {
            Map<String, String> o = new ComponentService(this.dto).getMessages();
            map = o;
            cacheservice.addCacheOfComponent(map);
        }
        return map == null || map.get(key) == null ? "" : map.get(key);
    }

    public String postString() {
        String r = "";
        if (VIPCfg.getInstance().getMessageOrigin() == DataSourceEnum.VIP) {
            ComponentBasedOpt dao = new ComponentBasedOpt(this.dto);
            r = dao.postString();
        }
        if (r != "") {
            this.dto.setLocale("latest");
            CacheService c = new CacheService(this.dto);
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put(this.dto.getKey(), this.dto.getSource());
            c.updateCacheOfComponent(dataMap);
        }
        return r;
    }

    public boolean postStrings(List<JSONObject> sources) {
        boolean r = false;
        if (VIPCfg.getInstance().getMessageOrigin() == DataSourceEnum.VIP) {
            ComponentBasedOpt dao = new ComponentBasedOpt(this.dto);
            r = "200".equalsIgnoreCase(dao.postSourceSet(sources.toString()));
        }
        if (r) {
            this.dto.setLocale("latest");
            CacheService c = new CacheService(this.dto);
            HashMap<String, String> dataMap = new HashMap<String, String>();
            for (JSONObject jo : sources) {
                dataMap.put((String)jo.get((Object)"key"), jo.get((Object)"source") == null ? "" : (String)jo.get((Object)"source"));
            }
            c.updateCacheOfComponent(dataMap);
        }
        return r;
    }

    public boolean isStringAvailable() {
        boolean r = false;
        String status = "";
        if (VIPCfg.getInstance().getMessageOrigin() == DataSourceEnum.VIP) {
            CacheService c = new CacheService(this.dto);
            Map<String, String> statusMap = c.getCacheOfStatus();
            if (statusMap != null && !statusMap.isEmpty()) {
                status = statusMap.get(this.dto.getKey());
            } else if (!c.isContainStatus()) {
                StringBasedOpt dao = new StringBasedOpt(this.dto);
                String json = dao.getTranslationStatus();
                Map m = null;
                if (!JSONUtils.isEmpty(json)) {
                    try {
                        m = (Map)JSONValue.parseWithException((String)json);
                        if (m != null) {
                            status = m.get(this.dto.getKey()) == null ? "" : (String)m.get(this.dto.getKey());
                        }
                    }
                    catch (ParseException e) {
                        this.logger.error(e.getMessage());
                    }
                }
                c.addCacheOfStatus(m);
            }
            r = "1".equalsIgnoreCase(status);
        }
        return r;
    }
}

