/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.messages.api.opt.local.LocalPatternOpt;
import com.vmware.vipclient.i18n.messages.api.opt.server.RemotePatternOpt;
import com.vmware.vipclient.i18n.messages.service.PatternCacheService;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternService {
    Logger logger = LoggerFactory.getLogger(PatternService.class);

    public JSONObject getPatternsByCategory(String locale, String category) {
        JSONObject patterns = this.getPatterns(locale);
        return (JSONObject)patterns.get((Object)category);
    }

    public JSONObject getPatterns(String locale) {
        JSONObject patterns = null;
        this.logger.debug("Look for pattern from cache!");
        patterns = new PatternCacheService().lookForPatternsFromCache(locale);
        if (patterns == null) {
            patterns = this.getPatternsFromBundle(locale);
            if (patterns == null && !LocaleUtility.isDefaultLocale(locale)) {
                patterns = this.getPatternsFromBundle("en");
            }
            if (null != patterns) {
                this.logger.info("Got the pattern  with   locale [{}].\n", (Object)locale);
                this.logger.info("Cache pattern!\n\n");
                new PatternCacheService().addPatterns(locale, patterns);
            }
        }
        return patterns;
    }

    public JSONObject getPatterns(String language, String region) {
        JSONObject patterns = null;
        this.logger.debug("Look for pattern from cache!");
        String key = language + "_" + region;
        patterns = new PatternCacheService().lookForPatternsFromCache(key);
        if (patterns == null && null != (patterns = this.getPatternsFromBundle(language, region))) {
            this.logger.info("Got the pattern  with   language [{}] region [{}].\n", (Object)language, (Object)region);
            this.logger.info("Cache pattern!\n\n");
            new PatternCacheService().addPatterns(key, patterns);
        }
        return patterns;
    }

    private JSONObject getPatternsFromBundle(String locale) {
        JSONObject patterns = null;
        if (LocaleUtility.isDefaultLocale(locale)) {
            this.logger.info("Got pattern from local bundle!");
            patterns = new LocalPatternOpt().getPatternsByLocale("en");
        } else {
            patterns = VIPCfg.getInstance().getMessageOrigin() == DataSourceEnum.VIP ? new RemotePatternOpt().getPatternsByLocale(locale) : new LocalPatternOpt().getPatternsByLocale(locale);
        }
        return patterns;
    }

    private JSONObject getPatternsFromBundle(String language, String region) {
        JSONObject patterns = null;
        patterns = VIPCfg.getInstance().getMessageOrigin() == DataSourceEnum.VIP ? new RemotePatternOpt().getPatternsByLocale(language, region) : new LocalPatternOpt().getPatternsByLocale("en");
        return patterns;
    }
}

