/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base.cache;

import com.vmware.vipclient.i18n.base.cache.Cache;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class FormattingCache
implements Cache {
    private long expiredTime = 86400000L;
    private long lastClean = System.currentTimeMillis();
    private Map<String, Map<String, String>> formattingMap = new LinkedHashMap<String, Map<String, String>>();
    private int capacityByKey;
    private int capacityX;
    private String dropId;

    @Override
    public Map<String, String> get(String cacheKey) {
        Map<String, String> cachedObject = this.formattingMap.get(cacheKey);
        return cachedObject == null ? null : cachedObject;
    }

    @Override
    public synchronized boolean put(String cacheKey, Map<String, String> map) {
        this.formattingMap.put(cacheKey, map);
        return this.formattingMap.get(cacheKey) != null;
    }

    @Override
    public synchronized boolean remove(String cacheKey) {
        this.formattingMap.remove(cacheKey);
        return !this.formattingMap.containsKey(cacheKey);
    }

    @Override
    public synchronized boolean clear() {
        this.formattingMap.clear();
        return this.formattingMap.isEmpty();
    }

    @Override
    public int size() {
        return this.formattingMap.size();
    }

    @Override
    public Set<String> keySet() {
        return this.formattingMap.keySet();
    }

    @Override
    public synchronized long getExpiredTime() {
        return this.expiredTime;
    }

    @Override
    public synchronized void setExpiredTime(long millis) {
        this.expiredTime = millis;
    }

    @Override
    public synchronized long getLastClean() {
        return this.lastClean;
    }

    @Override
    public synchronized void setLastClean(long millis) {
        this.lastClean = millis;
    }

    public synchronized void setCapacityByKey(int keysize) {
        this.capacityByKey = keysize;
    }

    public synchronized int getCapacityByKey() {
        return this.capacityByKey;
    }

    @Override
    public synchronized void setXCapacity(int capacityX) {
        this.capacityX = capacityX;
    }

    @Override
    public synchronized int getXCapacity() {
        return this.capacityX;
    }

    @Override
    public boolean isExpired() {
        boolean f = false;
        long expired = this.getExpiredTime();
        long lastClean = this.getLastClean();
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastClean > expired) {
            f = true;
        }
        return f;
    }

    @Override
    public String getDropId() {
        return this.dropId;
    }

    public void setDropId(String dropId) {
        this.dropId = dropId;
    }
}

