/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.base.cache.MessageCacheItem;
import com.vmware.vipclient.i18n.messages.api.opt.server.ComponentBasedOpt;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.messages.service.CacheService;
import com.vmware.vipclient.i18n.util.FormatUtils;
import com.vmware.vipclient.i18n.util.JSONUtils;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentService {
    private MessagesDTO dto = null;
    Logger logger = LoggerFactory.getLogger(ComponentService.class);

    public ComponentService(MessagesDTO dto) {
        this.dto = dto;
    }

    private void refreshCacheItem(MessageCacheItem cacheItem, Iterator<DataSourceEnum> msgSourceQueueIter) {
        if (!msgSourceQueueIter.hasNext()) {
            return;
        }
        long timestampOld = cacheItem.getTimestamp();
        DataSourceEnum dataSource = msgSourceQueueIter.next();
        dataSource.createMessageOpt(this.dto).getComponentMessages(cacheItem);
        long timestamp = cacheItem.getTimestamp();
        if (timestampOld == timestamp) {
            this.logger.debug(FormatUtils.format("Failed to get messages for component {0}, locale: {1}, data source: {2}.", this.dto.getComponent(), this.dto.getLocale(), dataSource.toString()));
        }
        if (timestamp == 0L) {
            if (msgSourceQueueIter.hasNext()) {
                this.refreshCacheItem(cacheItem, msgSourceQueueIter);
            } else {
                this.logger.debug(FormatUtils.format("Failed to get messages for component {0}, locale: {1} from any available data source", this.dto.getComponent(), this.dto.getLocale()));
            }
        }
    }

    public MessageCacheItem getMessages() {
        Iterator<Locale> fallbackLocalesIter = LocaleUtility.getFallbackLocales().iterator();
        return this.getMessages(fallbackLocalesIter);
    }

    public MessageCacheItem getMessages(Iterator<Locale> fallbackLocalesIter) {
        CacheService cacheService = new CacheService(this.dto);
        MessageCacheItem cacheItem = null;
        if (cacheService.isContainComponent()) {
            cacheItem = cacheService.getCacheOfComponent();
            if (cacheItem.getCachedData().isEmpty()) {
                if (cacheItem.isExpired()) {
                    this.createCacheItemTask(null);
                }
                MessagesDTO fallbackLocaleDTO = new MessagesDTO(this.dto.getComponent(), cacheItem.getLocale(), this.dto.getProductID(), this.dto.getVersion());
                cacheItem = new ComponentService(fallbackLocaleDTO).getMessages(null);
            } else if (cacheItem.isExpired()) {
                this.refreshCacheItemTask(cacheItem);
            }
        } else {
            cacheItem = this.createCacheItem(fallbackLocalesIter);
        }
        return cacheItem;
    }

    private MessageCacheItem createCacheItem(Iterator<Locale> fallbackLocalesIter) {
        MessagesDTO fallbackLocaleDTO;
        CacheService cacheService = new CacheService(this.dto);
        MessageCacheItem cacheItem = new MessageCacheItem();
        this.refreshCacheItem(cacheItem, VIPCfg.getInstance().getMsgOriginsQueue().iterator());
        if (!cacheItem.getCachedData().isEmpty()) {
            cacheService.addCacheOfComponent(cacheItem);
        } else if (!this.dto.getLocale().equals("source") && fallbackLocalesIter != null && fallbackLocalesIter.hasNext() && !(cacheItem = new ComponentService(fallbackLocaleDTO = new MessagesDTO(this.dto.getComponent(), fallbackLocalesIter.next().toLanguageTag(), this.dto.getProductID(), this.dto.getVersion())).getMessages(fallbackLocalesIter)).getCachedData().isEmpty()) {
            MessageCacheItem cacheItemCopy = new MessageCacheItem(cacheItem.getLocale(), null, null, System.currentTimeMillis(), cacheItem.getMaxAgeMillis());
            cacheService.addCacheOfComponent(cacheItemCopy);
        }
        return cacheItem;
    }

    private void createCacheItemTask(Iterator<Locale> fallbackLocalesIter) {
        Callable<MessageCacheItem> callable = () -> {
            try {
                return this.createCacheItem(fallbackLocalesIter);
            }
            catch (Exception e) {
                return null;
            }
        };
        FutureTask<MessageCacheItem> task = new FutureTask<MessageCacheItem>(callable);
        Thread thread = new Thread(task);
        thread.start();
    }

    private void refreshCacheItemTask(MessageCacheItem cacheItem) {
        Callable<MessageCacheItem> callable = () -> {
            try {
                String cacheItemLocale = cacheItem.getLocale();
                MessagesDTO cacheItemDTO = new MessagesDTO(this.dto.getComponent(), cacheItemLocale, this.dto.getProductID(), this.dto.getVersion());
                new ComponentService(cacheItemDTO).refreshCacheItem(cacheItem, VIPCfg.getInstance().getMsgOriginsQueue().listIterator());
                return cacheItem;
            }
            catch (Exception e) {
                return null;
            }
        };
        FutureTask<MessageCacheItem> task = new FutureTask<MessageCacheItem>(callable);
        Thread thread = new Thread(task);
        thread.start();
    }

    public boolean isComponentAvailable() {
        boolean r = false;
        Long s = null;
        if (VIPCfg.getInstance().getMessageOrigin() == DataSourceEnum.VIP) {
            ComponentBasedOpt dao = new ComponentBasedOpt(this.dto);
            String json = dao.getTranslationStatus();
            if (!JSONUtils.isEmpty(json)) {
                try {
                    s = (Long)JSONValue.parseWithException((String)json);
                }
                catch (ParseException e) {
                    this.logger.error(e.getMessage());
                }
            }
            r = s != null && s == 206L;
        }
        return r;
    }
}

