/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.util;

import com.vmware.vipclient.i18n.VIPCfg;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatUtils {
    static Logger logger = LoggerFactory.getLogger(FormatUtils.class);

    private FormatUtils() {
    }

    public static String format(String pattern, Object ... arguments) {
        String escaped = pattern.replaceAll("'", "''");
        return MessageFormat.format(escaped, arguments);
    }

    @Deprecated
    public static String formatMsg(String pattern, Locale locale, Object ... arguments) {
        if (pattern != null && !pattern.isEmpty() && arguments != null && arguments.length > 0) {
            com.vmware.vipclient.i18n.l2.text.MessageFormat messageFormat = new com.vmware.vipclient.i18n.l2.text.MessageFormat(pattern, locale);
            return messageFormat.format(arguments, new StringBuilder(), new FieldPosition(0)).toString();
        }
        return pattern;
    }

    public static String format(String pattern, Locale locale, Object ... arguments) {
        try {
            com.vmware.vipclient.i18n.l2.text.MessageFormat messageFormat = new com.vmware.vipclient.i18n.l2.text.MessageFormat(pattern, locale);
            pattern = messageFormat.format(arguments, new StringBuilder(), new FieldPosition(0)).toString();
            if (VIPCfg.getInstance().isPseudo() && pattern != null && !pattern.startsWith("#@")) {
                pattern = "@@" + pattern + "@@";
            }
            return pattern;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return pattern;
        }
    }
}

