/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.server;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.cache.LocaleCacheItem;
import com.vmware.vipclient.i18n.messages.api.opt.LocaleOpt;
import com.vmware.vipclient.i18n.messages.api.opt.server.RemoteL2BaseOpt;
import com.vmware.vipclient.i18n.messages.api.url.URLUtils;
import com.vmware.vipclient.i18n.messages.api.url.V2URL;
import com.vmware.vipclient.i18n.messages.dto.LocaleDTO;
import com.vmware.vipclient.i18n.util.JSONUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLocaleOpt
extends RemoteL2BaseOpt
implements LocaleOpt {
    private Logger logger = LoggerFactory.getLogger((String)RemoteLocaleOpt.class.getName());
    private LocaleDTO dto = null;

    public RemoteLocaleOpt(LocaleDTO dto) {
        this.dto = dto;
    }

    @Override
    public void getRegions(String locale, LocaleCacheItem cacheItem) {
        block6: {
            this.logger.debug("Look for regions from Singleton Service for locale [{}]!", (Object)locale);
            try {
                Long maxAgeMillis;
                Map<String, Object> response = this.getResponse(V2URL.getRegionListURL(locale, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL()), "GET", null, cacheItem);
                Integer responseCode = (Integer)response.get("response_code");
                if (responseCode == null || !responseCode.equals(200) && !responseCode.equals(304)) break block6;
                long timestamp = response.get("response_timestamp") != null ? (Long)response.get("response_timestamp") : System.currentTimeMillis();
                String etag = URLUtils.createEtagString((Map)response.get("headers"));
                Long l = maxAgeMillis = response.get("max-age") != null ? (Long)response.get("max-age") : null;
                if (responseCode.equals(200)) {
                    try {
                        String responseBody = (String)response.get("body");
                        Map<String, String> territories = this.getTerritoriesFromResponse(responseBody);
                        if (territories != null) {
                            this.logger.debug("Found the regions from Singleton Service for locale [{}].\n", (Object)locale);
                            territories = JSONUtils.map2SortMap(territories);
                            cacheItem.set(territories, etag, timestamp, maxAgeMillis);
                            break block6;
                        }
                        this.logger.debug("Didn't find the regions from Singleton Service for locale [{}].\n", (Object)locale);
                        cacheItem.set(etag, timestamp, maxAgeMillis);
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to get region data from Singleton Service!");
                    }
                    break block6;
                }
                this.logger.debug("There is no update on Singleton Service for the regions of locale [{}].\n", (Object)locale);
                cacheItem.set(etag, timestamp, maxAgeMillis);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
    }

    @Override
    public void getSupportedLanguages(String locale, LocaleCacheItem cacheItem) {
        block6: {
            this.logger.debug("Look for supported languages from Singleton Service for product [{}], version [{}], locale [{}]!", new Object[]{this.dto.getProductID(), this.dto.getVersion(), locale});
            try {
                Long maxAgeMillis;
                Map<String, Object> response = this.getResponse(V2URL.getSupportedLanguageListURL(VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL(), this.dto, locale), "GET", null, cacheItem);
                Integer responseCode = (Integer)response.get("response_code");
                if (responseCode == null || !responseCode.equals(200) && !responseCode.equals(304)) break block6;
                long timestamp = response.get("response_timestamp") != null ? (Long)response.get("response_timestamp") : System.currentTimeMillis();
                String etag = URLUtils.createEtagString((Map)response.get("headers"));
                Long l = maxAgeMillis = response.get("max-age") != null ? (Long)response.get("max-age") : null;
                if (responseCode.equals(200)) {
                    try {
                        String responseBody = (String)response.get("body");
                        Map<String, String> languages = this.getLanguagesFromResponse(responseBody);
                        if (languages != null) {
                            this.logger.debug("Found the supported languages from Singleton Service for product [{}], version [{}], locale [{}].\n", new Object[]{this.dto.getProductID(), this.dto.getVersion(), locale});
                            languages = JSONUtils.map2SortMap(languages);
                            cacheItem.set(languages, etag, timestamp, maxAgeMillis);
                            break block6;
                        }
                        this.logger.debug("Didn't find the supported languages from Singleton Service for product [{}], version [{}], locale [{}].\n", new Object[]{this.dto.getProductID(), this.dto.getVersion(), locale});
                        cacheItem.set(etag, timestamp, maxAgeMillis);
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to get language data from remote!");
                    }
                    break block6;
                }
                this.logger.debug("There is no update on Singleton Service for the supported languages for product [{}], version [{}], locale [{}].\n", new Object[]{this.dto.getProductID(), this.dto.getVersion(), locale});
                cacheItem.set(etag, timestamp, maxAgeMillis);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
    }

    private Map<String, String> getTerritoriesFromResponse(String responseBody) {
        Map regionMap;
        List dataNode = (List)this.getDataFromResponse(responseBody);
        if (dataNode != null && !dataNode.isEmpty() && (regionMap = (Map)dataNode.get(0)) != null) {
            return (Map)regionMap.get("territories");
        }
        return null;
    }

    private Map<String, String> getLanguagesFromResponse(String responseBody) {
        Map dataNode = (Map)this.getDataFromResponse(responseBody);
        if (dataNode == null || dataNode.isEmpty()) {
            return null;
        }
        HashMap dispMap = null;
        List languagesArray = (List)dataNode.get("languages");
        if (languagesArray != null && !languagesArray.isEmpty()) {
            dispMap = new HashMap();
            for (int i = 0; i < languagesArray.size(); ++i) {
                Map languageNode = (Map)languagesArray.get(i);
                if (languageNode == null) continue;
                dispMap.put(languageNode.get("languageTag"), languageNode.get("displayName"));
            }
        }
        return dispMap;
    }
}

