/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.base.cache.LocaleCacheItem;
import com.vmware.vipclient.i18n.messages.dto.LocaleDTO;
import com.vmware.vipclient.i18n.messages.service.FormattingCacheService;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleService {
    Logger logger = LoggerFactory.getLogger((String)LocaleService.class.getName());
    private LocaleDTO dto = null;

    public LocaleService() {
    }

    public LocaleService(LocaleDTO dto) {
        this.dto = dto;
    }

    public Map<String, String> getRegions(String locale) {
        LocaleCacheItem cacheItem = this.getRegionsByLocale(locale);
        if (!cacheItem.getCachedData().isEmpty()) {
            return cacheItem.getCachedData();
        }
        Iterator<Locale> fallbackLocalesIter = LocaleUtility.getFallbackLocales().iterator();
        while (fallbackLocalesIter.hasNext()) {
            String fallbackLocale = fallbackLocalesIter.next().toLanguageTag();
            if (fallbackLocale.equalsIgnoreCase(locale)) continue;
            this.logger.info("Can't find regions for locale [{}], look for fallback locale [{}] regions as fallback!", (Object)locale, (Object)fallbackLocale);
            cacheItem = this.getRegionsByLocale(fallbackLocale);
            if (cacheItem.getCachedData().isEmpty()) continue;
            break;
        }
        return cacheItem.getCachedData();
    }

    public LocaleCacheItem getRegionsByLocale(String locale) {
        if (locale != null && !locale.isEmpty()) {
            locale = locale.replace("_", "-").toLowerCase();
        }
        LocaleCacheItem cacheItem = null;
        this.logger.debug("Look for region list from cache for locale [{}]", (Object)locale);
        FormattingCacheService formattingCacheService = new FormattingCacheService();
        cacheItem = formattingCacheService.getRegions(locale);
        if (cacheItem != null) {
            if (cacheItem.isExpired()) {
                this.populateRegionsCache(locale, cacheItem);
            }
            this.logger.debug("Find regions from cache for locale [{}]!", (Object)locale);
            return cacheItem;
        }
        cacheItem = new LocaleCacheItem();
        this.getRegionsFromDS(locale, cacheItem, VIPCfg.getInstance().getMsgOriginsQueue().listIterator());
        formattingCacheService.addRegions(locale, cacheItem);
        this.logger.debug("Regions is cached for locale [{}]!\n\n", (Object)locale);
        return cacheItem;
    }

    private void getRegionsFromDS(String locale, LocaleCacheItem cacheItem, ListIterator<DataSourceEnum> msgSourceQueueIter) {
        if (!msgSourceQueueIter.hasNext()) {
            this.logger.error("Failed to get regions for locale {0} from any data source", (Object)locale);
            return;
        }
        DataSourceEnum dataSource = msgSourceQueueIter.next();
        dataSource.createLocaleOpt(this.dto).getRegions(locale, cacheItem);
        if (cacheItem.getCachedData().isEmpty()) {
            this.logger.warn("Failed to get regions for locale {0} from {1} data source", (Object)locale, (Object)dataSource.toString());
            this.getRegionsFromDS(locale, cacheItem, msgSourceQueueIter);
        }
    }

    public Map<String, String> getDisplayNames(String locale) {
        LocaleCacheItem cacheItem = this.getSupportedDisplayNamesByLocale(locale);
        if (!cacheItem.getCachedData().isEmpty()) {
            return cacheItem.getCachedData();
        }
        Iterator<Locale> fallbackLocalesIter = LocaleUtility.getFallbackLocales().iterator();
        while (fallbackLocalesIter.hasNext()) {
            String fallbackLocale = fallbackLocalesIter.next().toLanguageTag();
            if (fallbackLocale.equalsIgnoreCase(locale)) continue;
            this.logger.info("Can't find supported languages for locale [{}], look for fallback locale [{}] languages as fallback!", (Object)locale, (Object)fallbackLocale);
            cacheItem = this.getSupportedDisplayNamesByLocale(fallbackLocale);
            if (cacheItem.getCachedData().isEmpty()) continue;
            break;
        }
        return cacheItem.getCachedData();
    }

    public LocaleCacheItem getSupportedDisplayNamesByLocale(String locale) {
        if (locale != null && !locale.isEmpty()) {
            locale = locale.replace("_", "-").toLowerCase();
        }
        LocaleCacheItem cacheItem = null;
        this.logger.debug("Look for displayNames from cache for locale [{}]", (Object)locale);
        FormattingCacheService formattingCacheService = new FormattingCacheService();
        cacheItem = formattingCacheService.getSupportedLanguages(this.dto, locale);
        if (cacheItem != null) {
            if (cacheItem.isExpired()) {
                this.populateSupportedLanguagesCache(locale, cacheItem);
            }
            this.logger.debug("Find displayNames from cache for product [{}], version [{}], locale [{}]!", new Object[]{this.dto.getProductID(), this.dto.getVersion(), locale});
            return cacheItem;
        }
        cacheItem = new LocaleCacheItem();
        this.getSupportedLanguagesFromDS(locale, cacheItem, VIPCfg.getInstance().getMsgOriginsQueue().listIterator());
        formattingCacheService.addSupportedLanguages(this.dto, locale, cacheItem);
        this.logger.debug("DisplayNames is cached for product [{}], version [{}], locale [{}]!\n\n", new Object[]{this.dto.getProductID(), this.dto.getVersion(), locale});
        return cacheItem;
    }

    private void getSupportedLanguagesFromDS(String locale, LocaleCacheItem cacheItem, ListIterator<DataSourceEnum> msgSourceQueueIter) {
        HashMap dispMap = new HashMap();
        if (!msgSourceQueueIter.hasNext()) {
            this.logger.error("Failed to get supported languages for locale {0} from any data source", (Object)locale);
            return;
        }
        DataSourceEnum dataSource = msgSourceQueueIter.next();
        dataSource.createLocaleOpt(this.dto).getSupportedLanguages(locale, cacheItem);
        if (cacheItem.getCachedData().isEmpty()) {
            this.logger.warn("Failed to get supported languages for locale {0} from {1} data source", (Object)locale, (Object)dataSource.toString());
            this.getSupportedLanguagesFromDS(locale, cacheItem, msgSourceQueueIter);
        }
    }

    private void populateRegionsCache(String locale, LocaleCacheItem cacheItem) {
        Runnable runnable = () -> {
            try {
                this.getRegionsFromDS(locale, cacheItem, VIPCfg.getInstance().getMsgOriginsQueue().listIterator());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void populateSupportedLanguagesCache(String locale, LocaleCacheItem cacheItem) {
        Runnable runnable = () -> {
            try {
                this.getSupportedLanguagesFromDS(locale, cacheItem, VIPCfg.getInstance().getMsgOriginsQueue().listIterator());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }
}

