/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base.instances;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.instances.Message;
import com.vmware.vipclient.i18n.messages.dto.LocaleDTO;
import com.vmware.vipclient.i18n.messages.service.LocaleService;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleMessage
implements Message {
    Logger logger = LoggerFactory.getLogger(LocaleMessage.class);
    private VIPCfg cfg;

    public Map<String, Map<String, String>> getRegionList(List<String> localeList) {
        HashMap<String, Map<String, String>> respMap = new HashMap<String, Map<String, String>>();
        LocaleService localeService = new LocaleService();
        for (String locale : localeList) {
            if (locale == null || locale.isEmpty()) continue;
            Map<String, String> regionMap = localeService.getRegions(locale);
            respMap.put(locale, regionMap);
        }
        return respMap;
    }

    public Map<String, String> getDisplayLanguagesList(String displayLocale) {
        return this.getDisplayNamesFromCLDR(displayLocale);
    }

    public List<String> getSupportedLanguageTagList() {
        Map<String, String> languageTagMap = this.getDisplayNamesFromCLDR(LocaleUtility.getDefaultLocale().toLanguageTag());
        if (languageTagMap != null) {
            Set<String> keyCollection = languageTagMap.keySet();
            return new ArrayList<String>(keyCollection);
        }
        return new ArrayList<String>();
    }

    public List<String> getSupportedDisplayNameList(String displayLocale) {
        Map<String, String> dispNameMap = this.getDisplayNamesFromCLDR(displayLocale);
        if (dispNameMap != null) {
            Collection<String> valueCollection = dispNameMap.values();
            return new ArrayList<String>(valueCollection);
        }
        return new ArrayList<String>();
    }

    private Map<String, String> getDisplayNamesFromCLDR(String locale) {
        LocaleDTO dto = new LocaleDTO(this.cfg);
        LocaleService localeService = new LocaleService(dto);
        return localeService.getDisplayNames(locale);
    }

    public VIPCfg getCfg() {
        return this.cfg;
    }

    public void setCfg(VIPCfg cfg) {
        this.cfg = cfg;
    }
}

