/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base;

import com.vmware.vipclient.i18n.messages.api.opt.LocaleOpt;
import com.vmware.vipclient.i18n.messages.api.opt.MessageOpt;
import com.vmware.vipclient.i18n.messages.api.opt.PatternOpt;
import com.vmware.vipclient.i18n.messages.api.opt.ProductOpt;
import com.vmware.vipclient.i18n.messages.api.opt.local.LocalLocaleOpt;
import com.vmware.vipclient.i18n.messages.api.opt.local.LocalMessagesOpt;
import com.vmware.vipclient.i18n.messages.api.opt.local.LocalPatternOpt;
import com.vmware.vipclient.i18n.messages.api.opt.local.LocalProductOpt;
import com.vmware.vipclient.i18n.messages.api.opt.server.ComponentBasedOpt;
import com.vmware.vipclient.i18n.messages.api.opt.server.RemoteLocaleOpt;
import com.vmware.vipclient.i18n.messages.api.opt.server.RemotePatternOpt;
import com.vmware.vipclient.i18n.messages.api.opt.server.RemoteProductOpt;
import com.vmware.vipclient.i18n.messages.dto.BaseDTO;
import com.vmware.vipclient.i18n.messages.dto.LocaleDTO;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;

public enum DataSourceEnum {
    Bundle{

        @Override
        public ProductOpt createProductOpt(BaseDTO dto) {
            return new LocalProductOpt(dto);
        }

        @Override
        public MessageOpt createMessageOpt(MessagesDTO dto) {
            return new LocalMessagesOpt(dto);
        }

        @Override
        public PatternOpt createPatternOpt() {
            return new LocalPatternOpt();
        }

        @Override
        public LocaleOpt createLocaleOpt(LocaleDTO dto) {
            return new LocalLocaleOpt(dto);
        }
    }
    ,
    VIP{

        @Override
        public ProductOpt createProductOpt(BaseDTO dto) {
            return new RemoteProductOpt(dto);
        }

        @Override
        public MessageOpt createMessageOpt(MessagesDTO dto) {
            return new ComponentBasedOpt(dto);
        }

        @Override
        public PatternOpt createPatternOpt() {
            return new RemotePatternOpt();
        }

        @Override
        public LocaleOpt createLocaleOpt(LocaleDTO dto) {
            return new RemoteLocaleOpt(dto);
        }
    };


    public abstract ProductOpt createProductOpt(BaseDTO var1);

    public abstract MessageOpt createMessageOpt(MessagesDTO var1);

    public abstract PatternOpt createPatternOpt();

    public abstract LocaleOpt createLocaleOpt(LocaleDTO var1);
}

