/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.dto;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.messages.dto.BaseDTO;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesDTO
extends BaseDTO {
    Logger logger = LoggerFactory.getLogger(MessagesDTO.class);
    private String comment;
    private String source;
    private String key;
    private String component;
    private String locale;

    public MessagesDTO() {
        super.setProductID(VIPCfg.getInstance().getProductName());
        super.setVersion(VIPCfg.getInstance().getVersion());
    }

    public MessagesDTO(BaseDTO dto) {
        super.setProductID(dto.getProductID());
        super.setVersion(dto.getVersion());
    }

    public MessagesDTO(String component, String localeLanguageTag, String productName, String version) {
        this.setComponent(component);
        this.setLocale(localeLanguageTag);
        this.setProductID(productName);
        this.setVersion(version);
    }

    public MessagesDTO(String component, String key, String source, String localeLanguageTag, VIPCfg cfg) {
        this.setComponent(component);
        this.setKey(key);
        this.setSource(source);
        this.setLocale(localeLanguageTag);
        if (cfg != null) {
            this.setProductID(cfg.getProductName());
            this.setVersion(cfg.getVersion());
        } else {
            super.setProductID(VIPCfg.getInstance().getProductName());
            super.setVersion(VIPCfg.getInstance().getVersion());
        }
    }

    public String getCompositStrAsCacheKey() {
        StringBuilder key = new StringBuilder(super.getProductID());
        key.append("_");
        key.append(super.getVersion());
        key.append("_");
        key.append(this.component);
        key.append("_");
        key.append(VIPCfg.getInstance().isPseudo());
        key.append("_#");
        key.append(this.locale == null ? "en" : LocaleUtility.fmtToMappedLocale(this.locale).toLanguageTag());
        return key.toString();
    }

    public String encryption(String plainText) {
        String re_md5 = new String();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
            byte[] b = md.digest();
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            re_md5 = buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error(e.getMessage());
        }
        return re_md5;
    }

    public String getTransStatusAsCacheKey() {
        StringBuilder key = new StringBuilder(super.getProductID());
        key.append("_");
        key.append(super.getVersion());
        key.append("_");
        key.append(this.component == null ? "default" : this.component);
        key.append("_");
        key.append("translationStatus");
        key.append("_");
        key.append(this.locale == null ? "en" : LocaleUtility.fmtToMappedLocale(this.locale).toLanguageTag());
        return key.toString();
    }

    public String getLocalesCacheKey(DataSourceEnum dataSource) {
        StringBuilder key = new StringBuilder(super.getProductID());
        key.append("_");
        key.append(super.getVersion());
        key.append("_");
        key.append("locales");
        key.append("_");
        key.append(dataSource.name());
        return key.toString();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = LocaleUtility.normalizeToLanguageTag(locale);
    }
}

