/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.local;

import com.vmware.i18n.PatternUtil;
import com.vmware.i18n.pattern.service.impl.PatternServiceImpl;
import com.vmware.i18n.utils.CommonUtil;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.base.cache.LocaleCacheItem;
import com.vmware.vipclient.i18n.messages.api.opt.LocaleOpt;
import com.vmware.vipclient.i18n.messages.dto.LocaleDTO;
import com.vmware.vipclient.i18n.messages.service.ProductService;
import com.vmware.vipclient.i18n.util.JSONUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalLocaleOpt
implements LocaleOpt {
    private Logger logger = LoggerFactory.getLogger(LocalLocaleOpt.class);
    private LocaleDTO dto = null;

    public LocalLocaleOpt(LocaleDTO dto) {
        this.dto = dto;
    }

    @Override
    public void getSupportedLanguages(String locale, LocaleCacheItem cacheItem) {
        Map<String, String> supportedLanguageNames = new HashMap<String, String>();
        ProductService ps = new ProductService(this.dto);
        Set<String> supportedLanguages = ps.getSupportedLocales(DataSourceEnum.Bundle);
        if (supportedLanguages != null && !supportedLanguages.isEmpty()) {
            Map<String, String> languagesNames = this.getLanguagesNamesFromBundle(locale);
            if (languagesNames == null || languagesNames.isEmpty()) {
                return;
            }
            for (String language : supportedLanguages) {
                if ("source".equalsIgnoreCase(language)) continue;
                supportedLanguageNames.put(language, languagesNames.get(language));
            }
        }
        if (!supportedLanguageNames.isEmpty()) {
            this.logger.debug("Found the supported languages from local bundle for product [{}], version [{}], locale [{}].\n", new Object[]{this.dto.getProductID(), this.dto.getVersion(), locale});
            supportedLanguageNames = JSONUtils.map2SortMap(supportedLanguageNames);
            cacheItem.set(supportedLanguageNames, System.currentTimeMillis());
        } else {
            this.logger.warn("Didn't find the supported languages from local bundle for product [{}], version [{}], locale [{}].\n", new Object[]{this.dto.getProductID(), this.dto.getVersion(), locale});
        }
    }

    private Map<String, String> getLanguagesNamesFromBundle(String locale) {
        this.logger.debug("Look for languages' names from local package bundle for locale [{}]!", (Object)locale);
        String normalizedLocale = CommonUtil.getCLDRLocale((String)locale, (Map)PatternServiceImpl.localePathMap, (Map)PatternServiceImpl.localeAliasesMap);
        this.logger.debug("Normalized locale for locale [{}] is [{}]", (Object)locale, (Object)normalizedLocale);
        if (normalizedLocale == null || normalizedLocale.isEmpty()) {
            this.logger.error("Normalized locale is empty for locale [{}]", (Object)locale);
            return null;
        }
        try {
            String languagesJsonStr = PatternUtil.getLanguageFromLib((String)normalizedLocale);
            Map languagesData = (Map)new JSONParser().parse(languagesJsonStr);
            if (languagesData != null) {
                this.logger.debug("Found the languages' names from local bundle for locale [{}].\n", (Object)locale);
                return (Map)languagesData.get("languages");
            }
            this.logger.warn("Didn't find the languages' names from local bundle for locale [{}].\n", (Object)locale);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
        return null;
    }

    @Override
    public void getRegions(String locale, LocaleCacheItem cacheItem) {
        this.logger.debug("Look for regions from local bundle for locale [{}]!", (Object)locale);
        String normalizedLocale = CommonUtil.getCLDRLocale((String)locale, (Map)PatternServiceImpl.localePathMap, (Map)PatternServiceImpl.localeAliasesMap);
        this.logger.info("Normalized locale for locale [{}] is [{}]", (Object)locale, (Object)normalizedLocale);
        if (normalizedLocale == null || normalizedLocale.isEmpty()) {
            return;
        }
        try {
            String regionsJsonStr = PatternUtil.getRegionFromLib((String)normalizedLocale);
            Map regionsData = (Map)new JSONParser().parse(regionsJsonStr);
            if (regionsData != null) {
                Map<String, String> territories = (Map<String, String>)regionsData.get("territories");
                if (territories != null) {
                    this.logger.debug("Found the regions from local bundle for locale [{}].\n", (Object)locale);
                    territories = JSONUtils.map2SortMap(territories);
                    cacheItem.set(territories, System.currentTimeMillis());
                } else {
                    this.logger.warn("Didn't find the regions from local bundle for locale [{}].\n", (Object)locale);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
    }
}

