/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.l2.text;

import com.vmware.vipclient.i18n.exceptions.Level2Exception;
import com.vmware.vipclient.i18n.util.PatternProps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MessagePattern {
    private ApostropheMode aposMode;
    private String msg;
    private ArrayList<Part> parts = new ArrayList();
    private ArrayList<Double> numericValues;
    private boolean hasArgNames;
    private boolean hasArgNumbers;
    private boolean needsAutoQuoting;
    private volatile boolean frozen;
    private final String dataKey_index = "index";
    private static final ApostropheMode defaultAposMode = ApostropheMode.valueOf("DOUBLE_OPTIONAL");
    private static final ArgType[] argTypes = ArgType.values();
    public static final int ARG_NAME_NOT_NUMBER = -1;
    public static final int ARG_NAME_NOT_VALID = -2;
    public static final double NO_NUMERIC_VALUE = -1.23456789E8;
    private static final int MAX_PREFIX_LENGTH = 24;

    public MessagePattern() {
        this.aposMode = defaultAposMode;
    }

    public MessagePattern(String pattern) {
        this.parse(pattern);
    }

    public MessagePattern(ApostropheMode mode) {
        this.aposMode = mode;
    }

    public MessagePattern parse(String pattern) {
        this.preParse(pattern);
        this.parseMessage(0, 0, 0, ArgType.NONE);
        this.postParse();
        return this;
    }

    public MessagePattern parsePluralStyle(String pattern) {
        this.preParse(pattern);
        this.parsePluralOrSelectStyle(ArgType.PLURAL, 0, 0);
        this.postParse();
        return this;
    }

    private void preParse(String pattern) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to parse(" + MessagePattern.prefix(pattern) + ") on frozen MessagePattern instance.");
        }
        this.msg = pattern;
        this.hasArgNumbers = false;
        this.hasArgNames = false;
        this.needsAutoQuoting = false;
        this.parts.clear();
        if (this.numericValues != null) {
            this.numericValues.clear();
        }
    }

    private void postParse() {
    }

    private int parseMessage(int index, int msgStartLength, int nestingLevel, ArgType parentType) {
        if (nestingLevel > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        int msgStart = this.parts.size();
        this.addPart(Part.Type.MSG_START, index, msgStartLength, nestingLevel);
        index += msgStartLength;
        while (index < this.msg.length()) {
            char c;
            if ((c = this.msg.charAt(index++)) == '\'') {
                index = this.parseApostrophe(index, parentType);
                continue;
            }
            if (parentType.hasPluralStyle() && c == '#') {
                this.addPart(Part.Type.REPLACE_NUMBER, index - 1, 1, 0);
                continue;
            }
            if (c == '{') {
                index = this.parseArg(index - 1, 1, nestingLevel);
                continue;
            }
            if ((nestingLevel <= 0 || c != '}') && (parentType != ArgType.CHOICE || c != '|')) continue;
            return this.getSubmessageLimitIndex(parentType, c, msgStart, index, nestingLevel);
        }
        if (nestingLevel > 0 && !this.inTopLevelChoiceMessage(nestingLevel, parentType)) {
            throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
        }
        this.addLimitPart(msgStart, Part.Type.MSG_LIMIT, index, 0, nestingLevel);
        return index;
    }

    private int parseApostrophe(int index, ArgType parentType) {
        if (index == this.msg.length()) {
            this.addPart(Part.Type.INSERT_CHAR, index, 0, 39);
            this.needsAutoQuoting = true;
        } else {
            char c = this.msg.charAt(index);
            if (c == '\'') {
                this.addPart(Part.Type.SKIP_SYNTAX, index++, 1, 0);
            } else if (this.aposMode == ApostropheMode.DOUBLE_REQUIRED || c == '{' || c == '}' || parentType == ArgType.CHOICE && c == '|' || parentType.hasPluralStyle() && c == '#') {
                int endIndex = this.msg.indexOf(39, index + 1);
                if (c != '{' || !this.msg.substring(index, endIndex).matches("^\\s*\\{\\s*\\d+\\s*\\}\\s*$")) {
                    this.addPart(Part.Type.SKIP_SYNTAX, index - 1, 1, 0);
                    index = this.findEndQuoteIndex(index);
                }
            } else {
                this.addPart(Part.Type.INSERT_CHAR, index, 0, 39);
                this.needsAutoQuoting = true;
            }
        }
        return index;
    }

    public int findEndQuoteIndex(int index) {
        block2: {
            while ((index = this.msg.indexOf(39, index + 1)) >= 0) {
                if (index + 1 < this.msg.length() && this.msg.charAt(index + 1) == '\'') {
                    this.addPart(Part.Type.SKIP_SYNTAX, ++index, 1, 0);
                    continue;
                }
                this.addPart(Part.Type.SKIP_SYNTAX, index++, 1, 0);
                break block2;
            }
            index = this.msg.length();
            this.addPart(Part.Type.INSERT_CHAR, index, 0, 39);
            this.needsAutoQuoting = true;
        }
        return index;
    }

    private int parseArg(int index, int argStartLength, int nestingLevel) {
        int argStart = this.parts.size();
        ArgType argType = ArgType.NONE;
        this.addPart(Part.Type.ARG_START, index, argStartLength, argType.ordinal());
        int nameIndex = index = this.skipWhiteSpace(index + argStartLength);
        if (index == this.msg.length()) {
            throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
        }
        index = this.parseArgNameOrNumber(nameIndex, index);
        if ((index = this.skipWhiteSpace(index)) == this.msg.length()) {
            throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
        }
        char c = this.msg.charAt(index);
        if (c != '}') {
            if (c != ',') {
                throw new IllegalArgumentException("Bad argument syntax: " + this.prefix(nameIndex));
            }
            Map<String, Object> map = this.parseArgType(argStart, nameIndex, index);
            argType = (ArgType)((Object)map.get("argType"));
            index = (Integer)map.get("index");
            index = this.parseArgStyle(argType, nameIndex, index, nestingLevel);
        }
        this.addLimitPart(argStart, Part.Type.ARG_LIMIT, index, 1, argType.ordinal());
        return index + 1;
    }

    public int parseArgNameOrNumber(int nameIndex, int index) {
        int number = this.parseArgNumber(nameIndex, index = this.skipIdentifier(index));
        if (number >= 0) {
            int length = index - nameIndex;
            if (length > 65535 || number > Short.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Argument number too large: " + this.prefix(nameIndex));
            }
            this.hasArgNumbers = true;
            this.addPart(Part.Type.ARG_NUMBER, nameIndex, length, number);
        } else if (number == -1) {
            int length = index - nameIndex;
            if (length > 65535) {
                throw new IndexOutOfBoundsException("Argument name too long: " + this.prefix(nameIndex));
            }
            this.hasArgNames = true;
            this.addPart(Part.Type.ARG_NAME, nameIndex, length, 0);
        } else {
            throw new IllegalArgumentException("Bad argument syntax: " + this.prefix(nameIndex));
        }
        return index;
    }

    public Map<String, Object> parseArgType(int argStart, int nameIndex, int index) {
        char c;
        HashMap<String, Object> map = new HashMap<String, Object>();
        int typeIndex = index = this.skipWhiteSpace(index + 1);
        while (index < this.msg.length() && MessagePattern.isArgTypeChar(this.msg.charAt(index))) {
            ++index;
        }
        int length = index - typeIndex;
        if ((index = this.skipWhiteSpace(index)) == this.msg.length()) {
            throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
        }
        if (length == 0 || (c = this.msg.charAt(index)) != ',' && c != '}') {
            throw new IllegalArgumentException("Bad argument syntax: " + this.prefix(nameIndex));
        }
        if (length > 65535) {
            throw new IndexOutOfBoundsException("Argument type name too long: " + this.prefix(nameIndex));
        }
        ArgType argType = this.getArgType(typeIndex, length);
        this.parts.get(argStart).value = (short)argType.ordinal();
        if (argType == ArgType.SIMPLE) {
            this.addPart(Part.Type.ARG_TYPE, typeIndex, length, 0);
        }
        map.put("index", index);
        map.put("argType", (Object)argType);
        return map;
    }

    private ArgType getArgType(int typeIndex, int typeLength) {
        ArgType argType = ArgType.SIMPLE;
        if (typeLength == 6) {
            if (this.isChoice(typeIndex)) {
                argType = ArgType.CHOICE;
            } else if (this.isPlural(typeIndex)) {
                argType = ArgType.PLURAL;
            } else if (this.isSelect(typeIndex)) {
                argType = ArgType.SELECT;
            }
        } else if (typeLength == 13 && this.isSelectOrdinal(typeIndex)) {
            argType = ArgType.SELECTORDINAL;
        }
        return argType;
    }

    public int parseArgStyle(ArgType argType, int nameIndex, int index, int nestingLevel) {
        char c = this.msg.charAt(index);
        if (c == '}') {
            if (argType != ArgType.SIMPLE) {
                throw new IllegalArgumentException("No style field for complex argument: " + this.prefix(nameIndex));
            }
        } else {
            ++index;
            if (argType == ArgType.SIMPLE) {
                index = this.parseSimpleStyle(index);
            } else if (argType == ArgType.PLURAL || argType == ArgType.SELECT) {
                index = this.parsePluralOrSelectStyle(argType, index, nestingLevel);
            } else {
                throw new Level2Exception("Unsupported argument type '" + argType.toString() + "'!");
            }
        }
        return index;
    }

    private int getSubmessageLimitIndex(ArgType parentType, char c, int msgStart, int index, int nestingLevel) {
        int limitLength = parentType == ArgType.CHOICE && c == '}' ? 0 : 1;
        this.addLimitPart(msgStart, Part.Type.MSG_LIMIT, index - 1, limitLength, nestingLevel);
        if (parentType == ArgType.CHOICE) {
            return index - 1;
        }
        return index;
    }

    private int parseSimpleStyle(int index) {
        int start = index;
        int styleIndex = index;
        int nestedBraces = 0;
        while (styleIndex < this.msg.length()) {
            int length;
            char c;
            if ((c = this.msg.charAt(styleIndex++)) == '\'') {
                if ((styleIndex = this.msg.indexOf(39, styleIndex)) < 0) {
                    throw new IllegalArgumentException("Quoted literal argument style text reaches to the end of the message: " + this.prefix(start));
                }
                ++styleIndex;
                continue;
            }
            if (c == '{') {
                ++nestedBraces;
                continue;
            }
            if (c != '}') continue;
            if (nestedBraces > 0) {
                --nestedBraces;
                continue;
            }
            if ((length = --styleIndex - start) > 65535) {
                throw new IndexOutOfBoundsException("Argument style text too long: " + this.prefix(start));
            }
            this.addPart(Part.Type.ARG_STYLE, start, length, 0);
            return styleIndex;
        }
        throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
    }

    private int parsePluralOrSelectStyle(ArgType argType, int index, int nestingLevel) {
        int start = index;
        boolean isEmpty = true;
        boolean hasOther = false;
        while (!this.checkTerminators(argType, start, index = this.skipWhiteSpace(index), nestingLevel, hasOther)) {
            int selectorIndex = index;
            if (argType.hasPluralStyle() && this.msg.charAt(selectorIndex) == '=') {
                index = this.parseExplicitValuePluralSelector(argType, start, selectorIndex, index);
            } else {
                Map<String, Object> map = this.parsePluralOffsetOrNormalSelector(argType, start, selectorIndex, index, isEmpty);
                index = (Integer)map.get("index");
                isEmpty = (Boolean)map.get("isEmpty");
                hasOther = (Boolean)map.get("hasOther");
                boolean hasOffset = (Boolean)map.get("hasOffset");
                if (hasOffset) continue;
            }
            index = this.skipWhiteSpace(index);
            if (index == this.msg.length() || this.msg.charAt(index) != '{') {
                throw new IllegalArgumentException("No message fragment after " + argType.toString().toLowerCase(Locale.ENGLISH) + " selector: " + this.prefix(selectorIndex));
            }
            index = this.parseMessage(index, 1, nestingLevel + 1, argType);
            isEmpty = false;
        }
        return index;
    }

    private boolean checkTerminators(ArgType argType, int start, int index, int nestingLevel, boolean hasOther) {
        boolean eos;
        boolean hasTerminates = false;
        boolean bl = eos = index == this.msg.length();
        if (eos || this.msg.charAt(index) == '}') {
            if (eos == this.inMessageFormatPattern(nestingLevel)) {
                throw new IllegalArgumentException("Bad " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern syntax: " + this.prefix(start));
            }
            if (!hasOther) {
                throw new IllegalArgumentException("Missing 'other' keyword in " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern in " + this.prefix());
            }
            hasTerminates = true;
        }
        return hasTerminates;
    }

    public int parseExplicitValuePluralSelector(ArgType argType, int start, int selectorIndex, int index) {
        int length = (index = this.skipDouble(index + 1)) - selectorIndex;
        if (length == 1) {
            throw new IllegalArgumentException("Bad " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern syntax: " + this.prefix(start));
        }
        if (length > 65535) {
            throw new IndexOutOfBoundsException("Argument selector too long: " + this.prefix(selectorIndex));
        }
        this.addPart(Part.Type.ARG_SELECTOR, selectorIndex, length, 0);
        this.parseDouble(selectorIndex + 1, index, false);
        return index;
    }

    public Map<String, Object> parsePluralOffsetOrNormalSelector(ArgType argType, int start, int selectorIndex, int index, boolean isEmpty) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean hasOther = false;
        boolean hasOffset = false;
        int length = (index = this.skipIdentifier(index)) - selectorIndex;
        if (length == 0) {
            throw new IllegalArgumentException("Bad " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern syntax: " + this.prefix(start));
        }
        if (argType.hasPluralStyle() && length == 6 && index < this.msg.length() && this.msg.regionMatches(selectorIndex, "offset:", 0, 7)) {
            index = this.parsePluralOffset(isEmpty, start, index);
            isEmpty = false;
            hasOffset = true;
        } else {
            if (length > 65535) {
                throw new IndexOutOfBoundsException("Argument selector too long: " + this.prefix(selectorIndex));
            }
            this.addPart(Part.Type.ARG_SELECTOR, selectorIndex, length, 0);
            if (this.msg.regionMatches(selectorIndex, "other", 0, length)) {
                hasOther = true;
            }
        }
        map.put("index", index);
        map.put("isEmpty", isEmpty);
        map.put("hasOther", hasOther);
        map.put("hasOffset", hasOffset);
        return map;
    }

    public int parsePluralOffset(boolean isEmpty, int start, int index) {
        if (!isEmpty) {
            throw new IllegalArgumentException("Plural argument 'offset:' (if present) must precede key-message pairs: " + this.prefix(start));
        }
        int valueIndex = this.skipWhiteSpace(index + 1);
        if ((index = this.skipDouble(valueIndex)) == valueIndex) {
            throw new IllegalArgumentException("Missing value for plural 'offset:' " + this.prefix(start));
        }
        if (index - valueIndex > 65535) {
            throw new IndexOutOfBoundsException("Plural offset value too long: " + this.prefix(valueIndex));
        }
        this.parseDouble(valueIndex, index, false);
        return index;
    }

    private static int parseArgNumber(CharSequence s, int start, int limit) {
        if (s.charAt(start) == '0' && limit - start == 1 || s.charAt(start) != '0' && MessagePattern.isNumeric(s.subSequence(start, limit).toString())) {
            return Integer.parseInt(s.subSequence(start, limit).toString());
        }
        if (s.charAt(start) == '0' && limit - start > 1 && MessagePattern.isNumeric(s.subSequence(start, limit).toString())) {
            return -2;
        }
        return -1;
    }

    public static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            char chr = str.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    private int parseArgNumber(int start, int limit) {
        return MessagePattern.parseArgNumber(this.msg, start, limit);
    }

    private void parseDouble(int start, int limit, boolean allowInfinity) {
        block7: {
            char c;
            int index;
            int isNegative;
            block8: {
                block6: {
                    assert (start < limit);
                    isNegative = 0;
                    index = start;
                    if ((c = this.msg.charAt(index++)) != '-') break block6;
                    isNegative = 1;
                    if (index == limit) break block7;
                    c = this.msg.charAt(index++);
                    break block8;
                }
                if (c != '+') break block8;
                if (index == limit) break block7;
                c = this.msg.charAt(index++);
            }
            int isInfinity = this.parseInfinity(c, start, limit, index, isNegative, allowInfinity);
            if (isInfinity == 1) {
                return;
            }
            if (isInfinity != 2) {
                this.parseNumber(c, start, limit, index, isNegative);
                return;
            }
        }
        throw new NumberFormatException("Bad syntax for numeric value: " + this.msg.substring(start, limit));
    }

    private int parseInfinity(char c, int start, int limit, int index, int isNegative, boolean allowInfinity) {
        int isInfinity = 0;
        if (c == '\u221e') {
            if (allowInfinity && index == limit) {
                this.addArgDoublePart(isNegative != 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY, start, limit - start);
                isInfinity = 1;
            } else {
                isInfinity = 2;
            }
        }
        return isInfinity;
    }

    private void parseNumber(char c, int start, int limit, int index, int isNegative) {
        int value = 0;
        while ('0' <= c && c <= '9' && (value = value * 10 + (c - 48)) <= Short.MAX_VALUE + isNegative) {
            if (index == limit) {
                this.addPart(Part.Type.ARG_INT, start, limit - start, isNegative != 0 ? -value : value);
                return;
            }
            c = this.msg.charAt(index++);
        }
        double numericValue = Double.parseDouble(this.msg.substring(start, limit));
        this.addArgDoublePart(numericValue, start, limit - start);
    }

    static void appendReducedApostrophes(String s, int start, int limit, StringBuilder sb) {
        int doubleApos = -1;
        while (true) {
            int i;
            if ((i = s.indexOf(39, start)) < 0 || i >= limit) break;
            if (i == doubleApos) {
                sb.append('\'');
                ++start;
                doubleApos = -1;
                continue;
            }
            sb.append(s, start, i);
            doubleApos = start = i + 1;
        }
        sb.append(s, start, limit);
    }

    public void clear() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to clear() a frozen MessagePattern instance.");
        }
        this.msg = null;
        this.hasArgNumbers = false;
        this.hasArgNames = false;
        this.needsAutoQuoting = false;
        this.parts.clear();
        if (this.numericValues != null) {
            this.numericValues.clear();
        }
    }

    public void clearPatternAndSetApostropheMode(ApostropheMode mode) {
        this.clear();
        this.aposMode = mode;
    }

    public ApostropheMode getApostropheMode() {
        return this.aposMode;
    }

    boolean jdkAposMode() {
        return this.aposMode == ApostropheMode.DOUBLE_REQUIRED;
    }

    public String getPatternString() {
        return this.msg;
    }

    public boolean hasNamedArguments() {
        return this.hasArgNames;
    }

    public boolean hasNumberedArguments() {
        return this.hasArgNumbers;
    }

    public String toString() {
        return this.msg;
    }

    public static int validateArgumentName(String name) {
        if (!PatternProps.isIdentifier(name)) {
            return -2;
        }
        return MessagePattern.parseArgNumber(name, 0, name.length());
    }

    public String autoQuoteApostropheDeep() {
        int count;
        if (!this.needsAutoQuoting) {
            return this.msg;
        }
        StringBuilder modified = null;
        for (int i = count = this.countParts(); i > 0; --i) {
            Part part = this.getPart(i - 1);
            if (part.getType() != Part.Type.INSERT_CHAR) continue;
            if (modified == null) {
                modified = new StringBuilder(this.msg.length() + 10).append(this.msg);
            }
            modified.insert(part.index, (char)part.value);
        }
        if (modified == null) {
            return this.msg;
        }
        return modified.toString();
    }

    public int countParts() {
        return this.parts.size();
    }

    public Part getPart(int i) {
        return this.parts.get(i);
    }

    public Part.Type getPartType(int i) {
        return this.parts.get(i).type;
    }

    public int getPatternIndex(int partIndex) {
        return this.parts.get(partIndex).index;
    }

    public String getSubstring(Part part) {
        int index = part.index;
        return this.msg.substring(index, index + part.length);
    }

    public boolean partSubstringMatches(Part part, String s) {
        return part.length == s.length() && this.msg.regionMatches(part.index, s, 0, part.length);
    }

    public double getNumericValue(Part part) {
        Part.Type type = part.type;
        if (type == Part.Type.ARG_INT) {
            return part.value;
        }
        if (type == Part.Type.ARG_DOUBLE) {
            return this.numericValues.get(part.value);
        }
        return -1.23456789E8;
    }

    public double getPluralOffset(int pluralStart) {
        Part part = this.parts.get(pluralStart);
        if (part.type.hasNumericValue()) {
            return this.getNumericValue(part);
        }
        return 0.0;
    }

    public int getLimitPartIndex(int start) {
        int limit = this.parts.get(start).limitPartIndex;
        if (limit < start) {
            return start;
        }
        return limit;
    }

    private int skipWhiteSpace(int index) {
        return PatternProps.skipWhiteSpace(this.msg, index);
    }

    private int skipIdentifier(int index) {
        return PatternProps.skipIdentifier(this.msg, index);
    }

    private int skipDouble(int index) {
        char c;
        while (!(index >= this.msg.length() || (c = this.msg.charAt(index)) < '0' && "+-.".indexOf(c) < 0 || c > '9' && c != 'e' && c != 'E' && c != '\u221e')) {
            ++index;
        }
        return index;
    }

    private static boolean isArgTypeChar(int c) {
        return 97 <= c && c <= 122 || 65 <= c && c <= 90;
    }

    private boolean isChoice(int index) {
        String argType = this.msg.substring(index, index + 6);
        return argType.equalsIgnoreCase("choice");
    }

    private boolean isPlural(int index) {
        String argType = this.msg.substring(index, index + 6);
        return argType.equalsIgnoreCase("plural");
    }

    private boolean isSelect(int index) {
        String argType = this.msg.substring(index, index + 6);
        return argType.equalsIgnoreCase("select");
    }

    private boolean isOrdinal(int index) {
        String argType = this.msg.substring(index, index + 7);
        return argType.equalsIgnoreCase("ordinal");
    }

    private boolean isSelectOrdinal(int typeIndex) {
        return this.isSelect(typeIndex) && this.isOrdinal(typeIndex + 6);
    }

    private boolean inMessageFormatPattern(int nestingLevel) {
        return nestingLevel > 0 || this.parts.get(0).type == Part.Type.MSG_START;
    }

    private boolean inTopLevelChoiceMessage(int nestingLevel, ArgType parentType) {
        return nestingLevel == 1 && parentType == ArgType.CHOICE && this.parts.get(0).type != Part.Type.MSG_START;
    }

    private void addPart(Part.Type type, int index, int length, int value) {
        this.parts.add(new Part(type, index, length, value));
    }

    private void addLimitPart(int start, Part.Type type, int index, int length, int value) {
        this.parts.get(start).limitPartIndex = this.parts.size();
        this.addPart(type, index, length, value);
    }

    private void addArgDoublePart(double numericValue, int start, int length) {
        int numericIndex;
        if (this.numericValues == null) {
            this.numericValues = new ArrayList();
            numericIndex = 0;
        } else {
            numericIndex = this.numericValues.size();
            if (numericIndex > Short.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Too many numeric values");
            }
        }
        this.numericValues.add(numericValue);
        this.addPart(Part.Type.ARG_DOUBLE, start, length, numericIndex);
    }

    private static String prefix(String s, int start) {
        StringBuilder prefix = new StringBuilder(44);
        if (start == 0) {
            prefix.append("\"");
        } else {
            prefix.append("[at pattern index ").append(start).append("] \"");
        }
        int substringLength = s.length() - start;
        if (substringLength <= 24) {
            prefix.append(start == 0 ? s : s.substring(start));
        } else {
            int limit = start + 24 - 4;
            if (Character.isHighSurrogate(s.charAt(limit - 1))) {
                --limit;
            }
            prefix.append(s, start, limit).append(" ...");
        }
        return prefix.append("\"").toString();
    }

    private static String prefix(String s) {
        return MessagePattern.prefix(s, 0);
    }

    private String prefix(int start) {
        return MessagePattern.prefix(this.msg, start);
    }

    private String prefix() {
        return MessagePattern.prefix(this.msg, 0);
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public static final class Part {
        private static final int MAX_LENGTH = 65535;
        private static final int MAX_VALUE = Short.MAX_VALUE;
        private final Type type;
        private final int index;
        private final char length;
        private short value;
        private int limitPartIndex;

        private Part(Type t, int i, int l, int v) {
            this.type = t;
            this.index = i;
            this.length = (char)l;
            this.value = (short)v;
        }

        public Type getType() {
            return this.type;
        }

        public int getIndex() {
            return this.index;
        }

        public int getLength() {
            return this.length;
        }

        public int getLimit() {
            return this.index + this.length;
        }

        public int getValue() {
            return this.value;
        }

        public ArgType getArgType() {
            Type msgType = this.getType();
            if (msgType == Type.ARG_START || msgType == Type.ARG_LIMIT) {
                return argTypes[this.value];
            }
            return ArgType.NONE;
        }

        public static enum Type {
            MSG_START,
            MSG_LIMIT,
            SKIP_SYNTAX,
            INSERT_CHAR,
            REPLACE_NUMBER,
            ARG_START,
            ARG_LIMIT,
            ARG_NUMBER,
            ARG_NAME,
            ARG_TYPE,
            ARG_STYLE,
            ARG_SELECTOR,
            ARG_INT,
            ARG_DOUBLE;


            public boolean hasNumericValue() {
                return this == ARG_INT || this == ARG_DOUBLE;
            }
        }
    }

    public static enum ArgType {
        NONE,
        SIMPLE,
        CHOICE,
        PLURAL,
        SELECT,
        SELECTORDINAL;


        public boolean hasPluralStyle() {
            return this == PLURAL || this == SELECTORDINAL;
        }
    }

    public static enum ApostropheMode {
        DOUBLE_OPTIONAL,
        DOUBLE_REQUIRED;

    }
}

