/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.cache.MessageCacheItem;
import com.vmware.vipclient.i18n.exceptions.VIPJavaClientException;
import com.vmware.vipclient.i18n.messages.api.opt.server.ComponentsBasedOpt;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.messages.service.CacheService;
import com.vmware.vipclient.i18n.util.FormatUtils;
import com.vmware.vipclient.i18n.util.JSONUtils;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentsService {
    Logger logger = LoggerFactory.getLogger(ComponentsService.class);
    private final VIPCfg cfg;

    public ComponentsService(VIPCfg config) {
        this.cfg = config;
    }

    public Map<Locale, Map<String, Map<String, String>>> getTranslation(Set<String> components, Set<Locale> locales) {
        Iterator<Locale> fallbackLocalesIter = LocaleUtility.getFallbackLocales().iterator();
        return this.getTranslation(components, locales, fallbackLocalesIter);
    }

    private Map<Locale, Map<String, Map<String, String>>> getTranslation(Set<String> components, Set<Locale> locales, Iterator<Locale> fallbackLocalesIter) {
        HashMap<String, Map<String, Map<String, String>>> dataMap = new HashMap<String, Map<String, Map<String, String>>>();
        TreeSet localesSet = new TreeSet(locales.stream().map(Locale::toLanguageTag).collect(Collectors.toSet()));
        TreeSet<String> componentsToQuery = new TreeSet<String>();
        TreeSet<String> localesToQuery = new TreeSet<String>();
        for (String locale : localesSet) {
            HashMap<String, Map<String, String>> localeMap = new HashMap<String, Map<String, String>>();
            for (String component : components) {
                MessagesDTO dto = new MessagesDTO();
                dto.setProductID(this.cfg.getProductName());
                dto.setVersion(this.cfg.getVersion());
                dto.setLocale(locale);
                dto.setComponent(component);
                CacheService cs = new CacheService(dto);
                MessageCacheItem cacheItem = cs.getCacheOfComponent();
                if (cacheItem != null) {
                    localeMap.put(component, cacheItem.getCachedData());
                    continue;
                }
                componentsToQuery.add(component);
                localesToQuery.add(locale);
            }
            dataMap.put(locale, localeMap);
        }
        if (componentsToQuery.isEmpty() || localesToQuery.isEmpty()) {
            return this.convertDataMap(dataMap, locales);
        }
        ComponentsBasedOpt opt = new ComponentsBasedOpt(this.cfg);
        MessageCacheItem cacheItem = new MessageCacheItem();
        JSONObject data = opt.queryFromServer(componentsToQuery, localesToQuery, cacheItem);
        if (data != null) {
            JSONArray bundles = (JSONArray)JSONUtils.getFromJSONObject(data, "bundles");
            JSONArray localesFromServer = (JSONArray)JSONUtils.getFromJSONObject(data, "locales");
            Map<String, String> localeMap = this.makeLocaleMap(localesToQuery, localesFromServer.toList().stream().map(obj -> obj == null ? null : obj.toString()).collect(Collectors.toList()));
            TreeSet<String> localesToFallback = new TreeSet<String>();
            TreeSet<String> componentsToFallback = new TreeSet<String>();
            for (JSONObject bundle : bundles) {
                String locale = localeMap.get((String)JSONUtils.getFromJSONObject(bundle, "locale"));
                String comp = (String)JSONUtils.getFromJSONObject(bundle, "component");
                JSONObject messages = null;
                try {
                    Object object = JSONUtils.getFromJSONObject(bundle, "messages");
                    if (object instanceof JSONObject) {
                        messages = (JSONObject)JSONUtils.getFromJSONObject(bundle, "messages");
                    }
                }
                catch (JSONException e2) {
                    this.logger.info("can't get messages, null will be set");
                }
                if (messages != null && !"".equals(messages)) {
                    MessagesDTO dto = new MessagesDTO();
                    dto.setComponent(comp);
                    dto.setLocale(locale);
                    new CacheService(dto).addCacheOfComponent(new MessageCacheItem(messages.toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue())), null, cacheItem.getTimestamp(), cacheItem.getMaxAgeMillis()));
                    ((Map)dataMap.get(locale)).put(comp, messages.toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue())));
                    continue;
                }
                localesToFallback.add(locale);
                componentsToFallback.add(comp);
            }
            if (!componentsToFallback.isEmpty()) {
                this.supplyFallbackLocaleMessages(fallbackLocalesIter, componentsToFallback, localesToFallback, dataMap);
            }
        } else {
            this.supplyFallbackLocaleMessages(fallbackLocalesIter, componentsToQuery, localesToQuery, dataMap);
        }
        return this.convertDataMap(dataMap, locales);
    }

    private Map<Locale, Map<String, Map<String, String>>> convertDataMap(Map<String, Map<String, Map<String, String>>> dataMap, Set<Locale> locales) {
        HashMap<Locale, Map<String, Map<String, String>>> retMap = new HashMap<Locale, Map<String, Map<String, String>>>();
        for (Locale locale : locales) {
            retMap.put(locale, dataMap.get(locale.toLanguageTag()));
        }
        return retMap;
    }

    private Map<String, String> makeLocaleMap(SortedSet<String> localesToQuery, List<String> localesFromServer) {
        if (localesToQuery.size() != localesFromServer.size()) {
            throw new VIPJavaClientException("The content from server is wrong!");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iterOriginal = localesToQuery.iterator();
        Iterator<String> iterServer = localesFromServer.iterator();
        while (iterOriginal.hasNext()) {
            map.put(iterServer.next(), (String)iterOriginal.next());
        }
        return map;
    }

    private void supplyFallbackLocaleMessages(Iterator<Locale> fallbackLocalesIter, Set<String> componentsToFallback, Set<String> localesToFallback, Map<String, Map<String, Map<String, String>>> dataMap) {
        if (fallbackLocalesIter != null && fallbackLocalesIter.hasNext()) {
            Locale fallbackLocale = fallbackLocalesIter.next();
            if (fallbackLocale.toLanguageTag().equals("source")) {
                fallbackLocale = Locale.forLanguageTag("latest");
            }
            HashSet<Locale> localeSet = new HashSet<Locale>();
            localeSet.add(fallbackLocale);
            Map<Locale, Map<String, Map<String, String>>> localeDataMap = this.getTranslation(componentsToFallback, localeSet, fallbackLocalesIter);
            Map<String, Map<String, String>> componentsMap = localeDataMap.get(fallbackLocale);
            if (componentsMap != null && !componentsMap.isEmpty()) {
                TreeSet<String> localesFallbackFailed = new TreeSet<String>();
                TreeSet<String> componentsFallbackFailed = new TreeSet<String>();
                for (String locale : localesToFallback) {
                    for (String component : componentsToFallback) {
                        if (dataMap.get(locale).get(component) != null) continue;
                        Map<String, String> componentMap = componentsMap.get(component);
                        if (componentMap != null) {
                            dataMap.get(locale).put(component, componentMap);
                            continue;
                        }
                        localesFallbackFailed.add(locale);
                        componentsFallbackFailed.add(component);
                    }
                }
                if (!componentsFallbackFailed.isEmpty()) {
                    this.logger.error(FormatUtils.format("Failed to get fallback messages for component {0}, locale: {1}", ((Object)componentsFallbackFailed).toString(), ((Object)localesFallbackFailed).toString()));
                }
            } else {
                this.logger.error(FormatUtils.format("Failed to get fallback messages for component {0}, locale: {1}", componentsToFallback.toString(), ((Object)localeSet).toString()));
            }
        }
    }
}

