/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.base.cache.MessageCacheItem;
import com.vmware.vipclient.i18n.messages.api.opt.server.ComponentBasedOpt;
import com.vmware.vipclient.i18n.messages.api.opt.server.StringBasedOpt;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.messages.service.BaseService;
import com.vmware.vipclient.i18n.messages.service.CacheService;
import com.vmware.vipclient.i18n.messages.service.ComponentService;
import com.vmware.vipclient.i18n.util.FormatUtils;
import com.vmware.vipclient.i18n.util.JSONUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringService
extends BaseService {
    Logger logger = LoggerFactory.getLogger(StringService.class);
    private MessagesDTO dto = null;

    public StringService() {
    }

    public StringService(MessagesDTO dto) {
        this.dto = dto;
    }

    @Deprecated
    public String getString(MessagesDTO dto) {
        MessageCacheItem cacheItem = new ComponentService(dto).getMessages();
        Map<String, String> cachedData = cacheItem.getCachedData();
        return cachedData.get(dto.getKey());
    }

    public String postString(MessagesDTO dto) {
        String r = "";
        if (VIPCfg.getInstance().getMessageOrigin() == DataSourceEnum.VIP) {
            ComponentBasedOpt dao = new ComponentBasedOpt(dto);
            r = dao.postString();
        }
        if (null != r && !r.equals("")) {
            dto.setLocale("latest");
            CacheService c = new CacheService(dto);
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put(dto.getKey(), dto.getSource());
            c.updateCacheOfComponent(new MessageCacheItem(dataMap));
        }
        return r;
    }

    public boolean postStrings(List<JSONObject> sources, MessagesDTO dto) {
        boolean r = false;
        if (VIPCfg.getInstance().getMessageOrigin() == DataSourceEnum.VIP) {
            ComponentBasedOpt dao = new ComponentBasedOpt(dto);
            r = "200".equalsIgnoreCase(dao.postSourceSet(sources.toString()));
        }
        if (r) {
            dto.setLocale("latest");
            CacheService c = new CacheService(dto);
            HashMap<String, String> dataMap = new HashMap<String, String>();
            for (JSONObject jo : sources) {
                dataMap.put((String)JSONUtils.getFromJSONObject(jo, "key"), JSONUtils.getFromJSONObject(jo, "source") == null ? "" : (String)JSONUtils.getFromJSONObject(jo, "source"));
            }
            c.updateCacheOfComponent(new MessageCacheItem(dataMap));
        }
        return r;
    }

    public boolean isStringAvailable(MessagesDTO dto) {
        boolean r = false;
        String status = "";
        if (VIPCfg.getInstance().getMessageOrigin() == DataSourceEnum.VIP) {
            CacheService c = new CacheService(dto);
            Map<String, String> statusMap = c.getCacheOfStatus();
            if (statusMap != null && !statusMap.isEmpty()) {
                status = statusMap.get(dto.getKey());
            } else if (!c.isContainStatus()) {
                StringBasedOpt dao = new StringBasedOpt(dto);
                String json = dao.getTranslationStatus();
                Map m = null;
                if (!JSONUtils.isEmpty(json)) {
                    try {
                        JSONObject jsonObject = new JSONObject(json);
                        m = jsonObject.toMap();
                        if (m != null) {
                            status = m.get(dto.getKey()) == null ? "" : (String)m.get(dto.getKey());
                        }
                    }
                    catch (JSONException e) {
                        this.logger.error(e.getMessage());
                    }
                }
                c.addCacheOfStatus(m);
            }
            r = "1".equalsIgnoreCase(status);
        }
        return r;
    }

    public ComponentService.TranslationsDTO getMultiVersionKeyCacheItem(String version, Iterator<Locale> fallbackLocalesIter) {
        MessagesDTO dto4LocaleList = new MessagesDTO(this.dto);
        dto4LocaleList.setVersion(version);
        dto4LocaleList.setLocale(this.dto.getLocale());
        this.doLocaleMatching(dto4LocaleList);
        this.dto.setLocale(dto4LocaleList.getLocale());
        CacheService cacheService = new CacheService(this.dto);
        MessageCacheItem cacheItem = cacheService.getCacheOfMultiVersionKey();
        if (cacheItem != null) {
            if (cacheItem.isExpired()) {
                this.refreshMultiVersionKeyCacheItemTask(dto4LocaleList, cacheItem);
            }
        } else {
            cacheItem = this.createMultiVersionKeyCacheItem(dto4LocaleList);
            if (cacheItem.getCachedData().isEmpty()) {
                return this.getFallbackLocaleMessages(version, fallbackLocalesIter);
            }
        }
        return new ComponentService.TranslationsDTO(this.dto.getLocale(), cacheItem);
    }

    private ComponentService.TranslationsDTO getFallbackLocaleMessages(String version, Iterator<Locale> fallbackLocalesIter) {
        if (fallbackLocalesIter != null && fallbackLocalesIter.hasNext()) {
            Locale fallbackLocale = fallbackLocalesIter.next();
            if (fallbackLocale.toLanguageTag().equals(this.dto.getLocale())) {
                return this.getFallbackLocaleMessages(version, fallbackLocalesIter);
            }
            MessagesDTO fallbackLocaleDTO = new MessagesDTO(this.dto.getProductID(), this.dto.getVersion(), this.dto.getComponent(), fallbackLocale.toLanguageTag(), this.dto.getKey());
            return new StringService(fallbackLocaleDTO).getMultiVersionKeyCacheItem(version, fallbackLocalesIter);
        }
        return new ComponentService.TranslationsDTO(this.dto.getLocale(), new MessageCacheItem());
    }

    private MessageCacheItem createMultiVersionKeyCacheItem(MessagesDTO dto4LocaleList) {
        CacheService cacheService = new CacheService(this.dto);
        MessageCacheItem cacheItem = new MessageCacheItem();
        this.refreshMultiVersionKeyCacheItem(dto4LocaleList, cacheItem, VIPCfg.getInstance().getMsgOriginsQueue().iterator());
        if (!cacheItem.getCachedData().isEmpty()) {
            cacheService.addCacheOfMultiVersionKey(cacheItem);
        }
        return cacheItem;
    }

    public void refreshMultiVersionKeyCacheItem(MessagesDTO dto4LocaleList, MessageCacheItem cacheItem, Iterator<DataSourceEnum> msgSourceQueueIter) {
        if (!msgSourceQueueIter.hasNext()) {
            this.logger.debug(FormatUtils.format("Failed to get messages for versions {0}, component {1}, locale: {2}, key {3} from any available data source", this.dto.getVersion(), this.dto.getComponent(), this.dto.getLocale(), this.dto.getKey()));
            return;
        }
        DataSourceEnum dataSource = msgSourceQueueIter.next();
        if (!this.proceed(dto4LocaleList, dataSource)) {
            this.refreshMultiVersionKeyCacheItem(dto4LocaleList, cacheItem, msgSourceQueueIter);
        } else {
            long timestampOld = cacheItem.getTimestamp();
            String localeOrig = this.dto.getLocale();
            if (dataSource.equals((Object)DataSourceEnum.VIP) && this.dto.getLocale().equals("source")) {
                this.dto.setLocale("latest");
            }
            dataSource.createKeyBasedOpt(this.dto).fetchMultiVersionKeyMessages(cacheItem);
            long timestamp = cacheItem.getTimestamp();
            if (timestampOld == timestamp) {
                this.logger.debug(FormatUtils.format("Failed to get messages for versions {0}, component {1}, locale: {2}, key {3}, data source: {4}.", this.dto.getVersion(), this.dto.getComponent(), this.dto.getLocale(), this.dto.getKey(), dataSource.toString()));
            }
            this.dto.setLocale(localeOrig);
            if (timestamp == 0L) {
                this.refreshMultiVersionKeyCacheItem(dto4LocaleList, cacheItem, msgSourceQueueIter);
            }
        }
    }

    private void refreshMultiVersionKeyCacheItemTask(MessagesDTO dto4LocaleList, MessageCacheItem cacheItem) {
        Runnable runnable = () -> {
            try {
                this.refreshMultiVersionKeyCacheItem(dto4LocaleList, cacheItem, VIPCfg.getInstance().getMsgOriginsQueue().listIterator());
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        new Thread(runnable).start();
    }
}

