package com.vmware.vcloud.rest.openapi.api;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import com.vmware.vcloud.rest.openapi.model.EntityReference;
import java.util.List;
import com.vmware.vcloud.rest.openapi.model.QueryResults;
import com.vmware.vcloud.rest.openapi.model.Service;
import com.vmware.vcloud.rest.openapi.model.ServiceItem;
import com.vmware.vcloud.rest.openapi.model.VroRemoteWorkflowItem;
import com.vmware.vcloud.rest.openapi.model.VroWorkflowServiceItem;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.*;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.ext.multipart.*;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ApiResponse;
import io.swagger.jaxrs.PATCH;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/")
@Api(value = "/", description = "")
public interface ServicesApi  {

    @POST
    @Path("/serviceItem")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "Adds service item", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = ServiceItem.class, responseContainer = "List") })
    public List<ServiceItem> addServiceItems(@Valid List<ServiceItem> newServiceItems);

    @POST
    @Path("/serviceLibrary")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "Creates a new service", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 201, message = "Created", response = Service.class) })
    public Service createService(@Valid Service newService);

    @DELETE
    @Path("/serviceLibrary/{id}")
    @ApiOperation(value = "Delete specified service", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "No Content") })
    public void deleteService(@PathParam("id") String id);

    @DELETE
    @Path("/serviceItem/{id}")
    @ApiOperation(value = "Deletes specified service item", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "No Content") })
    public void deleteServiceItem(@PathParam("id") String id);

    @GET
    @Path("/serviceLibrary/{id}")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get specified service", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = Service.class),
        @ApiResponse(code = 404, message = "Not Found") })
    public Service getService(@PathParam("id") String id);

    @GET
    @Path("/serviceItem/{id}")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get the specified item", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = ServiceItem.class),
        @ApiResponse(code = 404, message = "Not Found") })
    public ServiceItem getServiceItem(@PathParam("id") String id);

    @GET
    @Path("/serviceItem/{id}/tenants")
    @Produces({ "application/json" })
    @ApiOperation(value = "Retrieves list of tenants for whom the service item is explicitly published", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = EntityReference.class, responseContainer = "List") })
    public List<EntityReference> getServiceItemTenants(@PathParam("id") String id);

    @GET
    @Path("/serviceLibrary/{id}/workflows")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get all workflow items in this service", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = VroWorkflowServiceItem.class, responseContainer = "List") })
    public List<VroWorkflowServiceItem> getWorkflowServiceItems(@PathParam("id") String id);

    @POST
    @Path("/serviceLibrary/{id}/workflows")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "Add VRO remote workflows to this service", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = ServiceItem.class, responseContainer = "List"),
        @ApiResponse(code = 404, message = "Not Found") })
    public List<ServiceItem> importVroWorkflows(@Valid List<VroRemoteWorkflowItem> remoteWorkflows, @PathParam("id") String id);

    @POST
    @Path("/serviceItem/{id}/tenants/publish")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "Publishes the service item to the specified tenants", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = EntityReference.class, responseContainer = "List") })
    public List<EntityReference> postServiceItemPublish(@Valid List<EntityReference> publishTenantsBody, @PathParam("id") String id);

    @POST
    @Path("/serviceItem/{id}/tenants/publishAll")
    @Produces({ "application/json" })
    @ApiOperation(value = "Publishes the service item to all tenants", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = EntityReference.class, responseContainer = "List") })
    public List<EntityReference> postServiceItemPublishAll(@PathParam("id") String id);

    @POST
    @Path("/serviceItem/{id}/tenants/unpublish")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "Revokes publication of the service item to the specified tenants", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = EntityReference.class, responseContainer = "List") })
    public List<EntityReference> postServiceItemUnpublish(@Valid List<EntityReference> unpublishTenantsBody, @PathParam("id") String id);

    @POST
    @Path("/serviceItem/{id}/tenants/unpublishAll")
    @Produces({ "application/json" })
    @ApiOperation(value = "Unpublishes the service item from all tenants", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = EntityReference.class, responseContainer = "List") })
    public List<EntityReference> postServiceItemUnpublishAll(@PathParam("id") String id);

    @GET
    @Path("/serviceItem")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get all items across all services", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = QueryResults.class) })
    public QueryResults queryServiceItems(@QueryParam("page") @NotNull @DefaultValue("1") Integer page, @QueryParam("pageSize") @NotNull @DefaultValue("10") Integer pageSize, @QueryParam("filter") @DefaultValue("") String filter, @QueryParam("sortAsc") @DefaultValue("") String sortAsc, @QueryParam("sortDesc") @DefaultValue("") String sortDesc);

    @GET
    @Path("/serviceLibrary")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get list of services", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = QueryResults.class) })
    public QueryResults queryServices(@QueryParam("page") @NotNull @DefaultValue("1") Integer page, @QueryParam("pageSize") @NotNull @DefaultValue("10") Integer pageSize, @QueryParam("filter") @DefaultValue("") String filter, @QueryParam("sortAsc") @DefaultValue("") String sortAsc, @QueryParam("sortDesc") @DefaultValue("") String sortDesc);

    @PUT
    @Path("/serviceLibrary/{id}")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "Update specified service", tags={ "services",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = Service.class) })
    public Service updateService(@Valid Service updatedService, @PathParam("id") String id);

    @PUT
    @Path("/serviceItem/{id}")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "Update specified service item", tags={ "services" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = ServiceItem.class) })
    public ServiceItem updateServiceItem(@Valid ServiceItem updatedService, @PathParam("id") String id);
}

