package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.vmware.vcloud.rest.openapi.model.ArrayParam;
import com.vmware.vcloud.rest.openapi.model.BooleanParam;
import com.vmware.vcloud.rest.openapi.model.CompositeType;
import com.vmware.vcloud.rest.openapi.model.CompositeValue;
import com.vmware.vcloud.rest.openapi.model.DateParam;
import com.vmware.vcloud.rest.openapi.model.EncryptedString;
import com.vmware.vcloud.rest.openapi.model.KeyValuePair;
import com.vmware.vcloud.rest.openapi.model.MimeAttachment;
import com.vmware.vcloud.rest.openapi.model.NumberParam;
import com.vmware.vcloud.rest.openapi.model.Properties;
import com.vmware.vcloud.rest.openapi.model.Regex;
import com.vmware.vcloud.rest.openapi.model.SdkObject;
import com.vmware.vcloud.rest.openapi.model.SecureString;
import com.vmware.vcloud.rest.openapi.model.StringParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * ParameterTypes
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-11T04:46:40.806Z")

public class ParameterTypes   {
  @JsonProperty("sdkObject")
  private SdkObject sdkObject = null;

  @JsonProperty("string")
  private StringParam string = null;

  @JsonProperty("secureString")
  private SecureString secureString = null;

  @JsonProperty("number")
  private NumberParam number = null;

  @JsonProperty("mimeAttachment")
  private MimeAttachment mimeAttachment = null;

  @JsonProperty("properties")
  private Properties properties = null;

  @JsonProperty("date")
  private DateParam date = null;

  @JsonProperty("boolean")
  private BooleanParam _boolean = null;

  @JsonProperty("composite")
  private CompositeType composite = null;

  @JsonProperty("regex")
  private Regex regex = null;

  @JsonProperty("encryptedString")
  private EncryptedString encryptedString = null;

  @JsonProperty("keyValuePair")
  private KeyValuePair keyValuePair = null;

  @JsonProperty("compositeValue")
  private CompositeValue compositeValue = null;

  @JsonProperty("array")
  private ArrayParam array = null;

  public ParameterTypes sdkObject(SdkObject sdkObject) {
    this.sdkObject = sdkObject;
    return this;
  }

   /**
   * Get sdkObject
   * @return sdkObject
  **/
  @ApiModelProperty(value = "")

  @Valid

  public SdkObject getSdkObject() {
    return sdkObject;
  }

  public void setSdkObject(SdkObject sdkObject) {
    this.sdkObject = sdkObject;
  }

  public ParameterTypes string(StringParam string) {
    this.string = string;
    return this;
  }

   /**
   * Get string
   * @return string
  **/
  @ApiModelProperty(value = "")

  @Valid

  public StringParam getString() {
    return string;
  }

  public void setString(StringParam string) {
    this.string = string;
  }

  public ParameterTypes secureString(SecureString secureString) {
    this.secureString = secureString;
    return this;
  }

   /**
   * Get secureString
   * @return secureString
  **/
  @ApiModelProperty(value = "")

  @Valid

  public SecureString getSecureString() {
    return secureString;
  }

  public void setSecureString(SecureString secureString) {
    this.secureString = secureString;
  }

  public ParameterTypes number(NumberParam number) {
    this.number = number;
    return this;
  }

   /**
   * Get number
   * @return number
  **/
  @ApiModelProperty(value = "")

  @Valid

  public NumberParam getNumber() {
    return number;
  }

  public void setNumber(NumberParam number) {
    this.number = number;
  }

  public ParameterTypes mimeAttachment(MimeAttachment mimeAttachment) {
    this.mimeAttachment = mimeAttachment;
    return this;
  }

   /**
   * Get mimeAttachment
   * @return mimeAttachment
  **/
  @ApiModelProperty(value = "")

  @Valid

  public MimeAttachment getMimeAttachment() {
    return mimeAttachment;
  }

  public void setMimeAttachment(MimeAttachment mimeAttachment) {
    this.mimeAttachment = mimeAttachment;
  }

  public ParameterTypes properties(Properties properties) {
    this.properties = properties;
    return this;
  }

   /**
   * Get properties
   * @return properties
  **/
  @ApiModelProperty(value = "")

  @Valid

  public Properties getProperties() {
    return properties;
  }

  public void setProperties(Properties properties) {
    this.properties = properties;
  }

  public ParameterTypes date(DateParam date) {
    this.date = date;
    return this;
  }

   /**
   * Get date
   * @return date
  **/
  @ApiModelProperty(value = "")

  @Valid

  public DateParam getDate() {
    return date;
  }

  public void setDate(DateParam date) {
    this.date = date;
  }

  public ParameterTypes _boolean(BooleanParam _boolean) {
    this._boolean = _boolean;
    return this;
  }

   /**
   * Get _boolean
   * @return _boolean
  **/
  @ApiModelProperty(value = "")

  @Valid

  public BooleanParam getBoolean() {
    return _boolean;
  }

  public void setBoolean(BooleanParam _boolean) {
    this._boolean = _boolean;
  }

  public ParameterTypes composite(CompositeType composite) {
    this.composite = composite;
    return this;
  }

   /**
   * Get composite
   * @return composite
  **/
  @ApiModelProperty(value = "")

  @Valid

  public CompositeType getComposite() {
    return composite;
  }

  public void setComposite(CompositeType composite) {
    this.composite = composite;
  }

  public ParameterTypes regex(Regex regex) {
    this.regex = regex;
    return this;
  }

   /**
   * Get regex
   * @return regex
  **/
  @ApiModelProperty(value = "")

  @Valid

  public Regex getRegex() {
    return regex;
  }

  public void setRegex(Regex regex) {
    this.regex = regex;
  }

  public ParameterTypes encryptedString(EncryptedString encryptedString) {
    this.encryptedString = encryptedString;
    return this;
  }

   /**
   * Get encryptedString
   * @return encryptedString
  **/
  @ApiModelProperty(value = "")

  @Valid

  public EncryptedString getEncryptedString() {
    return encryptedString;
  }

  public void setEncryptedString(EncryptedString encryptedString) {
    this.encryptedString = encryptedString;
  }

  public ParameterTypes keyValuePair(KeyValuePair keyValuePair) {
    this.keyValuePair = keyValuePair;
    return this;
  }

   /**
   * Get keyValuePair
   * @return keyValuePair
  **/
  @ApiModelProperty(value = "")

  @Valid

  public KeyValuePair getKeyValuePair() {
    return keyValuePair;
  }

  public void setKeyValuePair(KeyValuePair keyValuePair) {
    this.keyValuePair = keyValuePair;
  }

  public ParameterTypes compositeValue(CompositeValue compositeValue) {
    this.compositeValue = compositeValue;
    return this;
  }

   /**
   * Get compositeValue
   * @return compositeValue
  **/
  @ApiModelProperty(value = "")

  @Valid

  public CompositeValue getCompositeValue() {
    return compositeValue;
  }

  public void setCompositeValue(CompositeValue compositeValue) {
    this.compositeValue = compositeValue;
  }

  public ParameterTypes array(ArrayParam array) {
    this.array = array;
    return this;
  }

   /**
   * Get array
   * @return array
  **/
  @ApiModelProperty(value = "")

  @Valid

  public ArrayParam getArray() {
    return array;
  }

  public void setArray(ArrayParam array) {
    this.array = array;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ParameterTypes parameterTypes = (ParameterTypes) o;
    return Objects.equals(this.sdkObject, parameterTypes.sdkObject) &&
        Objects.equals(this.string, parameterTypes.string) &&
        Objects.equals(this.secureString, parameterTypes.secureString) &&
        Objects.equals(this.number, parameterTypes.number) &&
        Objects.equals(this.mimeAttachment, parameterTypes.mimeAttachment) &&
        Objects.equals(this.properties, parameterTypes.properties) &&
        Objects.equals(this.date, parameterTypes.date) &&
        Objects.equals(this._boolean, parameterTypes._boolean) &&
        Objects.equals(this.composite, parameterTypes.composite) &&
        Objects.equals(this.regex, parameterTypes.regex) &&
        Objects.equals(this.encryptedString, parameterTypes.encryptedString) &&
        Objects.equals(this.keyValuePair, parameterTypes.keyValuePair) &&
        Objects.equals(this.compositeValue, parameterTypes.compositeValue) &&
        Objects.equals(this.array, parameterTypes.array);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sdkObject, string, secureString, number, mimeAttachment, properties, date, _boolean, composite, regex, encryptedString, keyValuePair, compositeValue, array);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ParameterTypes {\n");
    
    sb.append("    sdkObject: ").append(toIndentedString(sdkObject)).append("\n");
    sb.append("    string: ").append(toIndentedString(string)).append("\n");
    sb.append("    secureString: ").append(toIndentedString(secureString)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    mimeAttachment: ").append(toIndentedString(mimeAttachment)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    _boolean: ").append(toIndentedString(_boolean)).append("\n");
    sb.append("    composite: ").append(toIndentedString(composite)).append("\n");
    sb.append("    regex: ").append(toIndentedString(regex)).append("\n");
    sb.append("    encryptedString: ").append(toIndentedString(encryptedString)).append("\n");
    sb.append("    keyValuePair: ").append(toIndentedString(keyValuePair)).append("\n");
    sb.append("    compositeValue: ").append(toIndentedString(compositeValue)).append("\n");
    sb.append("    array: ").append(toIndentedString(array)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

