package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.vmware.vcloud.rest.openapi.model.StepInfo;
import com.vmware.vcloud.rest.openapi.model.WsParameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Presentation
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-11T04:46:40.806Z")

public class Presentation   {
  @JsonProperty("description")
  private String description = null;

  @JsonProperty("id")
  private String id = null;

  @JsonProperty("inputParameters")
  private List<WsParameter> inputParameters = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("outputParameters")
  private List<WsParameter> outputParameters = null;

  @JsonProperty("steps")
  private List<StepInfo> steps = null;

  public Presentation description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @ApiModelProperty(value = "")


  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Presentation id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Presentation inputParameters(List<WsParameter> inputParameters) {
    this.inputParameters = inputParameters;
    return this;
  }

  public Presentation addInputParametersItem(WsParameter inputParametersItem) {
    if (this.inputParameters == null) {
      this.inputParameters = new ArrayList<WsParameter>();
    }
    this.inputParameters.add(inputParametersItem);
    return this;
  }

   /**
   * Get inputParameters
   * @return inputParameters
  **/
  @ApiModelProperty(value = "")

  @Valid

  public List<WsParameter> getInputParameters() {
    return inputParameters;
  }

  public void setInputParameters(List<WsParameter> inputParameters) {
    this.inputParameters = inputParameters;
  }

  public Presentation name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(value = "")


  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Presentation outputParameters(List<WsParameter> outputParameters) {
    this.outputParameters = outputParameters;
    return this;
  }

  public Presentation addOutputParametersItem(WsParameter outputParametersItem) {
    if (this.outputParameters == null) {
      this.outputParameters = new ArrayList<WsParameter>();
    }
    this.outputParameters.add(outputParametersItem);
    return this;
  }

   /**
   * Get outputParameters
   * @return outputParameters
  **/
  @ApiModelProperty(value = "")

  @Valid

  public List<WsParameter> getOutputParameters() {
    return outputParameters;
  }

  public void setOutputParameters(List<WsParameter> outputParameters) {
    this.outputParameters = outputParameters;
  }

  public Presentation steps(List<StepInfo> steps) {
    this.steps = steps;
    return this;
  }

  public Presentation addStepsItem(StepInfo stepsItem) {
    if (this.steps == null) {
      this.steps = new ArrayList<StepInfo>();
    }
    this.steps.add(stepsItem);
    return this;
  }

   /**
   * Get steps
   * @return steps
  **/
  @ApiModelProperty(value = "")

  @Valid

  public List<StepInfo> getSteps() {
    return steps;
  }

  public void setSteps(List<StepInfo> steps) {
    this.steps = steps;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Presentation presentation = (Presentation) o;
    return Objects.equals(this.description, presentation.description) &&
        Objects.equals(this.id, presentation.id) &&
        Objects.equals(this.inputParameters, presentation.inputParameters) &&
        Objects.equals(this.name, presentation.name) &&
        Objects.equals(this.outputParameters, presentation.outputParameters) &&
        Objects.equals(this.steps, presentation.steps);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, id, inputParameters, name, outputParameters, steps);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Presentation {\n");
    
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    inputParameters: ").append(toIndentedString(inputParameters)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    outputParameters: ").append(toIndentedString(outputParameters)).append("\n");
    sb.append("    steps: ").append(toIndentedString(steps)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

