package com.vmware.vcloud.rest.openapi.api;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import com.vmware.vcloud.rest.openapi.model.UiBranding;
import com.vmware.vcloud.rest.openapi.model.UiTheme;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.*;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.ext.multipart.*;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ApiResponse;
import io.swagger.jaxrs.PATCH;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/")
@Api(value = "/", description = "")
public interface BrandingApi  {

    @DELETE
    @Path("/branding/logo")
    @ApiOperation(value = "Delete system level logo", tags={ "branding",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "No Content") })
    public void deleteSystemLogo();

    @GET
    @Path("/branding/themes")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get a list of themes", tags={ "branding",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = UiTheme.class, responseContainer = "List") })
    public List<UiTheme> getBrandingThemes();

    @GET
    @Path("/branding")
    @Produces({ "application/json" })
    @ApiOperation(value = "Gets the system level branding", tags={ "branding",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = UiBranding.class) })
    public UiBranding getSystemBranding();

    @GET
    @Path("/branding/logo")
    @Produces({ "image/png", "image/jpeg", "image/svg+xml" })
    @ApiOperation(value = "Gets the system level logo", tags={ "branding",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = byte[].class) })
    public byte[] getSystemLogo();

    @PUT
    @Path("/branding")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "Sets the system level branding", tags={ "branding",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = UiBranding.class) })
    public UiBranding putSystemBranding(@Valid UiBranding body);

    @PUT
    @Path("/branding/logo")
    @Consumes({ "image/png", "image/jpeg", "image/svg+xml" })
    @ApiOperation(value = "Sets the system level logo", tags={ "branding" })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "No Content"),
        @ApiResponse(code = 415, message = "Unsupported Media Type") })
    public void putSystemLogo(@HeaderParam("Content-Type") String contentType, @Valid byte[] body);
}

