package com.vmware.vcloud.rest.openapi.api;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import com.vmware.vcloud.rest.openapi.model.CreateCustomEntityTypeAction;
import com.vmware.vcloud.rest.openapi.model.CustomEntity;
import com.vmware.vcloud.rest.openapi.model.CustomEntityType;
import com.vmware.vcloud.rest.openapi.model.CustomEntityTypeAction;
import com.vmware.vcloud.rest.openapi.model.CustomEntityTypeActions;
import com.vmware.vcloud.rest.openapi.model.Error;
import com.vmware.vcloud.rest.openapi.model.QueryResults;
import com.vmware.vcloud.rest.openapi.model.SdkObject;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.*;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.ext.multipart.*;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ApiResponse;
import io.swagger.jaxrs.PATCH;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/")
@Api(value = "/", description = "")
public interface CustomEntitiesApi  {

    @POST
    @Path("/customEntityTypes")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "Creates a new custom entity type", tags={ "customEntities",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 201, message = "Created", response = CustomEntityType.class) })
    public CustomEntityType createCustomEntityType(@Valid CustomEntityType newCustomEntityType);

    @POST
    @Path("/customEntityTypes/{customEntityTypeId}/actions")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "Creates a new custom entity type action.", tags={ "customEntities",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 201, message = "Created", response = CustomEntityTypeAction.class),
        @ApiResponse(code = 400, message = "The request is invalid(validation error)", response = Error.class),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "Forbidden"),
        @ApiResponse(code = 404, message = "Not found", response = Error.class) })
    public CustomEntityTypeAction createCustomEntityTypeAction(@Valid CreateCustomEntityTypeAction newCustomEntityTypeAction, @PathParam("customEntityTypeId") String customEntityTypeId);

    @DELETE
    @Path("/customEntityTypes/{customEntityTypeId}")
    @ApiOperation(value = "Delete specified custom entity type.", tags={ "customEntities",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "No Content") })
    public void deleteCustomEntityType(@QueryParam("recursive") @NotNull Boolean recursive, @PathParam("customEntityTypeId") String customEntityTypeId);

    @DELETE
    @Path("/customEntityTypes/{customEntityTypeId}/actions/{workflowId}")
    @ApiOperation(value = "Delete specified custom entity type action", tags={ "customEntities",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "No Content"),
        @ApiResponse(code = 404, message = "Not found", response = Error.class) })
    public void deleteCustomEntityTypeAction(@PathParam("customEntityTypeId") String customEntityTypeId, @PathParam("workflowId") String workflowId);

    @GET
    @Path("/customEntities/{customEntityId}")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get specified custom entity", tags={ "customEntities",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = CustomEntity.class),
        @ApiResponse(code = 404, message = "Not Found") })
    public CustomEntity getCustomEntity(@PathParam("customEntityId") String customEntityId);

    @GET
    @Path("/customEntities/{customEntityId}/sdkObject")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get specified custom entity represented as on Sdk-Object", tags={ "customEntities",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = SdkObject.class),
        @ApiResponse(code = 404, message = "Not Found") })
    public SdkObject getCustomEntityAsSdkObject(@PathParam("customEntityId") String customEntityId);

    @GET
    @Path("/customEntityTypes/{customEntityTypeId}")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get specified custom entity type", tags={ "customEntities",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = CustomEntityType.class),
        @ApiResponse(code = 404, message = "Not Found") })
    public CustomEntityType getCustomEntityType(@PathParam("customEntityTypeId") String customEntityTypeId);

    @GET
    @Path("/customEntityTypes/{customEntityTypeId}/actions")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get all actions associated with this custom entity type", tags={ "customEntities",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = CustomEntityTypeActions.class),
        @ApiResponse(code = 404, message = "Not Found"),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "The user does not have 'read' access rights for custom entity types") })
    public CustomEntityTypeActions getCustomEntityTypeActions(@PathParam("customEntityTypeId") String customEntityTypeId);

    @GET
    @Path("/customEntities")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get list of all custom entities", tags={ "customEntities",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = QueryResults.class) })
    public QueryResults queryCustomEntities(@QueryParam("page") @NotNull @DefaultValue("1") Integer page, @QueryParam("pageSize") @NotNull @DefaultValue("10") Integer pageSize, @QueryParam("filter") @DefaultValue("") String filter, @QueryParam("sortAsc") @DefaultValue("") String sortAsc, @QueryParam("sortDesc") @DefaultValue("") String sortDesc);

    @GET
    @Path("/customEntityTypes")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get list of all custom entity types", tags={ "customEntities",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = QueryResults.class) })
    public QueryResults queryCustomEntityTypes(@QueryParam("page") @NotNull @DefaultValue("1") Integer page, @QueryParam("pageSize") @NotNull @DefaultValue("10") Integer pageSize, @QueryParam("filter") @DefaultValue("") String filter, @QueryParam("sortAsc") @DefaultValue("") String sortAsc, @QueryParam("sortDesc") @DefaultValue("") String sortDesc);

    @PUT
    @Path("/customEntityTypes/{customEntityTypeId}")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "Update specified custom entity type", tags={ "customEntities" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = CustomEntityType.class) })
    public CustomEntityType updateCustomEntityType(@Valid CustomEntityType updatedCustomEntityType, @PathParam("customEntityTypeId") String customEntityTypeId);
}

