package com.vmware.vcloud.rest.openapi.api;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import com.vmware.vcloud.rest.openapi.model.Relations;
import com.vmware.vcloud.rest.openapi.model.VroRemoteInventoryItem;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.*;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.ext.multipart.*;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ApiResponse;
import io.swagger.jaxrs.PATCH;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/")
@Api(value = "/", description = "")
public interface VrealizeBrowseApi  {

    @GET
    @Path("/vro/servers/{vroId}/catalog")
    @Produces({ "application/json" })
    @ApiOperation(value = "Browse remote vRealize Orchestrator inventory", tags={ "vrealizeBrowse",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = VroRemoteInventoryItem.class),
        @ApiResponse(code = 404, message = "Not Found") })
    public VroRemoteInventoryItem getRemoteCatalog(@QueryParam("page") @NotNull @DefaultValue("1") Integer page, @QueryParam("pageSize") @NotNull @DefaultValue("10") Integer pageSize, @PathParam("vroId") String vroId, @QueryParam("filter") @DefaultValue("") String filter, @QueryParam("sortAsc") @DefaultValue("") String sortAsc, @QueryParam("sortDesc") @DefaultValue("") String sortDesc);

    @GET
    @Path("/vro/servers/{vroId}/catalog/{plugin}")
    @Produces({ "application/json" })
    @ApiOperation(value = "Browse remote vRealize Orchestrator inventory", tags={ "vrealizeBrowse",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = VroRemoteInventoryItem.class),
        @ApiResponse(code = 404, message = "Not Found") })
    public VroRemoteInventoryItem getRemoteCatalogPlugin(@QueryParam("page") @NotNull @DefaultValue("1") Integer page, @QueryParam("pageSize") @NotNull @DefaultValue("10") Integer pageSize, @PathParam("vroId") String vroId, @PathParam("plugin") String plugin, @QueryParam("filter") @DefaultValue("") String filter, @QueryParam("sortAsc") @DefaultValue("") String sortAsc, @QueryParam("sortDesc") @DefaultValue("") String sortDesc);

    @GET
    @Path("/vro/servers/{vroId}/catalog/{plugin}/{type}")
    @Produces({ "application/json" })
    @ApiOperation(value = "Browse remote vRealize Orchestrator inventory", tags={ "vrealizeBrowse",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = Relations.class),
        @ApiResponse(code = 404, message = "Not Found") })
    public Relations getRemoteCatalogPluginType(@QueryParam("page") @NotNull @DefaultValue("1") Integer page, @QueryParam("pageSize") @NotNull @DefaultValue("10") Integer pageSize, @PathParam("vroId") String vroId, @PathParam("plugin") String plugin, @PathParam("type") String type, @QueryParam("filter") @DefaultValue("") String filter, @QueryParam("sortAsc") @DefaultValue("") String sortAsc, @QueryParam("sortDesc") @DefaultValue("") String sortDesc);

    @GET
    @Path("/vro/servers/{vroId}/catalog/{plugin}/{type}/{itemId}")
    @Produces({ "application/json" })
    @ApiOperation(value = "Browse remote vRealize Orchestrator inventory", tags={ "vrealizeBrowse",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = VroRemoteInventoryItem.class),
        @ApiResponse(code = 404, message = "Not Found") })
    public VroRemoteInventoryItem getRemoteCatalogPluginTypeItem(@QueryParam("page") @NotNull @DefaultValue("1") Integer page, @QueryParam("pageSize") @NotNull @DefaultValue("10") Integer pageSize, @PathParam("vroId") String vroId, @PathParam("plugin") String plugin, @PathParam("type") String type, @PathParam("itemId") String itemId, @QueryParam("filter") @DefaultValue("") String filter, @QueryParam("sortAsc") @DefaultValue("") String sortAsc, @QueryParam("sortDesc") @DefaultValue("") String sortDesc);

    @GET
    @Path("/vro/servers/{vroId}/inventory{any:.*}")
    @Produces({ "application/json" })
    @ApiOperation(value = "Browse remote vRealize Orchestrator inventory", tags={ "vrealizeBrowse" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = VroRemoteInventoryItem.class),
        @ApiResponse(code = 404, message = "Not Found") })
    public VroRemoteInventoryItem getRemoteInventory(@PathParam("vroId") String vroId, @PathParam("any") String any);
}

