package com.vmware.vcloud.rest.openapi.api;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import com.vmware.vcloud.rest.openapi.model.ExecutionContext;
import com.vmware.vcloud.rest.openapi.model.Presentation;
import com.vmware.vcloud.rest.openapi.model.PresentationExecution;
import com.vmware.vcloud.rest.openapi.model.PresentationExecutionsList;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.*;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.ext.multipart.*;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ApiResponse;
import io.swagger.jaxrs.PATCH;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/")
@Api(value = "/", description = "")
public interface VroWorkflowPresentationApi  {

    @DELETE
    @Path("/workflows/{workflowId}/presentation/instances/{presentationExecutionId}")
    @ApiOperation(value = "Delete workflow presentation execution", tags={ "vroWorkflowPresentation",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "No content"),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "Forbidden"),
        @ApiResponse(code = 404, message = "Cannot find a workflow or presentation instance with specified ID") })
    public void deleteWorkflowPresenationInstance(@PathParam("workflowId") String workflowId, @PathParam("presentationExecutionId") String presentationExecutionId);

    @GET
    @Path("/workflows/{workflowId}/presentation/instances")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get all presentations", tags={ "vroWorkflowPresentation",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The request is successful", response = PresentationExecutionsList.class),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "Forbidden"),
        @ApiResponse(code = 404, message = "Cannot find a workflow with the specified ID or the user does not have 'read' access rights for that workflow") })
    public PresentationExecutionsList getAllWorkflowPresentationInstances(@PathParam("workflowId") String workflowId);

    @GET
    @Path("/workflows/{workflowId}/presentation")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get presentation", tags={ "vroWorkflowPresentation",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The request is successful", response = Presentation.class),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "Forbidden"),
        @ApiResponse(code = 404, message = "Cannot find a workflow with the specified ID or the user does not have 'read' access rights for that workflow") })
    public Presentation getWorkflowPresentation(@PathParam("workflowId") String workflowId);

    @GET
    @Path("/workflows/{workflowId}/presentation/instances/{presentationExecutionId}")
    @Produces({ "application/json" })
    @ApiOperation(value = "Load Execution", tags={ "vroWorkflowPresentation",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The request is successful", response = PresentationExecution.class),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "The user does not have 'read' access rights for that workflow"),
        @ApiResponse(code = 404, message = "Cannot find a workflow with the specified ID") })
    public PresentationExecution getWorkflowPresentationInstance(@PathParam("workflowId") String workflowId, @PathParam("presentationExecutionId") String presentationExecutionId);

    @POST
    @Path("/workflows/{workflowId}/presentation/instances")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "Start presentation", tags={ "vroWorkflowPresentation",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The request is successful", response = PresentationExecution.class),
        @ApiResponse(code = 201, message = "Created"),
        @ApiResponse(code = 400, message = "The request is invalid(validation error)"),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "Forbidden"),
        @ApiResponse(code = 404, message = "Cannot find a workflow with the specified ID or the user does not have 'read' access rights for that workflow") })
    public PresentationExecution startWorkflowPresentation(@PathParam("workflowId") String workflowId, @Valid ExecutionContext executionContext);

    @PUT
    @Path("/workflows/{workflowId}/presentation/instances/{presentationExecutionId}")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "Update presentation", tags={ "vroWorkflowPresentation" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The request is successful", response = PresentationExecution.class),
        @ApiResponse(code = 400, message = "The request is invalid(validation error)"),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "The user does not have 'read' access rights for that workflow"),
        @ApiResponse(code = 404, message = "Cannot find a workflow or presentation instance with specified ID") })
    public PresentationExecution updateWorkflowPresentationInstance(@PathParam("workflowId") String workflowId, @PathParam("presentationExecutionId") String presentationExecutionId, @Valid ExecutionContext executionContext);
}

