package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.vmware.vcloud.rest.openapi.model.Constraint;
import com.vmware.vcloud.rest.openapi.model.CustomValidator;
import com.vmware.vcloud.rest.openapi.model.Mandatory;
import com.vmware.vcloud.rest.openapi.model.NumberFormat;
import com.vmware.vcloud.rest.openapi.model.NumberRange;
import com.vmware.vcloud.rest.openapi.model.Regexp;
import com.vmware.vcloud.rest.openapi.model.RestrictDuplicates;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * SupportedConstraints
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-18T01:56:01.184Z")

public class SupportedConstraints   {
  @JsonProperty("constraint")
  private Constraint constraint = null;

  @JsonProperty("mandatory")
  private Mandatory mandatory = null;

  @JsonProperty("restrictDuplicates")
  private RestrictDuplicates restrictDuplicates = null;

  @JsonProperty("customValidator")
  private CustomValidator customValidator = null;

  @JsonProperty("numberRange")
  private NumberRange numberRange = null;

  @JsonProperty("regexp")
  private Regexp regexp = null;

  @JsonProperty("numberFormat")
  private NumberFormat numberFormat = null;

  public SupportedConstraints constraint(Constraint constraint) {
    this.constraint = constraint;
    return this;
  }

   /**
   * Get constraint
   * @return constraint
  **/
  @ApiModelProperty(value = "")

  @Valid

  public Constraint getConstraint() {
    return constraint;
  }

  public void setConstraint(Constraint constraint) {
    this.constraint = constraint;
  }

  public SupportedConstraints mandatory(Mandatory mandatory) {
    this.mandatory = mandatory;
    return this;
  }

   /**
   * Get mandatory
   * @return mandatory
  **/
  @ApiModelProperty(value = "")

  @Valid

  public Mandatory getMandatory() {
    return mandatory;
  }

  public void setMandatory(Mandatory mandatory) {
    this.mandatory = mandatory;
  }

  public SupportedConstraints restrictDuplicates(RestrictDuplicates restrictDuplicates) {
    this.restrictDuplicates = restrictDuplicates;
    return this;
  }

   /**
   * Get restrictDuplicates
   * @return restrictDuplicates
  **/
  @ApiModelProperty(value = "")

  @Valid

  public RestrictDuplicates getRestrictDuplicates() {
    return restrictDuplicates;
  }

  public void setRestrictDuplicates(RestrictDuplicates restrictDuplicates) {
    this.restrictDuplicates = restrictDuplicates;
  }

  public SupportedConstraints customValidator(CustomValidator customValidator) {
    this.customValidator = customValidator;
    return this;
  }

   /**
   * Get customValidator
   * @return customValidator
  **/
  @ApiModelProperty(value = "")

  @Valid

  public CustomValidator getCustomValidator() {
    return customValidator;
  }

  public void setCustomValidator(CustomValidator customValidator) {
    this.customValidator = customValidator;
  }

  public SupportedConstraints numberRange(NumberRange numberRange) {
    this.numberRange = numberRange;
    return this;
  }

   /**
   * Get numberRange
   * @return numberRange
  **/
  @ApiModelProperty(value = "")

  @Valid

  public NumberRange getNumberRange() {
    return numberRange;
  }

  public void setNumberRange(NumberRange numberRange) {
    this.numberRange = numberRange;
  }

  public SupportedConstraints regexp(Regexp regexp) {
    this.regexp = regexp;
    return this;
  }

   /**
   * Get regexp
   * @return regexp
  **/
  @ApiModelProperty(value = "")

  @Valid

  public Regexp getRegexp() {
    return regexp;
  }

  public void setRegexp(Regexp regexp) {
    this.regexp = regexp;
  }

  public SupportedConstraints numberFormat(NumberFormat numberFormat) {
    this.numberFormat = numberFormat;
    return this;
  }

   /**
   * Get numberFormat
   * @return numberFormat
  **/
  @ApiModelProperty(value = "")

  @Valid

  public NumberFormat getNumberFormat() {
    return numberFormat;
  }

  public void setNumberFormat(NumberFormat numberFormat) {
    this.numberFormat = numberFormat;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SupportedConstraints supportedConstraints = (SupportedConstraints) o;
    return Objects.equals(this.constraint, supportedConstraints.constraint) &&
        Objects.equals(this.mandatory, supportedConstraints.mandatory) &&
        Objects.equals(this.restrictDuplicates, supportedConstraints.restrictDuplicates) &&
        Objects.equals(this.customValidator, supportedConstraints.customValidator) &&
        Objects.equals(this.numberRange, supportedConstraints.numberRange) &&
        Objects.equals(this.regexp, supportedConstraints.regexp) &&
        Objects.equals(this.numberFormat, supportedConstraints.numberFormat);
  }

  @Override
  public int hashCode() {
    return Objects.hash(constraint, mandatory, restrictDuplicates, customValidator, numberRange, regexp, numberFormat);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SupportedConstraints {\n");
    
    sb.append("    constraint: ").append(toIndentedString(constraint)).append("\n");
    sb.append("    mandatory: ").append(toIndentedString(mandatory)).append("\n");
    sb.append("    restrictDuplicates: ").append(toIndentedString(restrictDuplicates)).append("\n");
    sb.append("    customValidator: ").append(toIndentedString(customValidator)).append("\n");
    sb.append("    numberRange: ").append(toIndentedString(numberRange)).append("\n");
    sb.append("    regexp: ").append(toIndentedString(regexp)).append("\n");
    sb.append("    numberFormat: ").append(toIndentedString(numberFormat)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

