package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.vmware.vcloud.rest.openapi.model.Field;
import com.vmware.vcloud.rest.openapi.model.Group;
import com.vmware.vcloud.rest.openapi.model.PresentationElement;
import com.vmware.vcloud.rest.openapi.model.PrimaryField;
import com.vmware.vcloud.rest.openapi.model.StepInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * SupportedPresentationElements
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-18T01:56:01.184Z")

public class SupportedPresentationElements   {
  @JsonProperty("presentationElement")
  private PresentationElement presentationElement = null;

  @JsonProperty("stepInfo")
  private StepInfo stepInfo = null;

  @JsonProperty("group")
  private Group group = null;

  @JsonProperty("field")
  private Field field = null;

  @JsonProperty("primaryField")
  private PrimaryField primaryField = null;

  public SupportedPresentationElements presentationElement(PresentationElement presentationElement) {
    this.presentationElement = presentationElement;
    return this;
  }

   /**
   * Get presentationElement
   * @return presentationElement
  **/
  @ApiModelProperty(value = "")

  @Valid

  public PresentationElement getPresentationElement() {
    return presentationElement;
  }

  public void setPresentationElement(PresentationElement presentationElement) {
    this.presentationElement = presentationElement;
  }

  public SupportedPresentationElements stepInfo(StepInfo stepInfo) {
    this.stepInfo = stepInfo;
    return this;
  }

   /**
   * Get stepInfo
   * @return stepInfo
  **/
  @ApiModelProperty(value = "")

  @Valid

  public StepInfo getStepInfo() {
    return stepInfo;
  }

  public void setStepInfo(StepInfo stepInfo) {
    this.stepInfo = stepInfo;
  }

  public SupportedPresentationElements group(Group group) {
    this.group = group;
    return this;
  }

   /**
   * Get group
   * @return group
  **/
  @ApiModelProperty(value = "")

  @Valid

  public Group getGroup() {
    return group;
  }

  public void setGroup(Group group) {
    this.group = group;
  }

  public SupportedPresentationElements field(Field field) {
    this.field = field;
    return this;
  }

   /**
   * Get field
   * @return field
  **/
  @ApiModelProperty(value = "")

  @Valid

  public Field getField() {
    return field;
  }

  public void setField(Field field) {
    this.field = field;
  }

  public SupportedPresentationElements primaryField(PrimaryField primaryField) {
    this.primaryField = primaryField;
    return this;
  }

   /**
   * Get primaryField
   * @return primaryField
  **/
  @ApiModelProperty(value = "")

  @Valid

  public PrimaryField getPrimaryField() {
    return primaryField;
  }

  public void setPrimaryField(PrimaryField primaryField) {
    this.primaryField = primaryField;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SupportedPresentationElements supportedPresentationElements = (SupportedPresentationElements) o;
    return Objects.equals(this.presentationElement, supportedPresentationElements.presentationElement) &&
        Objects.equals(this.stepInfo, supportedPresentationElements.stepInfo) &&
        Objects.equals(this.group, supportedPresentationElements.group) &&
        Objects.equals(this.field, supportedPresentationElements.field) &&
        Objects.equals(this.primaryField, supportedPresentationElements.primaryField);
  }

  @Override
  public int hashCode() {
    return Objects.hash(presentationElement, stepInfo, group, field, primaryField);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SupportedPresentationElements {\n");
    
    sb.append("    presentationElement: ").append(toIndentedString(presentationElement)).append("\n");
    sb.append("    stepInfo: ").append(toIndentedString(stepInfo)).append("\n");
    sb.append("    group: ").append(toIndentedString(group)).append("\n");
    sb.append("    field: ").append(toIndentedString(field)).append("\n");
    sb.append("    primaryField: ").append(toIndentedString(primaryField)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

