package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Response type with meta information about a vRealize Orchestrator Service 
 */
@ApiModel(description = "Response type with meta information about a vRealize Orchestrator Service ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-18T01:56:01.184Z")

public class VROServiceInfo   {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("vroEndpoint")
  private String vroEndpoint = null;

  @JsonProperty("username")
  private String username = null;

  @JsonProperty("password")
  private String password = null;

  @JsonProperty("version")
  private String version = null;

  @JsonProperty("trustAnchor")
  private String trustAnchor = null;

  public VROServiceInfo id(String id) {
    this.id = id;
    return this;
  }

   /**
   * This is a read-only field in the client. Values set on this field will be ignored by the server. 
   * @return id
  **/
  @ApiModelProperty(value = "This is a read-only field in the client. Values set on this field will be ignored by the server. ")


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public VROServiceInfo name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(value = "")


  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public VROServiceInfo description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @ApiModelProperty(value = "")


  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public VROServiceInfo vroEndpoint(String vroEndpoint) {
    this.vroEndpoint = vroEndpoint;
    return this;
  }

   /**
   * Get vroEndpoint
   * @return vroEndpoint
  **/
  @ApiModelProperty(value = "")


  public String getVroEndpoint() {
    return vroEndpoint;
  }

  public void setVroEndpoint(String vroEndpoint) {
    this.vroEndpoint = vroEndpoint;
  }

  public VROServiceInfo username(String username) {
    this.username = username;
    return this;
  }

   /**
   * Get username
   * @return username
  **/
  @ApiModelProperty(value = "")


  public String getUsername() {
    return username;
  }

  public void setUsername(String username) {
    this.username = username;
  }

  public VROServiceInfo password(String password) {
    this.password = password;
    return this;
  }

   /**
   * The password is hidden using a Password Mask represented by a series of 6 asterisks (\"******\") in the response. The Password Mask is not an acceptable password during VRO Server registration. During an update, the Password Mask set for the 'password' field is interpreted as no change to the field and is ignored. 
   * @return password
  **/
  @ApiModelProperty(value = "The password is hidden using a Password Mask represented by a series of 6 asterisks (\"******\") in the response. The Password Mask is not an acceptable password during VRO Server registration. During an update, the Password Mask set for the 'password' field is interpreted as no change to the field and is ignored. ")


  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public VROServiceInfo version(String version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @ApiModelProperty(value = "")


  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public VROServiceInfo trustAnchor(String trustAnchor) {
    this.trustAnchor = trustAnchor;
    return this;
  }

   /**
   * SSL Certificate chain for the VRO endpoint 
   * @return trustAnchor
  **/
  @ApiModelProperty(value = "SSL Certificate chain for the VRO endpoint ")


  public String getTrustAnchor() {
    return trustAnchor;
  }

  public void setTrustAnchor(String trustAnchor) {
    this.trustAnchor = trustAnchor;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VROServiceInfo vrOServiceInfo = (VROServiceInfo) o;
    return Objects.equals(this.id, vrOServiceInfo.id) &&
        Objects.equals(this.name, vrOServiceInfo.name) &&
        Objects.equals(this.description, vrOServiceInfo.description) &&
        Objects.equals(this.vroEndpoint, vrOServiceInfo.vroEndpoint) &&
        Objects.equals(this.username, vrOServiceInfo.username) &&
        Objects.equals(this.password, vrOServiceInfo.password) &&
        Objects.equals(this.version, vrOServiceInfo.version) &&
        Objects.equals(this.trustAnchor, vrOServiceInfo.trustAnchor);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, description, vroEndpoint, username, password, version, trustAnchor);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VROServiceInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    vroEndpoint: ").append(toIndentedString(vroEndpoint)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    trustAnchor: ").append(toIndentedString(trustAnchor)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

