/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.rest.openapi.api;

import com.vmware.vcloud.rest.openapi.model.CreateCustomEntityTypeAction;
import com.vmware.vcloud.rest.openapi.model.CustomEntity;
import com.vmware.vcloud.rest.openapi.model.CustomEntityType;
import com.vmware.vcloud.rest.openapi.model.CustomEntityTypeAction;
import com.vmware.vcloud.rest.openapi.model.CustomEntityTypeActions;
import com.vmware.vcloud.rest.openapi.model.Error;
import com.vmware.vcloud.rest.openapi.model.QueryResults;
import com.vmware.vcloud.rest.openapi.model.SdkObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/")
@Api(value="/", description="")
public interface CustomEntitiesApi {
    @POST
    @Path(value="/customEntityTypes")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Creates a new custom entity type", tags={"customEntities"})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=CustomEntityType.class)})
    public CustomEntityType createCustomEntityType(@Valid CustomEntityType var1);

    @POST
    @Path(value="/customEntityTypes/{customEntityTypeId}/actions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Creates a new custom entity type action.", tags={"customEntities"})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=CustomEntityTypeAction.class), @ApiResponse(code=400, message="The request is invalid(validation error)", response=Error.class), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not found", response=Error.class)})
    public CustomEntityTypeAction createCustomEntityTypeAction(@Valid CreateCustomEntityTypeAction var1, @PathParam(value="customEntityTypeId") String var2);

    @DELETE
    @Path(value="/customEntityTypes/{customEntityTypeId}")
    @ApiOperation(value="Delete specified custom entity type.", tags={"customEntities"})
    @ApiResponses(value={@ApiResponse(code=204, message="No Content")})
    public void deleteCustomEntityType(@QueryParam(value="recursive") @NotNull Boolean var1, @PathParam(value="customEntityTypeId") String var2);

    @DELETE
    @Path(value="/customEntityTypes/{customEntityTypeId}/actions/{workflowId}")
    @ApiOperation(value="Delete specified custom entity type action", tags={"customEntities"})
    @ApiResponses(value={@ApiResponse(code=204, message="No Content"), @ApiResponse(code=404, message="Not found", response=Error.class)})
    public void deleteCustomEntityTypeAction(@PathParam(value="customEntityTypeId") String var1, @PathParam(value="workflowId") String var2);

    @GET
    @Path(value="/customEntities/{customEntityId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get specified custom entity", tags={"customEntities"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CustomEntity.class), @ApiResponse(code=404, message="Not Found")})
    public CustomEntity getCustomEntity(@PathParam(value="customEntityId") String var1);

    @GET
    @Path(value="/customEntities/{customEntityId}/sdkObject")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get specified custom entity represented as on Sdk-Object", tags={"customEntities"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=SdkObject.class), @ApiResponse(code=404, message="Not Found")})
    public SdkObject getCustomEntityAsSdkObject(@PathParam(value="customEntityId") String var1);

    @GET
    @Path(value="/customEntityTypes/{customEntityTypeId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get specified custom entity type", tags={"customEntities"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CustomEntityType.class), @ApiResponse(code=404, message="Not Found")})
    public CustomEntityType getCustomEntityType(@PathParam(value="customEntityTypeId") String var1);

    @GET
    @Path(value="/customEntityTypes/{customEntityTypeId}/actions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all actions associated with this custom entity type", tags={"customEntities"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CustomEntityTypeActions.class), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="The user does not have 'read' access rights for custom entity types")})
    public CustomEntityTypeActions getCustomEntityTypeActions(@PathParam(value="customEntityTypeId") String var1);

    @GET
    @Path(value="/customEntities")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get list of all custom entities", tags={"customEntities"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=QueryResults.class)})
    public QueryResults queryCustomEntities(@QueryParam(value="page") @NotNull @DefaultValue(value="1") Integer var1, @QueryParam(value="pageSize") @NotNull @DefaultValue(value="10") Integer var2, @QueryParam(value="filter") @DefaultValue(value="") String var3, @QueryParam(value="sortAsc") @DefaultValue(value="") String var4, @QueryParam(value="sortDesc") @DefaultValue(value="") String var5);

    @GET
    @Path(value="/customEntityTypes")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get list of all custom entity types", tags={"customEntities"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=QueryResults.class)})
    public QueryResults queryCustomEntityTypes(@QueryParam(value="page") @NotNull @DefaultValue(value="1") Integer var1, @QueryParam(value="pageSize") @NotNull @DefaultValue(value="10") Integer var2, @QueryParam(value="filter") @DefaultValue(value="") String var3, @QueryParam(value="sortAsc") @DefaultValue(value="") String var4, @QueryParam(value="sortDesc") @DefaultValue(value="") String var5);

    @PUT
    @Path(value="/customEntityTypes/{customEntityTypeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update specified custom entity type", tags={"customEntities"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CustomEntityType.class)})
    public CustomEntityType updateCustomEntityType(@Valid CustomEntityType var1, @PathParam(value="customEntityTypeId") String var2);
}

