/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.rest.openapi.api;

import com.vmware.vcloud.rest.openapi.model.ExecutionContext;
import com.vmware.vcloud.rest.openapi.model.ExecutionState;
import com.vmware.vcloud.rest.openapi.model.ParameterTypes;
import com.vmware.vcloud.rest.openapi.model.PresentationExecutionsList;
import com.vmware.vcloud.rest.openapi.model.SupportedConstraints;
import com.vmware.vcloud.rest.openapi.model.SupportedDecorators;
import com.vmware.vcloud.rest.openapi.model.SupportedPresentationElements;
import com.vmware.vcloud.rest.openapi.model.WsWorkflowExecution;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/")
@Api(value="/", description="")
public interface VroWorkflowExecutionApi {
    @DELETE
    @Path(value="/workflows/{workflowId}/executions/{executionId}/state")
    @ApiOperation(value="Cancel workflow run", tags={"vroWorkflowExecution"})
    @ApiResponses(value={@ApiResponse(code=204, message="No content. Workflow execution has been cancelled"), @ApiResponse(code=400, message="The request is invalid(validation error)"), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Can not find a workflow with the specified ID or the user does not have 'read' access rights for that workflow")})
    public void cancelWorkflowExecution(@PathParam(value="workflowId") String var1, @PathParam(value="executionId") String var2);

    @DELETE
    @Path(value="/workflows/{workflowId}/executions/{executionId}")
    @ApiOperation(value="Delete workflow run", tags={"vroWorkflowExecution"})
    @ApiResponses(value={@ApiResponse(code=204, message="No content. Workflow run has been deleted"), @ApiResponse(code=400, message="The request is invalid(validation error)"), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Can not find a workflow with the specified ID or the user does not have 'read' access rights for that workflow")})
    public void deleteWorkflowExecution(@PathParam(value="workflowId") String var1, @PathParam(value="executionId") String var2);

    @GET
    @Path(value="/workflows/{workflowId}/executions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all executions", tags={"vroWorkflowExecution"})
    @ApiResponses(value={@ApiResponse(code=200, message="Workflow executions successfully retrieved", response=PresentationExecutionsList.class), @ApiResponse(code=401, message="The user is not authorized to retrieve workflow executions"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Cannot find a workflow with the specified ID or the user does not have 'read' access rights for that workflow")})
    public PresentationExecutionsList getAllWorkflowExecutions(@PathParam(value="workflowId") String var1);

    @GET
    @Path(value="/workflows/parameterTypes")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a list of supported parameter types", tags={"vroWorkflowExecution"})
    @ApiResponses(value={@ApiResponse(code=200, message="The request is successful", response=ParameterTypes.class), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="Forbidden")})
    public ParameterTypes getParameterTypes();

    @GET
    @Path(value="/workflows/decorators")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a list of supported decorators", tags={"vroWorkflowExecution"})
    @ApiResponses(value={@ApiResponse(code=200, message="The request is successful", response=SupportedDecorators.class), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="Forbidden")})
    public SupportedDecorators getSupportedDecorators();

    @GET
    @Path(value="/workflows/presentationElements")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a list of supported presentation elements", tags={"vroWorkflowExecution"})
    @ApiResponses(value={@ApiResponse(code=200, message="The request is successful", response=SupportedPresentationElements.class), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="Forbidden")})
    public SupportedPresentationElements getSupportedPresentationElements();

    @GET
    @Path(value="/workflows/constraints")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a list of supported constraints", tags={"vroWorkflowExecution"})
    @ApiResponses(value={@ApiResponse(code=200, message="The request is successful", response=SupportedConstraints.class), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="Forbidden")})
    public SupportedConstraints getSupportedconstraints();

    @GET
    @Path(value="/workflows/{workflowId}/executions/{executionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get workflow execution", tags={"vroWorkflowExecution"})
    @ApiResponses(value={@ApiResponse(code=200, message="Workflow execution successfully retrived", response=WsWorkflowExecution.class), @ApiResponse(code=400, message="The request is invalid(validation error)"), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Cannot find a workflow with the specified ID or the user does not have 'read' access rights for that workflow")})
    public WsWorkflowExecution getWorkflowExecution(@PathParam(value="workflowId") String var1, @PathParam(value="executionId") String var2);

    @GET
    @Path(value="/workflows/{workflowId}/executions/{executionId}/state")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get workflow execution state", tags={"vroWorkflowExecution"})
    @ApiResponses(value={@ApiResponse(code=200, message="The request is successful", response=ExecutionState.class), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Cannot find a workflow with the specified ID or the user does not have 'read' access rights for that workflow")})
    public ExecutionState getWorkflowExecutionState(@PathParam(value="workflowId") String var1, @PathParam(value="executionId") String var2);

    @POST
    @Path(value="/workflows/{workflowId}/executions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Start workflow execution", tags={"vroWorkflowExecution"})
    @ApiResponses(value={@ApiResponse(code=201, message="Workflow execution instance has been created", response=WsWorkflowExecution.class), @ApiResponse(code=400, message="The request is invalid(validation error)"), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Cannot find a workflow with the specified ID or the user does not have 'read' access rights for that workflow")})
    public WsWorkflowExecution startWorkflowExecution(@PathParam(value="workflowId") String var1, @Valid ExecutionContext var2);
}

