/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.rest.openapi.api;

import com.vmware.vcloud.rest.openapi.model.ExecutionContext;
import com.vmware.vcloud.rest.openapi.model.Presentation;
import com.vmware.vcloud.rest.openapi.model.PresentationExecution;
import com.vmware.vcloud.rest.openapi.model.PresentationExecutionsList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/")
@Api(value="/", description="")
public interface VroWorkflowPresentationApi {
    @DELETE
    @Path(value="/workflows/{workflowId}/presentation/instances/{presentationExecutionId}")
    @ApiOperation(value="Delete workflow presentation execution", tags={"vroWorkflowPresentation"})
    @ApiResponses(value={@ApiResponse(code=204, message="No content"), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Cannot find a workflow or presentation instance with specified ID")})
    public void deleteWorkflowPresenationInstance(@PathParam(value="workflowId") String var1, @PathParam(value="presentationExecutionId") String var2);

    @GET
    @Path(value="/workflows/{workflowId}/presentation/instances")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all presentations", tags={"vroWorkflowPresentation"})
    @ApiResponses(value={@ApiResponse(code=200, message="The request is successful", response=PresentationExecutionsList.class), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Cannot find a workflow with the specified ID or the user does not have 'read' access rights for that workflow")})
    public PresentationExecutionsList getAllWorkflowPresentationInstances(@PathParam(value="workflowId") String var1);

    @GET
    @Path(value="/workflows/{workflowId}/presentation")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get presentation", tags={"vroWorkflowPresentation"})
    @ApiResponses(value={@ApiResponse(code=200, message="The request is successful", response=Presentation.class), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Cannot find a workflow with the specified ID or the user does not have 'read' access rights for that workflow")})
    public Presentation getWorkflowPresentation(@PathParam(value="workflowId") String var1);

    @GET
    @Path(value="/workflows/{workflowId}/presentation/instances/{presentationExecutionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Load Execution", tags={"vroWorkflowPresentation"})
    @ApiResponses(value={@ApiResponse(code=200, message="The request is successful", response=PresentationExecution.class), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="The user does not have 'read' access rights for that workflow"), @ApiResponse(code=404, message="Cannot find a workflow with the specified ID")})
    public PresentationExecution getWorkflowPresentationInstance(@PathParam(value="workflowId") String var1, @PathParam(value="presentationExecutionId") String var2);

    @POST
    @Path(value="/workflows/{workflowId}/presentation/instances")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Start presentation", tags={"vroWorkflowPresentation"})
    @ApiResponses(value={@ApiResponse(code=200, message="The request is successful", response=PresentationExecution.class), @ApiResponse(code=201, message="Created"), @ApiResponse(code=400, message="The request is invalid(validation error)"), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Cannot find a workflow with the specified ID or the user does not have 'read' access rights for that workflow")})
    public PresentationExecution startWorkflowPresentation(@PathParam(value="workflowId") String var1, @Valid ExecutionContext var2);

    @PUT
    @Path(value="/workflows/{workflowId}/presentation/instances/{presentationExecutionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update presentation", tags={"vroWorkflowPresentation"})
    @ApiResponses(value={@ApiResponse(code=200, message="The request is successful", response=PresentationExecution.class), @ApiResponse(code=400, message="The request is invalid(validation error)"), @ApiResponse(code=401, message="The user is not authorized"), @ApiResponse(code=403, message="The user does not have 'read' access rights for that workflow"), @ApiResponse(code=404, message="Cannot find a workflow or presentation instance with specified ID")})
    public PresentationExecution updateWorkflowPresentationInstance(@PathParam(value="workflowId") String var1, @PathParam(value="presentationExecutionId") String var2, @Valid ExecutionContext var3);
}

