/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.api.rest.client;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TaskStatus {
    PENDING("pending"),
    PRE_RUNNING("pre-running"),
    RUNNING("running"),
    SUCCESS("success"),
    ABORTED("aborted"),
    ERROR("error"),
    CANCELED("canceled");

    private static final Map<String, TaskStatus> REVERSE_LOOKUP_MAP;
    private final String label;

    private TaskStatus(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }

    public static TaskStatus from(String s) {
        Optional<TaskStatus> ts = Optional.ofNullable(REVERSE_LOOKUP_MAP.get(s));
        return ts.orElseThrow(IllegalArgumentException::new);
    }

    static {
        Map<String, TaskStatus> reverseLookupMap = Stream.of(TaskStatus.values()).collect(Collectors.toMap(TaskStatus::getLabel, ts -> ts));
        REVERSE_LOOKUP_MAP = Collections.unmodifiableMap(reverseLookupMap);
    }
}

