/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.api.rest.client;

import com.vmware.cxfrestclient.CxfClientSecurityContext;
import com.vmware.vcloud.api.rest.client.AbstractVcdClientBase;
import com.vmware.vcloud.api.rest.client.ClientCredentials;
import com.vmware.vcloud.api.rest.client.EventViewer;
import com.vmware.vcloud.api.rest.client.MissingLinkException;
import com.vmware.vcloud.api.rest.client.MissingRecordException;
import com.vmware.vcloud.api.rest.client.MultipleRecordsException;
import com.vmware.vcloud.api.rest.client.NsxProxyApiClient;
import com.vmware.vcloud.api.rest.client.OpenApiClient;
import com.vmware.vcloud.api.rest.client.OpenApiClientImpl;
import com.vmware.vcloud.api.rest.client.QueryResultFormat;
import com.vmware.vcloud.api.rest.client.VcdClient;
import com.vmware.vcloud.api.rest.client.VcdErrorException;
import com.vmware.vcloud.api.rest.client.VcdErrorResponseException;
import com.vmware.vcloud.api.rest.client.VcdErrorResponseProcessingException;
import com.vmware.vcloud.api.rest.client.VcdMultisiteLoginCredentials;
import com.vmware.vcloud.api.rest.client.VcdTaskMonitor;
import com.vmware.vcloud.api.rest.client.VcdUtils;
import com.vmware.vcloud.api.rest.client.constants.RelationType;
import com.vmware.vcloud.api.rest.client.filters.MultisiteAuthorizationFilter;
import com.vmware.vcloud.api.rest.client.impl.EventViewerImpl;
import com.vmware.vcloud.api.rest.client.impl.tasks.VcdTaskMonitorImpl;
import com.vmware.vcloud.api.rest.schema.versioning.SupportedVersionsType;
import com.vmware.vcloud.api.rest.schema.versioning.VersionInfoType;
import com.vmware.vcloud.api.rest.schema_v1_5.AdminOrgType;
import com.vmware.vcloud.api.rest.schema_v1_5.ApiExtensibilityType;
import com.vmware.vcloud.api.rest.schema_v1_5.ContainerType;
import com.vmware.vcloud.api.rest.schema_v1_5.EntityType;
import com.vmware.vcloud.api.rest.schema_v1_5.ErrorType;
import com.vmware.vcloud.api.rest.schema_v1_5.LinkType;
import com.vmware.vcloud.api.rest.schema_v1_5.MultisiteSessionUserInfoType;
import com.vmware.vcloud.api.rest.schema_v1_5.OrgListType;
import com.vmware.vcloud.api.rest.schema_v1_5.OrgType;
import com.vmware.vcloud.api.rest.schema_v1_5.OrganizationReferenceType;
import com.vmware.vcloud.api.rest.schema_v1_5.QueryListType;
import com.vmware.vcloud.api.rest.schema_v1_5.QueryResultRecordType;
import com.vmware.vcloud.api.rest.schema_v1_5.QueryResultRecordsType;
import com.vmware.vcloud.api.rest.schema_v1_5.ReferenceType;
import com.vmware.vcloud.api.rest.schema_v1_5.ReferencesType;
import com.vmware.vcloud.api.rest.schema_v1_5.ResourceType;
import com.vmware.vcloud.api.rest.schema_v1_5.SessionType;
import com.vmware.vcloud.api.rest.schema_v1_5.VCloudType;
import com.vmware.vcloud.api.rest.schema_v1_5.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema_v1_5.extension.VMWExtensionType;
import com.vmware.vcloud.api.rest.version.ApiVersion;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementTypedProvider;

public class VcdClientImpl
extends AbstractVcdClientBase
implements VcdClient {
    private volatile String authenticationToken;
    private volatile String jwtToken;
    private volatile ClientCredentials clientCredentials;
    private volatile MultivaluedMap<String, Object> responseHeaders;
    private final Map<String, String> cookies = new LinkedHashMap<String, String>();
    private final VcdTaskMonitor taskMonitor = new VcdTaskMonitorImpl(this);
    private final EventViewer eventViewer = new EventViewerImpl(this);
    private Map<String, URI> queryListMap = null;
    private static final String BEARER = "Bearer";
    private final String apiVersion;
    private boolean federateRequests = false;
    private String orgContext;
    private String orgSecurityContext;
    private URI sessionHref = null;
    private URI loggedInAdminOrgEndpoint = null;
    private Map<WellKnownEndpoint, URI> sessionEndpoints;
    private static final Class<?>[] OBJECT_FACTORIES = new Class[]{com.vmware.vcloud.api.rest.schema.versioning.ObjectFactory.class, com.vmware.vcloud.api.rest.schema_v1_5.ObjectFactory.class, ObjectFactory.class, com.vmware.vcloud.api.rest.schema.ovf.vmware.ObjectFactory.class, com.vmware.vcloud.api.rest.schema.ovf.ObjectFactory.class, com.vmware.vcloud.api.rest.schema.ovf.environment.ObjectFactory.class};
    private static final List<?> PROVIDER_LIST = VcdClientImpl.createJAXBElementProviderFromObjectFactories();

    protected static List<JAXBElementProvider<?>> createJAXBElementProviderFromObjectFactories() {
        ArrayList list = new ArrayList();
        JAXBElementTypedProvider jaxbProvider = new JAXBElementTypedProvider();
        jaxbProvider.setExtraClass((Class[])OBJECT_FACTORIES);
        list.add((JAXBElementProvider<?>)jaxbProvider);
        JAXBElementProvider objProvider = new JAXBElementProvider();
        objProvider.setExtraClass((Class[])OBJECT_FACTORIES);
        list.add(objProvider);
        return list;
    }

    @Override
    protected List<?> getCxfProviders() {
        List providers = PROVIDER_LIST.stream().collect(Collectors.toList());
        if (this.clientCredentials instanceof VcdMultisiteLoginCredentials) {
            providers.add(new MultisiteAuthorizationFilter((VcdMultisiteLoginCredentials)this.clientCredentials));
        }
        return providers;
    }

    public VcdClientImpl(URI endpoint, String apiVersion, CxfClientSecurityContext cxfClientSecurityContext) {
        super(endpoint, cxfClientSecurityContext);
        this.apiVersion = apiVersion;
    }

    public VcdClientImpl(URI endpoint, List<ApiVersion> candidateVersions, CxfClientSecurityContext cxfClientSecurityContext) {
        super(endpoint, cxfClientSecurityContext);
        SupportedVersionsType supportedVersions = this.getVersions();
        HashSet<String> cloudSupportedApiVersions = new HashSet<String>();
        for (VersionInfoType versionType : supportedVersions.getVersionInfo()) {
            cloudSupportedApiVersions.add(versionType.getVersion());
        }
        for (ApiVersion candidateVersion : candidateVersions) {
            if (!cloudSupportedApiVersions.contains(candidateVersion.value())) continue;
            this.apiVersion = candidateVersion.value();
            return;
        }
        throw new RuntimeException("No preferred API Version is supported by cloud. Preferred versions: " + candidateVersions.toString() + "; vCD supported versions:" + ((Object)cloudSupportedApiVersions).toString() + "; Cloud URL:" + endpoint);
    }

    private VcdClientImpl(VcdClientImpl vcdClient) {
        super(vcdClient);
        this.apiVersion = vcdClient.apiVersion;
    }

    private URI getEndpoint(WellKnownEndpoint endpoint) {
        return this.sessionEndpoints == null ? null : this.sessionEndpoints.get((Object)endpoint);
    }

    protected URI getOpenApiEndpoint() {
        UriBuilder builder = UriBuilder.fromUri((URI)this.getEndpoint()).replacePath("cloudapi");
        URI openApiEndPoint = builder.build(new Object[0]);
        return openApiEndPoint;
    }

    @Override
    public List<ReferenceType> getOrganizations() {
        OrgListType orgList = (OrgListType)this.createWebClient(this.validateEndpoint(WellKnownEndpoint.ORG_LIST)).get(OrgListType.class);
        return Collections.unmodifiableList(orgList.getOrg());
    }

    @Override
    public SessionType getSession() {
        this.validateEndpoint(this.sessionHref);
        return this.getResource(this.sessionHref, SessionType.class);
    }

    @Override
    public MultisiteSessionUserInfoType getSessionUserInfo() {
        this.validateEndpoint(this.sessionHref);
        return this.getResource(UriBuilder.fromUri((URI)this.sessionHref).path("userInfo").build(new Object[0]), MultisiteSessionUserInfoType.class);
    }

    @Override
    public SupportedVersionsType getVersions() {
        return this.getResource(UriBuilder.fromUri((URI)this.endpoint).path("/versions").build(new Object[0]), SupportedVersionsType.class);
    }

    @Override
    public String getClientApiVersion() {
        return this.apiVersion;
    }

    private <ResponseClass> ResponseClass getResource(WellKnownEndpoint endpoint, Class<ResponseClass> resourceClass) {
        return this.getResource(this.validateEndpoint(endpoint), resourceClass);
    }

    @Override
    public VCloudType getAdmin() {
        return this.getResource(WellKnownEndpoint.ADMIN, VCloudType.class);
    }

    @Override
    public VMWExtensionType getExtension() {
        return this.getResource(WellKnownEndpoint.EXTENSION, VMWExtensionType.class);
    }

    @Override
    public QueryListType getQueryList() {
        return this.getResource(WellKnownEndpoint.QUERY_LIST, QueryListType.class);
    }

    @Override
    public ApiExtensibilityType getApiExtensibility() {
        return this.getResource(WellKnownEndpoint.API_EXTENSIBILITY, ApiExtensibilityType.class);
    }

    @Override
    public OrgType getLoggedInOrg() {
        return this.getResource(WellKnownEndpoint.LOGGED_IN_ORG, OrgType.class);
    }

    @Override
    public EntityType resolveEntityById(String id) {
        return this.getResource(UriBuilder.fromUri((URI)this.validateEndpoint(WellKnownEndpoint.ENTITY_RESOLVER)).path(id).build(new Object[0]), EntityType.class);
    }

    @Override
    public AdminOrgType getLoggedInAdminOrg() {
        OrgType org = this.getLoggedInOrg();
        LinkType link = VcdUtils.findLink((ResourceType)org, RelationType.ALTERNATE, "application/vnd.vmware.admin.organization+xml", false);
        if (link != null) {
            return this.getResource(link.getHref(), AdminOrgType.class);
        }
        if (this.loggedInAdminOrgEndpoint == null) {
            this.loggedInAdminOrgEndpoint = this.getLoggedInOrgAdminURI();
        }
        this.validateEndpoint(this.loggedInAdminOrgEndpoint, RelationType.DOWN, "application/vnd.vmware.admin.vcloud+xml");
        return this.getResource(this.loggedInAdminOrgEndpoint, AdminOrgType.class);
    }

    @Override
    public OpenApiClient getOpenApiClient() {
        return new OpenApiClientImpl(this);
    }

    @Override
    public NsxProxyApiClient getNsxProxyApiClient() {
        return new NsxProxyApiClient(this);
    }

    private void validateEndpoint(URI endpoint) {
        if (endpoint == null) {
            throw new IllegalStateException("Can't perform operation when not logged in");
        }
    }

    private void validateEndpoint(URI endpoint, RelationType rel, String mediaType) {
        if (endpoint == null) {
            throw new MissingLinkException(this.sessionHref.toASCIIString(), rel, mediaType);
        }
    }

    private URI validateEndpoint(WellKnownEndpoint endpoint) {
        URI uri = this.getEndpoint(endpoint);
        this.validateEndpoint(uri, endpoint.rel, endpoint.mediaType);
        return uri;
    }

    @Override
    protected String[] getAcceptHeaders() {
        StringBuffer acceptHeader = new StringBuffer("application/*+xml");
        if (this.apiVersion != null) {
            acceptHeader.append(";version=");
            acceptHeader.append(this.apiVersion);
        }
        if (this.federateRequests) {
            acceptHeader.append(";multisite=global");
        }
        String accept = acceptHeader.toString();
        return new String[]{accept};
    }

    @Override
    public void setAuthenticationHeader(Client client) {
        if (this.jwtToken != null) {
            client.header("Authorization", new Object[]{"Bearer " + this.jwtToken});
            if (this.orgSecurityContext != null) {
                client.header("X-VMWARE-VCLOUD-AUTH-CONTEXT", new Object[]{this.orgSecurityContext});
            }
        } else if (this.hasSessionlessClientCredentials()) {
            client.header(this.clientCredentials.getHeaderName(), new Object[]{this.clientCredentials.getHeaderValue()});
        } else if (this.authenticationToken != null) {
            client.header("x-vcloud-authorization", new Object[]{this.authenticationToken});
        }
    }

    @Override
    protected void setAuthenticationHeaders(Client client) {
        this.setAuthenticationHeader(client);
        if (this.cookies.containsKey("vcloud_jwt")) {
            this.addCookie("vcloud_jwt", client);
        }
        if (this.cookies.containsKey("vcloud_session_id")) {
            this.addCookie("vcloud_session_id", client);
        } else if (this.cookies.containsKey("vcloud-token")) {
            this.addCookie("vcloud-token", client);
        }
    }

    private void addCookie(String cookieName, Client client) {
        String rawCookie = this.cookies.get(cookieName);
        String cookieValue = rawCookie.substring(rawCookie.indexOf("=") + 1);
        Cookie cookie = new Cookie(cookieName, cookieValue);
        client.cookie(cookie);
    }

    @Override
    public String getOrgContextHeader() {
        return this.orgContext;
    }

    @Override
    public void setOrgContextHeader(String orgContext) {
        this.orgContext = orgContext;
    }

    @Override
    public void login(ClientCredentials credentials) {
        this.dologinInternal(credentials);
    }

    @Override
    public void relogin() {
        if (this.clientCredentials == null) {
            throw new RuntimeException("Expected client credentials to not be null");
        }
        this.dologinInternal(this.clientCredentials);
    }

    @Override
    public void loginWithJwt(String jwt, String orgSecurityContext) {
        this.orgSecurityContext = orgSecurityContext;
        this.clientCredentials = null;
        this.jwtToken = jwt;
        this.doInitClient();
    }

    @Override
    public void loginWithToken(VcdClient.SessionToken sessionToken) {
        this.setCredentialsInternal(null);
        if (!(sessionToken instanceof SessionTokenImpl)) {
            throw new AssertionError((Object)"Invalid session token.");
        }
        SessionTokenImpl sessionTokenImpl = (SessionTokenImpl)sessionToken;
        this.authenticationToken = sessionTokenImpl.getAuthenticationToken();
        String vCloudTokenCookie = sessionTokenImpl.getVCloudToken();
        if (vCloudTokenCookie != null) {
            this.cookies.put("vcloud-token", vCloudTokenCookie);
        }
        this.doInitClient();
    }

    private void initializeWithSession(WebClient client, boolean isLogin) {
        this.configureHttpRequestHeaders((Client)client);
        this.configureSSLTrustManager(WebClient.getConfig((Object)client));
        Response response = isLogin ? client.post(null) : client.get();
        this.checkResponse(response, 200);
        SessionType session = (SessionType)response.readEntity(SessionType.class);
        this.responseHeaders = response.getMetadata();
        if (isLogin && !this.hasSessionlessClientCredentials()) {
            this.processHeaders();
            this.configureHttpRequestHeaders((Client)client);
        }
        this.sessionHref = URI.create(session.getHref());
        this.sessionEndpoints = WellKnownEndpoint.getSessionEndpoints(session);
    }

    private void checkResponse(Response response, int expectedStatus) {
        if (response.getStatus() == expectedStatus) {
            return;
        }
        int responseStatus = response.getStatus();
        ErrorType error = null;
        if (responseStatus != 401) {
            try {
                error = (ErrorType)response.readEntity(ErrorType.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String requestId = this.getRequestId(response);
        throw new VcdErrorResponseException(responseStatus, requestId, error, null);
    }

    private String getRequestId(Response response) {
        String requestId = response.getHeaderString("X-VMWARE-VCLOUD-REQUEST-ID");
        return requestId;
    }

    @Override
    public VcdClient.SessionToken getSessionToken() {
        if (this.authenticationToken != null) {
            return new SessionTokenImpl(this.authenticationToken, this.cookies.get("vcloud-token"));
        }
        return null;
    }

    @Override
    public String getJwtToken() {
        return this.jwtToken;
    }

    private void processHeaders() {
        List rawCookies;
        this.authenticationToken = (String)this.responseHeaders.getFirst((Object)"x-vcloud-authorization");
        if (this.authenticationToken == null) {
            throw new RuntimeException("The login response is missing a x-vcloud-authorization cookie");
        }
        String accessToken = (String)this.responseHeaders.getFirst((Object)"X-VMWARE-VCLOUD-ACCESS-TOKEN");
        if (accessToken != null) {
            this.jwtToken = accessToken;
        }
        if ((rawCookies = (List)this.responseHeaders.get((Object)"Set-Cookie")) == null) {
            return;
        }
        for (Object o : rawCookies) {
            String rawCookie = (String)o;
            String name = rawCookie.substring(0, rawCookie.indexOf("="));
            this.cookies.put(name, rawCookie);
        }
    }

    private URI getLoggedInOrgAdminURI() {
        if (this.getEndpoint(WellKnownEndpoint.ADMIN) == null) {
            return null;
        }
        OrgType loggedInOrg = this.getLoggedInOrg();
        String loggedInOrgId = loggedInOrg.getId();
        List adminOrganizationReferences = this.getAdmin().getOrganizationReferences().getOrganizationReference();
        for (OrganizationReferenceType adminOrganizationReference : adminOrganizationReferences) {
            AdminOrgType adminOrgType = this.getResource((ReferenceType)adminOrganizationReference, AdminOrgType.class);
            if (!loggedInOrgId.equals(adminOrgType.getId())) continue;
            return URI.create(adminOrgType.getHref());
        }
        throw new AssertionError((Object)"Admin org reference not found despite user having access to admin resources!!");
    }

    @Override
    public void logout() {
        try {
            Response response = this.createWebClient(UriBuilder.fromUri((URI)this.endpoint).path("/session").build(new Object[0])).delete();
            this.checkResponse(response, 204);
        }
        finally {
            this.clearSessionData();
        }
    }

    @Override
    public VcdClient duplicate(boolean newSession) throws VcdErrorException {
        VcdClientImpl duplicateClient = new VcdClientImpl(this);
        if (newSession) {
            duplicateClient.setCredentials(this.clientCredentials);
        } else if (this.jwtToken != null) {
            duplicateClient.loginWithJwt(this.jwtToken, this.orgSecurityContext);
        } else {
            duplicateClient.loginWithToken(this.getSessionToken());
        }
        return duplicateClient;
    }

    private void clearSessionData() {
        this.cookies.clear();
        this.sessionEndpoints = null;
        this.loggedInAdminOrgEndpoint = null;
        this.authenticationToken = null;
        this.sessionHref = null;
        this.jwtToken = null;
    }

    @Override
    public WebClient createWebClient(URI uri, String type) {
        WebClient client = super.createWebClient(uri, type);
        client.type(type != null ? type : "application/*+xml");
        return client;
    }

    @Override
    public Response getServerStatus() {
        WebClient webClient = this.createWebClient(UriBuilder.fromUri((URI)this.endpoint).path("server_status").build(new Object[0]));
        webClient.accept(new String[]{"*/*"});
        return webClient.get();
    }

    @Override
    public <ResourceClass> ResourceClass getResource(ResourceType resource, RelationType rel, String mediaType, Class<ResourceClass> resourceClass) {
        LinkType link = VcdUtils.findLink(resource, rel, mediaType);
        return this.getResource(link.getHref(), resourceClass);
    }

    @Override
    public <ResourceClass extends ResourceType> ResourceClass getResource(ResourceType resourceType, Class<ResourceClass> resourceClass) {
        return (ResourceClass)((ResourceType)this.getResource(resourceType.getHref(), resourceClass));
    }

    @Override
    public <ResourceClass> ResourceClass getResource(ReferenceType reference, Class<ResourceClass> resourceClass) {
        return this.getResource(reference.getHref(), resourceClass);
    }

    private <ResourceClass> ResourceClass getResource(String href, Class<ResourceClass> resourceClass) {
        return super.getResource(URI.create(href), resourceClass);
    }

    @Override
    public <ResponseClass extends EntityType> ResponseClass getEntity(String entityId, String mediaType, Class<ResponseClass> responseClass) {
        EntityType resolvedEntity = this.resolveEntityById(entityId);
        return (ResponseClass)((EntityType)this.getResource((ResourceType)resolvedEntity, RelationType.ALTERNATE, mediaType, responseClass));
    }

    @Override
    public <T extends EntityType> T getEntity(ReferenceType referenceType, Class<T> resourceClass, VcdClient.ReferenceTypeChangedCallBack referenceTypeChangedCallBack) {
        T result;
        Throwable savedException = null;
        try {
            String href = referenceType.getHref();
            if (href != null) {
                EntityType result2 = (EntityType)this.getResource(URI.create(href), resourceClass);
                if (referenceType.getId().equals(result2.getId())) {
                    return (T)result2;
                }
            }
        }
        catch (ProcessingException e) {
            savedException = e;
        }
        catch (VcdErrorException e) {
            if (e.getHttpStatusCode() == 401) {
                throw e;
            }
            savedException = e;
        }
        try {
            result = this.getEntity(referenceType.getId(), referenceType.getType(), resourceClass);
        }
        catch (RuntimeException e) {
            if (savedException != null) {
                throw savedException;
            }
            throw e;
        }
        referenceTypeChangedCallBack.hrefChanged(result.getHref());
        return result;
    }

    @Override
    public <ContentsClass, ResponseClass> ResponseClass putResource(ResourceType resource, RelationType rel, String mediaType, JAXBElement<ContentsClass> contents, Class<ResponseClass> responseClass) {
        LinkType link = VcdUtils.findLink(resource, rel, mediaType);
        return this.putResource(link.getHref(), mediaType, contents, responseClass);
    }

    @Override
    public <ContentsClass, ResponseClass> ResponseClass putResource(ReferenceType reference, String mediaType, JAXBElement<ContentsClass> contents, Class<ResponseClass> responseClass) {
        return this.putResource(reference.getHref(), mediaType, contents, responseClass);
    }

    @Override
    public <ContentsClass extends ResourceType, ResponseClass> ResponseClass putResource(String mediaType, JAXBElement<ContentsClass> contents, Class<ResponseClass> responseClass) {
        return this.putResource(((ResourceType)contents.getValue()).getHref(), mediaType, contents, responseClass);
    }

    private <ContentsClass, ResponseClass> ResponseClass putResource(String href, String mediaType, JAXBElement<ContentsClass> contents, Class<ResponseClass> responseClass) throws VcdErrorException {
        return super.putResource(URI.create(href), mediaType, contents, responseClass);
    }

    @Override
    public <ContentsClass, ResponseClass> ResponseClass postResource(ResourceType resource, RelationType rel, String mediaType, JAXBElement<ContentsClass> contents, Class<ResponseClass> responseClass) {
        LinkType link = VcdUtils.findLink(resource, rel, mediaType);
        return this.postResource(link.getHref(), mediaType, contents, responseClass);
    }

    @Override
    public <ContentsClass, ResponseClass> ResponseClass postResource(ReferenceType reference, String mediaType, JAXBElement<ContentsClass> contents, Class<ResponseClass> responseClass) {
        return this.postResource(reference.getHref(), mediaType, contents, responseClass);
    }

    private <ContentsClass, ResponseClass> ResponseClass postResource(String href, String mediaType, JAXBElement<ContentsClass> contents, Class<ResponseClass> responseClass) throws VcdErrorException {
        return super.postResource(URI.create(href), mediaType, contents, responseClass);
    }

    @Override
    protected VcdErrorException makeException(WebApplicationException webApplicationException) {
        Response response = webApplicationException.getResponse();
        int responseStatus = response.getStatus();
        try {
            String requestId = this.getRequestId(response);
            String contentType = response.getHeaderString("Content-Type");
            if (StringUtils.contains((CharSequence)contentType, (CharSequence)"application/vnd.vmware.vcloud.error")) {
                ErrorType error = (ErrorType)response.readEntity(ErrorType.class);
                return new VcdErrorResponseException(responseStatus, requestId, error, webApplicationException);
            }
            if (StringUtils.contains((CharSequence)contentType, (CharSequence)"text/plain") || StringUtils.contains((CharSequence)contentType, (CharSequence)"text/xml")) {
                String errorMsg = (String)response.readEntity(String.class);
                return new VcdErrorResponseException(responseStatus, requestId, errorMsg, webApplicationException);
            }
            return new VcdErrorResponseProcessingException(responseStatus, null, webApplicationException);
        }
        catch (ProcessingException pe) {
            return new VcdErrorResponseProcessingException(responseStatus, (Exception)((Object)pe), webApplicationException);
        }
        catch (IllegalStateException ise) {
            return new VcdErrorResponseProcessingException(responseStatus, ise, webApplicationException);
        }
    }

    @Override
    public Response removeResource(ResourceType resource) {
        return this.removeResource(resource, null, null, Response.class);
    }

    @Override
    public <ResponseClass> ResponseClass removeResource(ResourceType resource, Boolean force, Boolean recursive, Class<ResponseClass> responseClass) {
        try {
            LinkType link = VcdUtils.findLink(resource, RelationType.REMOVE, null);
            return this.deleteResource(VcdUtils.buildDeleteUri(URI.create(link.getHref()), force, recursive), responseClass);
        }
        catch (MissingLinkException e) {
            throw new UnsupportedOperationException("Unable to delete " + resource.getHref(), e);
        }
    }

    @Override
    public <ResponseClass> ResponseClass deleteResource(ReferenceType ref, Class<ResponseClass> responseClass) {
        return this.deleteResource(ref, null, null, responseClass);
    }

    @Override
    public <ResponseClass> ResponseClass deleteResource(ResourceType ref, Class<ResponseClass> responseClass) {
        return this.deleteResource(ref, null, null, responseClass);
    }

    @Override
    public <ResponseClass> ResponseClass deleteResource(ResourceType resource, Boolean force, Boolean recursive, Class<ResponseClass> responseClass) {
        return super.deleteResource(VcdUtils.buildDeleteUri(URI.create(resource.getHref()), force, recursive), responseClass);
    }

    @Override
    public <ResponseClass> ResponseClass deleteResource(ReferenceType ref, Boolean force, Boolean recursive, Class<ResponseClass> responseClass) {
        return super.deleteResource(VcdUtils.buildDeleteUri(URI.create(ref.getHref()), force, recursive), responseClass);
    }

    @Override
    public com.vmware.vcloud.api.rest.schema_v1_5.ObjectFactory getVCloudObjectFactory() {
        return new com.vmware.vcloud.api.rest.schema_v1_5.ObjectFactory();
    }

    @Override
    public ObjectFactory getVCloudExtensionObjectFactory() {
        return new ObjectFactory();
    }

    @Override
    public com.vmware.vcloud.api.rest.schema.ovf.ObjectFactory getOvfObjectFactory() {
        return new com.vmware.vcloud.api.rest.schema.ovf.ObjectFactory();
    }

    @Override
    public com.vmware.vcloud.api.rest.schema.ovf.vmware.ObjectFactory getOvfVmwareObjectFactory() {
        return new com.vmware.vcloud.api.rest.schema.ovf.vmware.ObjectFactory();
    }

    @Override
    public VcdTaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    @Override
    public EventViewer getEventViewer() {
        return this.eventViewer;
    }

    @Override
    public void setMultisiteRequests(boolean federateRequests) {
        this.federateRequests = federateRequests;
    }

    @Override
    public void setClientRequestIdProvider(VcdClient.ClientRequestIdProvider clientRequestIdGenerator) {
        super.setClientRequestIdProvider(clientRequestIdGenerator);
    }

    private Map<String, URI> getQueryListMap() {
        if (this.queryListMap == null) {
            this.queryListMap = new HashMap<String, URI>();
            for (LinkType link : this.getQueryList().getLink()) {
                String queryListKey = VcdClientImpl.makeQueryListMapKey(link.getType(), link.getName());
                this.queryListMap.put(queryListKey, URI.create(link.getHref()));
            }
        }
        return this.queryListMap;
    }

    private static String makeQueryListMapKey(String mediaType, String queryTypeName) {
        return mediaType + "!" + queryTypeName;
    }

    @Override
    public <QueryResultClass> VcdClient.Query<QueryResultClass> getQuery(String queryTypeName, Class<QueryResultClass> queryResultClass) {
        return new TypedQuery<QueryResultClass>(queryTypeName, queryResultClass);
    }

    @Override
    public <QueryResultClass> VcdClient.Query<QueryResultClass> getPackagedQuery(String queryPath, Class<QueryResultClass> queryResultClass) {
        return new PackagedQuery<QueryResultClass>(queryPath, queryResultClass);
    }

    private boolean hasSessionlessClientCredentials() {
        return this.clientCredentials != null && this.clientCredentials.supportsSessionless();
    }

    @Override
    public void setCredentials(ClientCredentials credentials) {
        this.setCredentialsInternal(credentials);
        if (credentials.supportsSessionless()) {
            this.doInitClient();
        } else {
            this.dologinInternal(credentials);
        }
    }

    ClientCredentials getCredentials() {
        return this.clientCredentials;
    }

    private void setCredentialsInternal(ClientCredentials credentials) {
        this.clientCredentials = credentials;
        this.jwtToken = null;
    }

    private void dologinInternal(ClientCredentials credentials) {
        this.setCredentialsInternal(credentials);
        WebClient client = this.createWebClient(UriBuilder.fromUri((URI)this.endpoint).path("/sessions").build(new Object[0]));
        client.header(credentials.getHeaderName(), new Object[]{credentials.getHeaderValue()});
        this.initializeWithSession(client, true);
    }

    private void doInitClient() {
        WebClient client = this.createWebClient(UriBuilder.fromUri((URI)this.endpoint).path("/session").build(new Object[0]));
        this.initializeWithSession(client, false);
    }

    private final class PackagedQuery<QueryResultClass>
    extends AbstractQuery<QueryResultClass> {
        private final String queryPath;

        public PackagedQuery(String queryPath, Class<QueryResultClass> queryResultClass) {
            super(queryResultClass);
            this.queryPath = queryPath;
        }

        @Override
        protected URI findQueryUri(QueryResultFormat format) {
            return UriBuilder.fromUri((URI)VcdClientImpl.this.endpoint).path(this.queryPath).queryParam("format", new Object[]{format.getApiString()}).build(new Object[0]);
        }
    }

    private abstract class AbstractQuery<QueryResultClass>
    implements VcdClient.Query<QueryResultClass> {
        final int DEFAULT_PAGE_SIZE = -1;
        private final Class<QueryResultClass> queryResultClass;
        private QueryResultFormat queryResultFormat;
        private int page = 1;
        private int pageSize = -1;
        private boolean includeLinks = false;
        private String filter;
        private String fields;
        private String sortDesc;
        private String sortAsc;

        public AbstractQuery(Class<QueryResultClass> queryResultClass) {
            this.queryResultClass = queryResultClass;
            if (ReferenceType.class.isAssignableFrom(queryResultClass)) {
                this.queryResultFormat = QueryResultFormat.REFERENCES;
            } else if (QueryResultRecordType.class.isAssignableFrom(queryResultClass)) {
                this.queryResultFormat = QueryResultFormat.RECORDS;
            } else {
                throw new IllegalArgumentException("queryResultClass");
            }
        }

        @Override
        public VcdClient.Query<QueryResultClass> setQueryResultFormat(QueryResultFormat queryResultFormat) {
            switch (queryResultFormat) {
                case REFERENCES: {
                    if (ReferenceType.class.isAssignableFrom(this.queryResultClass)) break;
                    throw new IllegalArgumentException("queryResultFormat");
                }
                case RECORDS: 
                case ID_RECORDS: {
                    if (QueryResultRecordType.class.isAssignableFrom(this.queryResultClass)) break;
                    throw new IllegalArgumentException("queryResultFormat");
                }
            }
            this.queryResultFormat = queryResultFormat;
            return this;
        }

        @Override
        public VcdClient.Query<QueryResultClass> setPage(int page) {
            this.page = page;
            return this;
        }

        @Override
        public VcdClient.Query<QueryResultClass> setPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public VcdClient.Query<QueryResultClass> setFilter(String filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public VcdClient.Query<QueryResultClass> setFields(Collection<String> fields) {
            this.fields = fields.stream().collect(Collectors.joining(","));
            return this;
        }

        @Override
        public VcdClient.Query<QueryResultClass> setEqualityFilter(String name, String value) {
            StringBuffer sb = new StringBuffer();
            if (this.filter != null) {
                sb.append(this.filter);
                sb.append(";");
            }
            sb.append(name);
            sb.append("==");
            sb.append(value);
            this.filter = sb.toString();
            return this;
        }

        @Override
        public VcdClient.Query<QueryResultClass> setSortDesc(String fieldName) {
            this.sortDesc = fieldName;
            return this;
        }

        @Override
        public VcdClient.Query<QueryResultClass> setSortAsc(String fieldName) {
            this.sortAsc = fieldName;
            return this;
        }

        @Override
        public VcdClient.Query<QueryResultClass> setIncludeLinks(boolean includeLinks) {
            this.includeLinks = includeLinks;
            return this;
        }

        @Override
        public ListIterator<VcdClient.QueryListPage<QueryResultClass>> execute() {
            URI queryUri = this.buildQueryUri(this.findQueryUri(this.queryResultFormat), this.page, this.pageSize, this.filter, this.includeLinks);
            if (QueryResultRecordType.class.isAssignableFrom(this.queryResultClass)) {
                QueryResultRecordsType queryResultRecordsType = VcdClientImpl.this.getResource(queryUri, QueryResultRecordsType.class);
                return new QueryResultPageIterator<QueryResultClass>((ContainerType)queryResultRecordsType, this.queryResultClass);
            }
            if (ReferenceType.class.isAssignableFrom(this.queryResultClass)) {
                ReferencesType referencesType = VcdClientImpl.this.getResource(queryUri, ReferencesType.class);
                return new QueryResultPageIterator<QueryResultClass>((ContainerType)referencesType, this.queryResultClass);
            }
            assert (false) : "Unexpected type of query results: " + this.queryResultClass;
            return null;
        }

        @Override
        public Stream<QueryResultClass> stream() {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.execute(), 16), false).flatMap(page -> page.getPage().stream());
        }

        protected abstract URI findQueryUri(QueryResultFormat var1);

        private URI buildQueryUri(URI baseQueryHref, int page, int pageSize, String filter, boolean includeLinks) {
            UriBuilder builder = UriBuilder.fromUri((URI)baseQueryHref);
            AtomicInteger index = new AtomicInteger(0);
            HashMap paramArgs = new HashMap();
            Function<Object, String> wrapArgInTemplate = argValue -> {
                String arg = String.format("arg%d", index.getAndIncrement());
                paramArgs.put(arg, ObjectUtils.defaultIfNull((Object)argValue, (Object)"").toString().replaceAll("\\+", "%2B"));
                return String.format("{%s}", arg);
            };
            builder.queryParam("page", new Object[]{wrapArgInTemplate.apply(page)});
            if (pageSize != -1) {
                builder.queryParam("pageSize", new Object[]{pageSize});
            }
            if (!StringUtils.isEmpty((CharSequence)this.fields)) {
                builder.queryParam("fields", new Object[]{wrapArgInTemplate.apply(this.fields)});
            }
            if (!StringUtils.isEmpty((CharSequence)filter)) {
                builder.queryParam("filterEncoded", new Object[]{wrapArgInTemplate.apply(true)});
                builder.queryParam("filter", new Object[]{wrapArgInTemplate.apply(filter)});
            }
            if (!StringUtils.isEmpty((CharSequence)this.sortAsc)) {
                builder.queryParam("sortAsc", new Object[]{wrapArgInTemplate.apply(this.sortAsc)});
            }
            if (includeLinks) {
                builder.queryParam("links", new Object[]{wrapArgInTemplate.apply(true)});
            }
            if (!StringUtils.isEmpty((CharSequence)this.sortDesc)) {
                builder.queryParam("sortDesc", new Object[]{wrapArgInTemplate.apply(this.sortDesc)});
            }
            return builder.buildFromMap(paramArgs);
        }

        @Override
        public QueryResultClass findUnique() {
            ListIterator<VcdClient.QueryListPage<QueryResultClass>> result = this.execute();
            if (!result.hasNext()) {
                throw new MissingRecordException(this.toString());
            }
            VcdClient.QueryListPage<QueryResultClass> page = result.next();
            List<QueryResultClass> pageContents = page.getPage();
            int size = pageContents.size();
            if (size != 1) {
                throw size > 1 ? new MultipleRecordsException(this.toString()) : new MissingRecordException(this.toString());
            }
            return pageContents.get(0);
        }

        public String toString() {
            URI u = this.buildQueryUri(this.findQueryUri(this.queryResultFormat), this.page, this.pageSize, this.filter, this.includeLinks);
            return u.toASCIIString();
        }
    }

    private final class TypedQuery<QueryResultClass>
    extends AbstractQuery<QueryResultClass> {
        private final String queryTypeName;

        public TypedQuery(String queryTypeName, Class<QueryResultClass> queryResultClass) {
            super(queryResultClass);
            this.queryTypeName = queryTypeName;
        }

        @Override
        protected URI findQueryUri(QueryResultFormat format) {
            String queryKey = VcdClientImpl.makeQueryListMapKey(format.getMediaType(), this.queryTypeName);
            URI queryHref = (URI)VcdClientImpl.this.getQueryListMap().get(queryKey);
            if (queryHref == null) {
                throw new IllegalArgumentException("No query found with given query format '" + format.getApiString() + "' and name '" + this.queryTypeName + "'");
            }
            return queryHref;
        }
    }

    private final class QueryResultPageIterator<T>
    implements ListIterator<VcdClient.QueryListPage<T>> {
        private ContainerType container;
        private final Class<T> queryResultClass;
        private boolean nextPageAvailable;

        public QueryResultPageIterator(ContainerType containerType, Class<T> queryResultClass) {
            this.container = containerType;
            this.queryResultClass = queryResultClass;
            this.nextPageAvailable = true;
        }

        @Override
        public boolean hasNext() {
            if (this.nextPageAvailable && this.container.getTotal() > 0L) {
                return true;
            }
            return this.getNextPageUri() != null;
        }

        @Override
        public VcdClient.QueryListPage<T> next() {
            if (this.nextPageAvailable) {
                this.nextPageAvailable = false;
            } else {
                this.container = (ContainerType)VcdClientImpl.this.getResource((ReferenceType)this.getNextPageUri(), this.container.getClass());
            }
            return this.getResultsPage();
        }

        @Override
        public boolean hasPrevious() {
            if (this.nextPageAvailable) {
                return false;
            }
            return this.getPrevPageUri() != null;
        }

        @Override
        public VcdClient.QueryListPage<T> previous() {
            this.container = (ContainerType)VcdClientImpl.this.getResource((ReferenceType)this.getPrevPageUri(), this.container.getClass());
            return this.getResultsPage();
        }

        @Override
        public int nextIndex() {
            return this.container.getPage();
        }

        @Override
        public int previousIndex() {
            return this.container.getPage() - 2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(VcdClient.QueryListPage<T> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(VcdClient.QueryListPage<T> e) {
            throw new UnsupportedOperationException();
        }

        private VcdClient.QueryListPage<T> getResultsPage() {
            if (this.container instanceof QueryResultRecordsType) {
                return this.extractQueryResults((QueryResultRecordsType)this.container, this.queryResultClass);
            }
            return this.extractQueryResults((ReferencesType)this.container, this.queryResultClass);
        }

        private <QueryResultClass> VcdClient.QueryListPage<QueryResultClass> extractQueryResults(QueryResultRecordsType queryResultRecordsType, Class<QueryResultClass> queryResultClass) {
            ArrayList<QueryResultClass> queryResultRecordList = new ArrayList<QueryResultClass>();
            for (JAXBElement element : queryResultRecordsType.getRecord()) {
                QueryResultRecordType queryResultRecord = (QueryResultRecordType)element.getValue();
                assert (queryResultRecord != null) : "Record is present but value is null";
                queryResultRecordList.add(queryResultClass.cast(queryResultRecord));
            }
            return new VcdClient.QueryListPage(queryResultRecordList, queryResultRecordsType.getTotal());
        }

        private <QueryResultClass> VcdClient.QueryListPage<QueryResultClass> extractQueryResults(ReferencesType referencesType, Class<QueryResultClass> queryResultClass) {
            ArrayList<Object> referenceList = new ArrayList<Object>();
            for (JAXBElement ref : referencesType.getReference()) {
                Object referenceType = ref.getValue();
                assert (referencesType != null) : "Reference present but value is null";
                referenceList.add(referenceType);
            }
            return new VcdClient.QueryListPage(referenceList, referencesType.getTotal());
        }

        private LinkType getNextPageUri() {
            return VcdUtils.findLink((ResourceType)this.container, RelationType.NEXT_PAGE, this.container.getType(), false);
        }

        private LinkType getPrevPageUri() {
            return VcdUtils.findLink((ResourceType)this.container, RelationType.PREVIOUS_PAGE, this.container.getType(), false);
        }
    }

    private static enum WellKnownEndpoint {
        ENTITY_RESOLVER(RelationType.ENTITY_RESOLVER, "application/vnd.vmware.vcloud.entity+xml"),
        LOGGED_IN_ORG(RelationType.DOWN, "application/vnd.vmware.vcloud.org+xml"),
        ORG_LIST(RelationType.DOWN, "application/vnd.vmware.vcloud.orgList+xml"),
        QUERY_LIST(RelationType.DOWN, "application/vnd.vmware.vcloud.query.queryList+xml"),
        ADMIN(RelationType.DOWN, "application/vnd.vmware.admin.vcloud+xml"),
        API_EXTENSIBILITY(RelationType.API_EXTENSIBILITY, "application/vnd.vmware.vcloud.apiextensibility+xml"),
        EXTENSION(RelationType.DOWN, "application/vnd.vmware.admin.vmwExtension+xml"),
        OPENAPI(RelationType.OPENAPI, "application/json");

        private final String mediaType;
        private final RelationType rel;

        private WellKnownEndpoint(RelationType rel, String mediaType) {
            this.rel = rel;
            this.mediaType = mediaType;
        }

        static Map<WellKnownEndpoint, URI> getSessionEndpoints(SessionType session) {
            HashMap<WellKnownEndpoint, URI> map = new HashMap<WellKnownEndpoint, URI>();
            for (WellKnownEndpoint endpoint : WellKnownEndpoint.values()) {
                LinkType link = VcdUtils.findLink((ResourceType)session, endpoint.rel, endpoint.mediaType, false);
                if (link == null) continue;
                map.put(endpoint, URI.create(link.getHref()));
            }
            return map;
        }
    }

    public static final class SessionTokenImpl
    implements VcdClient.SessionToken {
        private final String authenticationToken;
        private final String vCloudToken;

        public SessionTokenImpl(String authenticationToken, String vCloudToken) {
            this.authenticationToken = authenticationToken;
            this.vCloudToken = vCloudToken;
        }

        @Override
        public String getAuthenticationToken() {
            return this.authenticationToken;
        }

        public String getVCloudToken() {
            return this.vCloudToken;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SessionTokenImpl other = (SessionTokenImpl)obj;
            if (this.authenticationToken == null ? other.authenticationToken != null : !this.authenticationToken.equals(other.authenticationToken)) {
                return false;
            }
            return !(this.vCloudToken == null ? other.vCloudToken != null : !this.vCloudToken.equals(other.vCloudToken));
        }
    }
}

